/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage;

import io.deephaven.configuration.Configuration;
import io.deephaven.engine.table.AttributeMap;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.BlinkTableTools;
import io.deephaven.engine.table.impl.QueryTable;
import io.deephaven.extensions.barrage.BarrageSnapshotPerformanceLogger;
import io.deephaven.extensions.barrage.BarrageSnapshotPerformanceLoggerImpl;
import io.deephaven.extensions.barrage.BarrageSubscriptionPerformanceLogger;
import io.deephaven.extensions.barrage.BarrageSubscriptionPerformanceLoggerImpl;
import io.deephaven.time.DateTimeUtils;
import java.time.Instant;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BarragePerformanceLog {
    public static final boolean ALL_PERFORMANCE_ENABLED = Configuration.getInstance().getBooleanForClassWithDefault(BarragePerformanceLog.class, "enableAll", true);
    public static final long CYCLE_DURATION_MILLIS = Configuration.getInstance().getLongForClassWithDefault(BarragePerformanceLog.class, "cycleDurationMillis", 60000L);
    private static volatile BarragePerformanceLog INSTANCE;
    private final BarrageSubscriptionPerformanceLoggerImpl subImpl = new BarrageSubscriptionPerformanceLoggerImpl();
    private final BarrageSnapshotPerformanceLoggerImpl snapImpl = new BarrageSnapshotPerformanceLoggerImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BarragePerformanceLog getInstance() {
        BarragePerformanceLog local = INSTANCE;
        if (local != null) return local;
        Class<BarragePerformanceLog> clazz = BarragePerformanceLog.class;
        synchronized (BarragePerformanceLog.class) {
            local = INSTANCE;
            if (local != null) return local;
            INSTANCE = local = new BarragePerformanceLog();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return local;
        }
    }

    public static String getKeyFor(@NotNull Table table) {
        return BarragePerformanceLog.getKeyFor((AttributeMap)table, () -> ((Table)table).getDescription());
    }

    @Nullable
    public static String getKeyFor(@NotNull AttributeMap source, @NotNull Supplier<String> descriptionSupplier) {
        Object statsKey = source.getAttribute("BarragePerformanceTableKey");
        if (statsKey instanceof String) {
            return (String)statsKey;
        }
        if (ALL_PERFORMANCE_ENABLED) {
            return descriptionSupplier.get();
        }
        return null;
    }

    private BarragePerformanceLog() {
    }

    public QueryTable getSubscriptionTable() {
        return (QueryTable)BlinkTableTools.blinkToAppendOnly((Table)this.subImpl.blinkTable());
    }

    public BarrageSubscriptionPerformanceLogger getSubscriptionLogger() {
        return this.subImpl;
    }

    public QueryTable getSnapshotTable() {
        return (QueryTable)BlinkTableTools.blinkToAppendOnly((Table)this.snapImpl.blinkTable());
    }

    public BarrageSnapshotPerformanceLogger getSnapshotLogger() {
        return this.snapImpl;
    }

    public static class SnapshotMetricsHelper
    implements WriteMetricsConsumer {
        public final Instant requestTm = DateTimeUtils.now();
        public String tableId;
        public String tableKey;
        public long queueNanos;
        public long snapshotNanos;

        @Override
        public void onWrite(long bytesWritten, long writeNanos) {
            if (this.tableKey == null) {
                return;
            }
            BarragePerformanceLog.getInstance().getSnapshotLogger().log(this, writeNanos, bytesWritten);
        }
    }

    public static interface WriteMetricsConsumer {
        public void onWrite(long var1, long var3);
    }
}

