/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage;

import com.google.flatbuffers.FlatBufferBuilder;
import io.deephaven.annotations.BuildableStyle;
import io.deephaven.barrage.flatbuf.BarrageSnapshotRequest;
import io.deephaven.extensions.barrage.ColumnConversionMode;
import io.deephaven.extensions.barrage.ImmutableBarrageSnapshotOptions;
import io.deephaven.extensions.barrage.util.StreamReaderOptions;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class BarrageSnapshotOptions
implements StreamReaderOptions {
    public static Builder builder() {
        return ImmutableBarrageSnapshotOptions.builder();
    }

    public static BarrageSnapshotOptions of(io.deephaven.barrage.flatbuf.BarrageSnapshotOptions options) {
        if (options == null) {
            return BarrageSnapshotOptions.builder().build();
        }
        byte mode = options.columnConversionMode();
        return BarrageSnapshotOptions.builder().useDeephavenNulls(options.useDeephavenNulls()).columnConversionMode(ColumnConversionMode.conversionModeFbToEnum(mode)).batchSize(options.batchSize()).maxMessageSize(options.maxMessageSize()).build();
    }

    public static BarrageSnapshotOptions of(BarrageSnapshotRequest snapshotRequest) {
        return BarrageSnapshotOptions.of(snapshotRequest.snapshotOptions());
    }

    @Override
    @Value.Default
    public boolean useDeephavenNulls() {
        return false;
    }

    @Override
    @Value.Default
    public int batchSize() {
        return 0;
    }

    @Override
    @Value.Default
    public int maxMessageSize() {
        return 0;
    }

    @Override
    @Value.Default
    public ColumnConversionMode columnConversionMode() {
        return ColumnConversionMode.Stringify;
    }

    public int appendTo(FlatBufferBuilder builder) {
        return io.deephaven.barrage.flatbuf.BarrageSnapshotOptions.createBarrageSnapshotOptions((FlatBufferBuilder)builder, (byte)ColumnConversionMode.conversionModeEnumToFb(this.columnConversionMode()), (boolean)this.useDeephavenNulls(), (int)this.batchSize(), (int)this.maxMessageSize());
    }

    public static interface Builder {
        public Builder useDeephavenNulls(boolean var1);

        public Builder columnConversionMode(ColumnConversionMode var1);

        public Builder batchSize(int var1);

        public Builder maxMessageSize(int var1);

        public BarrageSnapshotOptions build();
    }
}

