/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage;

import io.deephaven.engine.context.ExecutionContext;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.updategraph.UpdateSourceRegistrar;
import io.deephaven.extensions.barrage.BarragePerformanceLog;
import io.deephaven.extensions.barrage.BarrageSnapshotPerformanceLogger;
import io.deephaven.extensions.barrage.BarrageSnapshotPerformanceStreamPublisher;
import io.deephaven.stream.StreamPublisher;
import io.deephaven.stream.StreamToBlinkTableAdapter;
import io.deephaven.time.DateTimeUtils;
import java.time.Instant;
import java.util.Map;

class BarrageSnapshotPerformanceLoggerImpl
implements BarrageSnapshotPerformanceLogger {
    private final BarrageSnapshotPerformanceStreamPublisher publisher = new BarrageSnapshotPerformanceStreamPublisher();
    private final StreamToBlinkTableAdapter adapter = new StreamToBlinkTableAdapter(BarrageSnapshotPerformanceStreamPublisher.definition(), (StreamPublisher)this.publisher, (UpdateSourceRegistrar)ExecutionContext.getContext().getUpdateGraph(), BarrageSnapshotPerformanceLoggerImpl.class.getName(), Map.of("BarragePerformanceTableKey", BarrageSnapshotPerformanceLogger.getDefaultTableName()));
    private final Table blink = this.adapter.table();

    @Override
    public void log(BarragePerformanceLog.SnapshotMetricsHelper helper, long writeNanos, long bytesWritten) {
        this.publisher.add(helper.tableId, helper.tableKey, DateTimeUtils.epochNanos((Instant)helper.requestTm), (double)helper.queueNanos / 1000000.0, (double)helper.snapshotNanos / 1000000.0, (double)writeNanos / 1000000.0, (double)(8L * bytesWritten) / 1000000.0);
    }

    public Table blinkTable() {
        return this.blink;
    }
}

