/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage;

import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnDefinition;
import io.deephaven.engine.table.TableDefinition;
import io.deephaven.stream.StreamChunkUtils;
import io.deephaven.stream.StreamConsumer;
import io.deephaven.stream.StreamPublisher;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

class BarrageSnapshotPerformanceStreamPublisher
implements StreamPublisher {
    private static final TableDefinition DEFINITION = TableDefinition.of((ColumnDefinition[])new ColumnDefinition[]{ColumnDefinition.ofString((String)"TableId"), ColumnDefinition.ofString((String)"TableKey"), ColumnDefinition.ofTime((String)"RequestTime"), ColumnDefinition.ofDouble((String)"QueueMillis"), ColumnDefinition.ofDouble((String)"SnapshotMillis"), ColumnDefinition.ofDouble((String)"WriteMillis"), ColumnDefinition.ofDouble((String)"WriteMegabits")});
    private static final int CHUNK_SIZE = 2048;
    private WritableChunk<Values>[] chunks = StreamChunkUtils.makeChunksForDefinition((TableDefinition)DEFINITION, (int)2048);
    private StreamConsumer consumer;

    public static TableDefinition definition() {
        return DEFINITION;
    }

    BarrageSnapshotPerformanceStreamPublisher() {
    }

    public void register(@NotNull StreamConsumer consumer) {
        if (this.consumer != null) {
            throw new IllegalStateException("Can not register multiple StreamConsumers.");
        }
        this.consumer = Objects.requireNonNull(consumer);
    }

    public synchronized void add(String tableId, String tableKey, long requestNanos, double queueMillis, double snapshotMillis, double writeMillis, double writeMegabits) {
        this.chunks[0].asWritableObjectChunk().add((Object)tableId);
        this.chunks[1].asWritableObjectChunk().add((Object)tableKey);
        this.chunks[2].asWritableLongChunk().add(requestNanos);
        this.chunks[3].asWritableDoubleChunk().add(queueMillis);
        this.chunks[4].asWritableDoubleChunk().add(snapshotMillis);
        this.chunks[5].asWritableDoubleChunk().add(writeMillis);
        this.chunks[6].asWritableDoubleChunk().add(writeMegabits);
        if (this.chunks[0].size() == 2048) {
            this.flushInternal();
        }
    }

    public synchronized void flush() {
        if (this.chunks[0].size() == 0) {
            return;
        }
        this.flushInternal();
    }

    private void flushInternal() {
        this.consumer.accept(this.chunks);
        this.chunks = StreamChunkUtils.makeChunksForDefinition((TableDefinition)DEFINITION, (int)2048);
    }

    public void acceptFailure(Throwable e) {
        this.consumer.acceptFailure(e);
    }

    public void shutdown() {
    }
}

