/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage;

import com.google.common.io.LittleEndianDataOutputStream;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.protobuf.ByteStringAccess;
import com.google.protobuf.CodedOutputStream;
import gnu.trove.list.array.TIntArrayList;
import io.deephaven.UncheckedDeephavenException;
import io.deephaven.barrage.flatbuf.BarrageMessageWrapper;
import io.deephaven.barrage.flatbuf.BarrageModColumnMetadata;
import io.deephaven.barrage.flatbuf.BarrageUpdateMetadata;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.chunk.sized.SizedChunk;
import io.deephaven.chunk.sized.SizedLongChunk;
import io.deephaven.configuration.Configuration;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetBuilderSequential;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.rowset.RowSetShiftData;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.engine.rowset.impl.ExternalizableRowSetUtils;
import io.deephaven.engine.table.impl.util.BarrageMessage;
import io.deephaven.extensions.barrage.BarragePerformanceLog;
import io.deephaven.extensions.barrage.BarrageSnapshotOptions;
import io.deephaven.extensions.barrage.BarrageStreamGenerator;
import io.deephaven.extensions.barrage.BarrageSubscriptionOptions;
import io.deephaven.extensions.barrage.chunk.BaseChunkInputStreamGenerator;
import io.deephaven.extensions.barrage.chunk.ChunkInputStreamGenerator;
import io.deephaven.extensions.barrage.chunk.SingleElementListHeaderInputStreamGenerator;
import io.deephaven.extensions.barrage.util.BarrageProtoUtil;
import io.deephaven.extensions.barrage.util.DefensiveDrainable;
import io.deephaven.extensions.barrage.util.StreamReaderOptions;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.proto.flight.util.MessageHelper;
import io.deephaven.util.SafeCloseable;
import io.deephaven.util.datastructures.LongSizedDataStructure;
import io.deephaven.util.datastructures.SizeException;
import io.grpc.Drainable;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import org.apache.arrow.flatbuf.Buffer;
import org.apache.arrow.flatbuf.FieldNode;
import org.apache.arrow.flatbuf.RecordBatch;
import org.apache.arrow.flight.impl.Flight;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BarrageStreamGeneratorImpl
implements BarrageStreamGenerator<View> {
    private static final Logger log = LoggerFactory.getLogger(BarrageStreamGeneratorImpl.class);
    private static final int DEFAULT_BATCH_SIZE = Configuration.getInstance().getIntegerForClassWithDefault(BarrageStreamGeneratorImpl.class, "batchSize", Integer.MAX_VALUE);
    private static final int DEFAULT_INITIAL_BATCH_SIZE = Configuration.getInstance().getIntegerForClassWithDefault(BarrageStreamGeneratorImpl.class, "initialBatchSize", 4096);
    private static final int DEFAULT_MESSAGE_SIZE_LIMIT = Configuration.getInstance().getIntegerForClassWithDefault(BarrageStreamGeneratorImpl.class, "maxOutboundMessageSize", 0x6400000);
    public final BarrageMessage message;
    public final BarragePerformanceLog.WriteMetricsConsumer writeConsumer;
    public final long firstSeq;
    public final long lastSeq;
    public final long step;
    public final boolean isSnapshot;
    public final RowSetGenerator rowsAdded;
    public final RowSetGenerator rowsIncluded;
    public final RowSetGenerator rowsRemoved;
    public final RowSetShiftDataGenerator shifted;
    public final ChunkListInputStreamGenerator[] addColumnData;
    public int addGeneratorCount = 0;
    public final ModColumnData[] modColumnData;

    public BarrageStreamGeneratorImpl(BarrageMessage message, BarragePerformanceLog.WriteMetricsConsumer writeConsumer) {
        this.message = message;
        this.writeConsumer = writeConsumer;
        try {
            int i;
            this.firstSeq = message.firstSeq;
            this.lastSeq = message.lastSeq;
            this.step = message.step;
            this.isSnapshot = message.isSnapshot;
            this.rowsAdded = new RowSetGenerator(message.rowsAdded);
            this.rowsIncluded = new RowSetGenerator(message.rowsIncluded);
            this.rowsRemoved = new RowSetGenerator(message.rowsRemoved);
            this.shifted = new RowSetShiftDataGenerator(message.shifted);
            this.addColumnData = new ChunkListInputStreamGenerator[message.addColumnData.length];
            for (i = 0; i < message.addColumnData.length; ++i) {
                this.addColumnData[i] = new ChunkListInputStreamGenerator(message.addColumnData[i]);
                this.addGeneratorCount = Math.max(this.addGeneratorCount, this.addColumnData[i].generators.length);
            }
            this.modColumnData = new ModColumnData[message.modColumnData.length];
            for (i = 0; i < this.modColumnData.length; ++i) {
                this.modColumnData[i] = new ModColumnData(message.modColumnData[i]);
            }
        }
        catch (IOException e) {
            throw new UncheckedDeephavenException("unexpected IOException while creating barrage message stream", (Throwable)e);
        }
        finally {
            if (message.snapshotRowSet != null) {
                message.snapshotRowSet.close();
            }
        }
    }

    @Override
    public BarrageMessage getMessage() {
        return this.message;
    }

    public void close() {
        this.rowsAdded.close();
        this.rowsIncluded.close();
        this.rowsRemoved.close();
        if (this.addColumnData != null) {
            for (ChunkListInputStreamGenerator in : this.addColumnData) {
                in.close();
            }
        }
        if (this.modColumnData != null) {
            for (ModColumnData mcd : this.modColumnData) {
                mcd.rowsModified.close();
                mcd.data.close();
            }
        }
    }

    @Override
    public SubView getSubView(BarrageSubscriptionOptions options, boolean isInitialSnapshot, @Nullable RowSet viewport, boolean reverseViewport, @Nullable RowSet keyspaceViewport, @Nullable BitSet subscribedColumns) {
        return new SubView(this, options, isInitialSnapshot, viewport, reverseViewport, keyspaceViewport, subscribedColumns);
    }

    @Override
    public SubView getSubView(BarrageSubscriptionOptions options, boolean isInitialSnapshot) {
        return this.getSubView(options, isInitialSnapshot, null, false, null, null);
    }

    @Override
    public SnapshotView getSnapshotView(BarrageSnapshotOptions options, @Nullable RowSet viewport, boolean reverseViewport, @Nullable RowSet keyspaceViewport, @Nullable BitSet snapshotColumns) {
        return new SnapshotView(this, options, viewport, reverseViewport, keyspaceViewport, snapshotColumns);
    }

    @Override
    public SnapshotView getSnapshotView(BarrageSnapshotOptions options) {
        return this.getSnapshotView(options, null, false, null, null);
    }

    private InputStream getInputStream(View view, long offset, int targetBatchSize, MutableInt actualBatchSize, ByteBuffer metadata, ColumnVisitor columnVisitor) throws IOException {
        ConsecutiveDrainableStreams consecutiveDrainableStreams;
        int buffersOffset;
        int nodesOffset;
        long numRows;
        ArrayDeque<DrainableByteArrayInputStream> streams = new ArrayDeque<DrainableByteArrayInputStream>();
        MutableInt size = new MutableInt();
        Consumer<InputStream> addStream = is -> {
            try {
                int sz = is.available();
                if (sz == 0) {
                    is.close();
                    return;
                }
                streams.add((DrainableByteArrayInputStream)is);
                size.add(sz);
            }
            catch (IOException e) {
                throw new UncheckedDeephavenException("Unexpected IOException", (Throwable)e);
            }
            if (size.intValue() % 8 != 0) {
                int paddingBytes = 8 - size.intValue() % 8;
                size.add(paddingBytes);
                streams.add(new DrainableByteArrayInputStream(BaseChunkInputStreamGenerator.PADDING_BUFFER, 0, paddingBytes));
            }
        };
        FlatBufferBuilder header = new FlatBufferBuilder();
        try (SizedChunk nodeOffsets = new SizedChunk(ChunkType.Object);
             SizedLongChunk bufferInfos = new SizedLongChunk();){
            nodeOffsets.ensureCapacity(this.addColumnData.length);
            nodeOffsets.get().setSize(0);
            bufferInfos.ensureCapacity(this.addColumnData.length * 3);
            bufferInfos.get().setSize(0);
            MutableLong totalBufferLength = new MutableLong();
            ChunkInputStreamGenerator.FieldNodeListener fieldNodeListener = (numElements, nullCount) -> {
                nodeOffsets.ensureCapacityPreserve(nodeOffsets.get().size() + 1);
                nodeOffsets.get().asWritableObjectChunk().add((Object)new ChunkInputStreamGenerator.FieldNodeInfo(numElements, nullCount));
            };
            ChunkInputStreamGenerator.BufferListener bufferListener = length -> {
                totalBufferLength.add(length);
                bufferInfos.ensureCapacityPreserve(bufferInfos.get().size() + 1);
                bufferInfos.get().add(length);
            };
            numRows = columnVisitor.visit(view, offset, targetBatchSize, addStream, fieldNodeListener, bufferListener);
            actualBatchSize.setValue((Number)numRows);
            WritableChunk noChunk = nodeOffsets.get();
            RecordBatch.startNodesVector((FlatBufferBuilder)header, (int)noChunk.size());
            for (int i = noChunk.size() - 1; i >= 0; --i) {
                ChunkInputStreamGenerator.FieldNodeInfo node = (ChunkInputStreamGenerator.FieldNodeInfo)noChunk.asObjectChunk().get(i);
                FieldNode.createFieldNode((FlatBufferBuilder)header, (long)node.numElements, (long)node.nullCount);
            }
            nodesOffset = header.endVector();
            WritableLongChunk biChunk = bufferInfos.get();
            RecordBatch.startBuffersVector((FlatBufferBuilder)header, (int)biChunk.size());
            for (int i = biChunk.size() - 1; i >= 0; --i) {
                totalBufferLength.subtract(biChunk.get(i));
                Buffer.createBuffer((FlatBufferBuilder)header, (long)totalBufferLength.longValue(), (long)biChunk.get(i));
            }
            buffersOffset = header.endVector();
        }
        RecordBatch.startRecordBatch((FlatBufferBuilder)header);
        RecordBatch.addNodes((FlatBufferBuilder)header, (int)nodesOffset);
        RecordBatch.addBuffers((FlatBufferBuilder)header, (int)buffersOffset);
        if (view.options().columnsAsList()) {
            RecordBatch.addLength((FlatBufferBuilder)header, (long)1L);
        } else {
            RecordBatch.addLength((FlatBufferBuilder)header, (long)numRows);
        }
        int headerOffset = RecordBatch.endRecordBatch((FlatBufferBuilder)header);
        header.finish(MessageHelper.wrapInMessage((FlatBufferBuilder)header, (int)headerOffset, (byte)3, (int)size.intValue()));
        BarrageProtoUtil.ExposedByteArrayOutputStream baos = new BarrageProtoUtil.ExposedByteArrayOutputStream();
        try {
            this.writeHeader(metadata, size, header, baos);
            streams.addFirst(new DrainableByteArrayInputStream(baos.peekBuffer(), 0, baos.size()));
            consecutiveDrainableStreams = new ConsecutiveDrainableStreams(streams.toArray(new InputStream[0]));
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new UncheckedDeephavenException("Unexpected IOException", (Throwable)ex);
            }
        }
        baos.close();
        return consecutiveDrainableStreams;
    }

    protected void writeHeader(ByteBuffer metadata, MutableInt size, FlatBufferBuilder header, BarrageProtoUtil.ExposedByteArrayOutputStream baos) throws IOException {
        CodedOutputStream cos = CodedOutputStream.newInstance((OutputStream)baos);
        cos.writeByteBuffer(2, header.dataBuffer().slice());
        if (metadata != null) {
            cos.writeByteBuffer(3, metadata);
        }
        cos.writeTag(1000, 2);
        cos.writeUInt32NoTag(size.intValue());
        cos.flush();
    }

    private static int createByteVector(FlatBufferBuilder builder, byte[] data, int offset, int length) {
        builder.startVector(1, length, 1);
        if (length > 0) {
            builder.prep(1, length - 1);
            for (int i = length - 1; i >= 0; --i) {
                builder.putByte(data[offset + i]);
            }
        }
        return builder.endVector();
    }

    private void processBatches(Consumer<InputStream> visitor, View view, long numRows, int maxBatchSize, ByteBuffer metadata, ColumnVisitor columnVisitor, MutableLong bytesWritten) throws IOException {
        boolean sendAllowed;
        long offset = 0L;
        MutableInt actualBatchSize = new MutableInt();
        int batchSize = Math.min(DEFAULT_INITIAL_BATCH_SIZE, maxBatchSize);
        int maxMessageSize = view.clientMaxMessageSize() > 0 ? view.clientMaxMessageSize() : DEFAULT_MESSAGE_SIZE_LIMIT;
        boolean bl = sendAllowed = numRows <= (long)batchSize;
        while (offset < numRows) {
            try {
                int bytesPerRow;
                InputStream is = this.getInputStream(view, offset, batchSize, actualBatchSize, metadata, columnVisitor);
                int bytesToWrite = is.available();
                if (actualBatchSize.intValue() == 0) {
                    throw new IllegalStateException("No data was written for a batch");
                }
                if (sendAllowed && (bytesToWrite < maxMessageSize || batchSize == 1)) {
                    visitor.accept(is);
                    bytesWritten.add((long)bytesToWrite);
                    offset += (long)actualBatchSize.intValue();
                    metadata = null;
                } else {
                    is.close();
                    sendAllowed = true;
                }
                if ((bytesPerRow = bytesToWrite / actualBatchSize.intValue()) <= 0) continue;
                int rowLimit = maxMessageSize / bytesPerRow;
                batchSize = Math.min(maxBatchSize, Math.max(1, (int)((double)rowLimit * 0.9)));
            }
            catch (SizeException ex) {
                if (batchSize == 1) {
                    throw new UncheckedDeephavenException("BarrageStreamGenerator - single row (" + offset + ") exceeds transmissible size", (Throwable)ex);
                }
                int maximumSize = LongSizedDataStructure.intSize((String)"BarrageStreamGenerator", (long)ex.getMaximumSize());
                batchSize = maximumSize >= batchSize ? batchSize / 2 : maximumSize;
            }
        }
    }

    private static int findGeneratorForOffset(ChunkInputStreamGenerator[] generators, long offset) {
        if (generators.length <= 1) {
            return 0;
        }
        int low = 0;
        int high = generators.length;
        while (low + 1 < high) {
            int mid = (low + high) / 2;
            int cmp = Long.compare(generators[mid].getRowOffset(), offset);
            if (cmp < 0) {
                low = mid;
                continue;
            }
            if (cmp > 0) {
                high = mid;
                continue;
            }
            return mid;
        }
        return low;
    }

    /*
     * Exception decompiling
     */
    private long appendAddColumns(View view, long startRange, int targetBatchSize, Consumer<InputStream> addStream, ChunkInputStreamGenerator.FieldNodeListener fieldNodeListener, ChunkInputStreamGenerator.BufferListener bufferListener) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long appendModColumns(View view, long startRange, int targetBatchSize, Consumer<InputStream> addStream, ChunkInputStreamGenerator.FieldNodeListener fieldNodeListener, ChunkInputStreamGenerator.BufferListener bufferListener) throws IOException {
        int[] columnChunkIdx = new int[this.modColumnData.length];
        long maxLength = targetBatchSize;
        for (int ii = 0; ii < this.modColumnData.length; ++ii) {
            long startPos;
            ModColumnData mcd = this.modColumnData[ii];
            ChunkInputStreamGenerator[] generators = mcd.data.generators;
            if (generators.length == 0) continue;
            RowSet modOffsets = view.modRowOffsets(ii);
            long l = startPos = modOffsets != null ? modOffsets.get(startRange) : startRange;
            if (startPos == -1L) continue;
            int chunkIdx = BarrageStreamGeneratorImpl.findGeneratorForOffset(generators, startPos);
            if (chunkIdx < generators.length - 1) {
                maxLength = Math.min(maxLength, generators[chunkIdx].getLastRowOffset() + 1L - startPos);
            }
            columnChunkIdx[ii] = chunkIdx;
        }
        long numRows = 0L;
        for (int ii = 0; ii < this.modColumnData.length; ++ii) {
            WritableRowSet myModOffsets;
            long endPos;
            long startPos;
            ModColumnData mcd = this.modColumnData[ii];
            ChunkInputStreamGenerator generator = mcd.data.generators.length > 0 ? mcd.data.generators[columnChunkIdx[ii]] : null;
            RowSet modOffsets = view.modRowOffsets(ii);
            if (modOffsets != null) {
                startPos = modOffsets.get(startRange);
                long endRange = startRange + maxLength - 1L;
                endPos = endRange >= modOffsets.size() ? modOffsets.lastRowKey() : modOffsets.get(endRange);
            } else if (startRange >= mcd.rowsModified.original.size()) {
                startPos = -1L;
                endPos = -1L;
            } else {
                startPos = startRange;
                endPos = startRange + maxLength - 1L;
                if (generator != null) {
                    endPos = Math.min(endPos, generator.getLastRowOffset());
                }
            }
            if (startPos == -1L) {
                myModOffsets = RowSetFactory.empty();
            } else if (modOffsets != null) {
                try (WritableRowSet allowedRange = RowSetFactory.fromRange((long)startPos, (long)endPos);){
                    myModOffsets = modOffsets.intersect((RowSet)allowedRange);
                }
            } else {
                myModOffsets = RowSetFactory.fromRange((long)startPos, (long)endPos);
            }
            numRows = Math.max(numRows, myModOffsets.size());
            try {
                int numElements;
                int n = numElements = generator == null ? 0 : myModOffsets.intSize("BarrageStreamGenerator");
                if (view.options().columnsAsList()) {
                    SingleElementListHeaderInputStreamGenerator listHeader = new SingleElementListHeaderInputStreamGenerator(numElements);
                    listHeader.visitFieldNodes(fieldNodeListener);
                    listHeader.visitBuffers(bufferListener);
                    addStream.accept(listHeader);
                }
                if (numElements == 0) {
                    try (WritableRowSet empty = RowSetFactory.empty();){
                        ChunkInputStreamGenerator.DrainableColumn drainableColumn = mcd.data.emptyGenerator.getInputStream(view.options(), (RowSet)empty);
                        drainableColumn.visitFieldNodes(fieldNodeListener);
                        drainableColumn.visitBuffers(bufferListener);
                        addStream.accept(drainableColumn);
                        continue;
                    }
                }
                long shift = -generator.getRowOffset();
                try (WritableRowSet adjustedOffsets = shift == 0L ? null : myModOffsets.shift(shift);){
                    ChunkInputStreamGenerator.DrainableColumn drainableColumn = generator.getInputStream(view.options(), (RowSet)(shift == 0L ? myModOffsets : adjustedOffsets));
                    drainableColumn.visitFieldNodes(fieldNodeListener);
                    drainableColumn.visitBuffers(bufferListener);
                    addStream.accept(drainableColumn);
                    continue;
                }
            }
            finally {
                myModOffsets.close();
            }
        }
        return numRows;
    }

    private ByteBuffer getSubscriptionMetadata(SubView view) throws IOException {
        FlatBufferBuilder metadata = new FlatBufferBuilder();
        int effectiveViewportOffset = 0;
        if (this.isSnapshot && view.isViewport()) {
            try (RowSetGenerator viewportGen = new RowSetGenerator(view.viewport);){
                effectiveViewportOffset = viewportGen.addToFlatBuffer(metadata);
            }
        }
        int effectiveColumnSetOffset = 0;
        if (this.isSnapshot && view.subscribedColumns != null) {
            effectiveColumnSetOffset = new BitSetGenerator(view.subscribedColumns).addToFlatBuffer(metadata);
        }
        int rowsAddedOffset = this.isSnapshot && !view.isInitialSnapshot ? EmptyRowSetGenerator.INSTANCE.addToFlatBuffer(metadata) : this.rowsAdded.addToFlatBuffer(metadata);
        int rowsRemovedOffset = this.rowsRemoved.addToFlatBuffer(metadata);
        int shiftDataOffset = this.shifted.addToFlatBuffer(metadata);
        int addedRowsIncludedOffset = 0;
        if (this.isSnapshot || !view.addRowKeys.equals(this.rowsAdded.original)) {
            addedRowsIncludedOffset = this.rowsIncluded.addToFlatBuffer(view.addRowKeys, metadata);
        }
        TIntArrayList modOffsets = new TIntArrayList(this.modColumnData.length);
        for (ModColumnData mcd : this.modColumnData) {
            int myModRowOffset = view.keyspaceViewport != null ? mcd.rowsModified.addToFlatBuffer(view.keyspaceViewport, metadata) : mcd.rowsModified.addToFlatBuffer(metadata);
            modOffsets.add(BarrageModColumnMetadata.createBarrageModColumnMetadata((FlatBufferBuilder)metadata, (int)myModRowOffset));
        }
        BarrageUpdateMetadata.startModColumnNodesVector((FlatBufferBuilder)metadata, (int)modOffsets.size());
        modOffsets.forEachDescending(offset -> {
            metadata.addOffset(offset);
            return true;
        });
        int nodesOffset = metadata.endVector();
        BarrageUpdateMetadata.startBarrageUpdateMetadata((FlatBufferBuilder)metadata);
        BarrageUpdateMetadata.addIsSnapshot((FlatBufferBuilder)metadata, (boolean)this.isSnapshot);
        BarrageUpdateMetadata.addFirstSeq((FlatBufferBuilder)metadata, (long)this.firstSeq);
        BarrageUpdateMetadata.addLastSeq((FlatBufferBuilder)metadata, (long)this.lastSeq);
        BarrageUpdateMetadata.addEffectiveViewport((FlatBufferBuilder)metadata, (int)effectiveViewportOffset);
        BarrageUpdateMetadata.addEffectiveColumnSet((FlatBufferBuilder)metadata, (int)effectiveColumnSetOffset);
        BarrageUpdateMetadata.addAddedRows((FlatBufferBuilder)metadata, (int)rowsAddedOffset);
        BarrageUpdateMetadata.addRemovedRows((FlatBufferBuilder)metadata, (int)rowsRemovedOffset);
        BarrageUpdateMetadata.addShiftData((FlatBufferBuilder)metadata, (int)shiftDataOffset);
        BarrageUpdateMetadata.addAddedRowsIncluded((FlatBufferBuilder)metadata, (int)addedRowsIncludedOffset);
        BarrageUpdateMetadata.addModColumnNodes((FlatBufferBuilder)metadata, (int)nodesOffset);
        BarrageUpdateMetadata.addEffectiveReverseViewport((FlatBufferBuilder)metadata, (boolean)view.reverseViewport);
        metadata.finish(BarrageUpdateMetadata.endBarrageUpdateMetadata((FlatBufferBuilder)metadata));
        FlatBufferBuilder header = new FlatBufferBuilder();
        int payloadOffset = BarrageMessageWrapper.createMsgPayloadVector((FlatBufferBuilder)header, (ByteBuffer)metadata.dataBuffer());
        BarrageMessageWrapper.startBarrageMessageWrapper((FlatBufferBuilder)header);
        BarrageMessageWrapper.addMagic((FlatBufferBuilder)header, (long)1852338276L);
        BarrageMessageWrapper.addMsgType((FlatBufferBuilder)header, (byte)6);
        BarrageMessageWrapper.addMsgPayload((FlatBufferBuilder)header, (int)payloadOffset);
        header.finish(BarrageMessageWrapper.endBarrageMessageWrapper((FlatBufferBuilder)header));
        return header.dataBuffer().slice();
    }

    private ByteBuffer getSnapshotMetadata(SnapshotView view) throws IOException {
        FlatBufferBuilder metadata = new FlatBufferBuilder();
        int effectiveViewportOffset = 0;
        if (view.isViewport()) {
            try (RowSetGenerator viewportGen = new RowSetGenerator(view.viewport);){
                effectiveViewportOffset = viewportGen.addToFlatBuffer(metadata);
            }
        }
        int effectiveColumnSetOffset = 0;
        if (view.subscribedColumns != null) {
            effectiveColumnSetOffset = new BitSetGenerator(view.subscribedColumns).addToFlatBuffer(metadata);
        }
        int rowsAddedOffset = this.rowsAdded.addToFlatBuffer(metadata);
        int shiftDataOffset = this.shifted.addToFlatBuffer(metadata);
        int addedRowsIncludedOffset = 0;
        if (this.isSnapshot || !view.addRowKeys.equals(this.rowsAdded.original)) {
            addedRowsIncludedOffset = this.rowsIncluded.addToFlatBuffer(view.addRowKeys, metadata);
        }
        BarrageUpdateMetadata.startBarrageUpdateMetadata((FlatBufferBuilder)metadata);
        BarrageUpdateMetadata.addIsSnapshot((FlatBufferBuilder)metadata, (boolean)this.isSnapshot);
        BarrageUpdateMetadata.addFirstSeq((FlatBufferBuilder)metadata, (long)this.firstSeq);
        BarrageUpdateMetadata.addLastSeq((FlatBufferBuilder)metadata, (long)this.lastSeq);
        BarrageUpdateMetadata.addEffectiveViewport((FlatBufferBuilder)metadata, (int)effectiveViewportOffset);
        BarrageUpdateMetadata.addEffectiveColumnSet((FlatBufferBuilder)metadata, (int)effectiveColumnSetOffset);
        BarrageUpdateMetadata.addAddedRows((FlatBufferBuilder)metadata, (int)rowsAddedOffset);
        BarrageUpdateMetadata.addRemovedRows((FlatBufferBuilder)metadata, (int)0);
        BarrageUpdateMetadata.addShiftData((FlatBufferBuilder)metadata, (int)shiftDataOffset);
        BarrageUpdateMetadata.addAddedRowsIncluded((FlatBufferBuilder)metadata, (int)addedRowsIncludedOffset);
        BarrageUpdateMetadata.addModColumnNodes((FlatBufferBuilder)metadata, (int)0);
        BarrageUpdateMetadata.addEffectiveReverseViewport((FlatBufferBuilder)metadata, (boolean)view.reverseViewport);
        metadata.finish(BarrageUpdateMetadata.endBarrageUpdateMetadata((FlatBufferBuilder)metadata));
        FlatBufferBuilder header = new FlatBufferBuilder();
        int payloadOffset = BarrageMessageWrapper.createMsgPayloadVector((FlatBufferBuilder)header, (ByteBuffer)metadata.dataBuffer());
        BarrageMessageWrapper.startBarrageMessageWrapper((FlatBufferBuilder)header);
        BarrageMessageWrapper.addMagic((FlatBufferBuilder)header, (long)1852338276L);
        BarrageMessageWrapper.addMsgType((FlatBufferBuilder)header, (byte)6);
        BarrageMessageWrapper.addMsgPayload((FlatBufferBuilder)header, (int)payloadOffset);
        header.finish(BarrageMessageWrapper.endBarrageMessageWrapper((FlatBufferBuilder)header));
        return header.dataBuffer().slice();
    }

    private static final class EmptyRowSetGenerator
    extends RowSetGenerator {
        public static final EmptyRowSetGenerator INSTANCE;

        EmptyRowSetGenerator() throws IOException {
            super((RowSet)RowSetFactory.empty());
        }

        @Override
        public void close() {
        }

        static {
            try {
                INSTANCE = new EmptyRowSetGenerator();
            }
            catch (IOException ioe) {
                throw new UncheckedDeephavenException((Throwable)ioe);
            }
        }
    }

    public static class ConsecutiveDrainableStreams
    extends DefensiveDrainable {
        final InputStream[] streams;

        public ConsecutiveDrainableStreams(InputStream ... streams) {
            this.streams = streams;
            for (InputStream stream : streams) {
                if (stream instanceof Drainable) continue;
                throw new IllegalArgumentException("expecting sub-class of Drainable; found: " + stream.getClass());
            }
        }

        public int drainTo(OutputStream outputStream) throws IOException {
            int total = 0;
            for (InputStream stream : this.streams) {
                int expected = total + stream.available();
                if (expected != (total += ((Drainable)stream).drainTo(outputStream))) {
                    throw new IllegalStateException("drained message drained wrong number of bytes");
                }
                if (total >= 0) continue;
                throw new IllegalStateException("drained message is too large; exceeds Integer.MAX_VALUE");
            }
            return total;
        }

        @Override
        public int available() throws SizeException, IOException {
            int total = 0;
            for (InputStream stream : this.streams) {
                if ((total += stream.available()) >= 0) continue;
                throw new SizeException("drained message is too large; exceeds Integer.MAX_VALUE", (long)total);
            }
            return total;
        }

        @Override
        public void close() throws IOException {
            for (InputStream stream : this.streams) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new UncheckedDeephavenException("unexpected IOException", (Throwable)e);
                }
            }
            super.close();
        }
    }

    public static class DrainableByteArrayInputStream
    extends DefensiveDrainable {
        private byte[] buf;
        private final int offset;
        private final int length;

        public DrainableByteArrayInputStream(byte[] buf, int offset, int length) {
            this.buf = Objects.requireNonNull(buf);
            this.offset = offset;
            this.length = length;
        }

        @Override
        public int available() {
            if (this.buf == null) {
                return 0;
            }
            return this.length;
        }

        public int drainTo(OutputStream outputStream) throws IOException {
            if (this.buf != null) {
                try {
                    outputStream.write(this.buf, this.offset, this.length);
                }
                finally {
                    this.buf = null;
                }
                return this.length;
            }
            return 0;
        }
    }

    public static class RowSetShiftDataGenerator
    extends ByteArrayGenerator {
        public final RowSetShiftData original;

        public RowSetShiftDataGenerator(RowSetShiftData shifted) throws IOException {
            this.original = shifted;
            RowSetBuilderSequential sRangeBuilder = RowSetFactory.builderSequential();
            RowSetBuilderSequential eRangeBuilder = RowSetFactory.builderSequential();
            RowSetBuilderSequential destBuilder = RowSetFactory.builderSequential();
            if (shifted != null) {
                for (int i = 0; i < shifted.size(); ++i) {
                    long s = shifted.getBeginRange(i);
                    long dt = shifted.getShiftDelta(i);
                    if (dt < 0L && s < -dt) {
                        s = -dt;
                    }
                    sRangeBuilder.appendKey(s);
                    eRangeBuilder.appendKey(shifted.getEndRange(i));
                    destBuilder.appendKey(s + dt);
                }
            }
            try (WritableRowSet sRange = sRangeBuilder.build();
                 WritableRowSet eRange = eRangeBuilder.build();
                 WritableRowSet dest = destBuilder.build();
                 BarrageProtoUtil.ExposedByteArrayOutputStream baos = new BarrageProtoUtil.ExposedByteArrayOutputStream();
                 LittleEndianDataOutputStream oos = new LittleEndianDataOutputStream((OutputStream)baos);){
                ExternalizableRowSetUtils.writeExternalCompressedDeltas((DataOutput)oos, (RowSet)sRange);
                ExternalizableRowSetUtils.writeExternalCompressedDeltas((DataOutput)oos, (RowSet)eRange);
                ExternalizableRowSetUtils.writeExternalCompressedDeltas((DataOutput)oos, (RowSet)dest);
                oos.flush();
                this.raw = baos.peekBuffer();
                this.len = baos.size();
            }
        }
    }

    public static class BitSetGenerator
    extends ByteArrayGenerator {
        public final BitSet original;

        public BitSetGenerator(BitSet bitset) throws IOException {
            this.original = bitset == null ? new BitSet() : bitset;
            this.raw = this.original.toByteArray();
            int nBits = this.original.previousSetBit(0x7FFFFFFE) + 1;
            this.len = (int)((long)nBits + 7L) / 8;
        }

        public int addToFlatBuffer(BitSet mine, FlatBufferBuilder builder) throws IOException {
            if (mine.equals(this.original)) {
                return this.addToFlatBuffer(builder);
            }
            byte[] nraw = mine.toByteArray();
            int nBits = mine.previousSetBit(0x7FFFFFFE) + 1;
            int nlen = (int)((long)nBits + 7L) / 8;
            return BarrageStreamGeneratorImpl.createByteVector(builder, nraw, 0, nlen);
        }
    }

    public static class RowSetGenerator
    extends ByteArrayGenerator
    implements SafeCloseable {
        public final RowSet original;

        public RowSetGenerator(RowSet rowSet) throws IOException {
            this.original = rowSet.copy();
            try (BarrageProtoUtil.ExposedByteArrayOutputStream baos = new BarrageProtoUtil.ExposedByteArrayOutputStream();
                 LittleEndianDataOutputStream oos = new LittleEndianDataOutputStream((OutputStream)baos);){
                ExternalizableRowSetUtils.writeExternalCompressedDeltas((DataOutput)oos, (RowSet)rowSet);
                oos.flush();
                this.raw = baos.peekBuffer();
                this.len = baos.size();
            }
        }

        public void close() {
            this.original.close();
        }

        public DrainableByteArrayInputStream getInputStream() {
            return new DrainableByteArrayInputStream(this.raw, 0, this.len);
        }

        protected int addToFlatBuffer(RowSet viewport, FlatBufferBuilder builder) throws IOException {
            int nlen;
            byte[] nraw;
            if (this.original.subsetOf(viewport)) {
                return this.addToFlatBuffer(builder);
            }
            try (BarrageProtoUtil.ExposedByteArrayOutputStream baos = new BarrageProtoUtil.ExposedByteArrayOutputStream();
                 LittleEndianDataOutputStream oos = new LittleEndianDataOutputStream((OutputStream)baos);
                 WritableRowSet viewOfOriginal = this.original.intersect(viewport);){
                ExternalizableRowSetUtils.writeExternalCompressedDeltas((DataOutput)oos, (RowSet)viewOfOriginal);
                oos.flush();
                nraw = baos.peekBuffer();
                nlen = baos.size();
            }
            return BarrageStreamGeneratorImpl.createByteVector(builder, nraw, 0, nlen);
        }
    }

    public static abstract class ByteArrayGenerator {
        protected int len;
        protected byte[] raw;

        protected int addToFlatBuffer(FlatBufferBuilder builder) {
            return BarrageStreamGeneratorImpl.createByteVector(builder, this.raw, 0, this.len);
        }
    }

    @FunctionalInterface
    private static interface ColumnVisitor {
        public long visit(View var1, long var2, int var4, Consumer<InputStream> var5, ChunkInputStreamGenerator.FieldNodeListener var6, ChunkInputStreamGenerator.BufferListener var7) throws IOException;
    }

    public static class SchemaView
    implements View {
        final byte[] msgBytes;

        public SchemaView(ByteBuffer buffer) {
            this.msgBytes = Flight.FlightData.newBuilder().setDataHeader(ByteStringAccess.wrap((ByteBuffer)buffer)).build().toByteArray();
        }

        @Override
        public void forEachStream(Consumer<InputStream> visitor) {
            visitor.accept(new DrainableByteArrayInputStream(this.msgBytes, 0, this.msgBytes.length));
        }

        @Override
        public boolean isViewport() {
            return false;
        }

        @Override
        public StreamReaderOptions options() {
            return null;
        }

        @Override
        public int clientMaxMessageSize() {
            return 0;
        }

        @Override
        public RowSet addRowOffsets() {
            return null;
        }

        @Override
        public RowSet modRowOffsets(int col) {
            return null;
        }
    }

    public static class SnapshotView
    implements View {
        public final BarrageStreamGeneratorImpl generator;
        public final BarrageSnapshotOptions options;
        public final RowSet viewport;
        public final boolean reverseViewport;
        public final RowSet keyspaceViewport;
        public final BitSet subscribedColumns;
        public final long numAddRows;
        public final RowSet addRowKeys;
        public final RowSet addRowOffsets;

        public SnapshotView(BarrageStreamGeneratorImpl generator, BarrageSnapshotOptions options, @Nullable RowSet viewport, boolean reverseViewport, @Nullable RowSet keyspaceViewport, @Nullable BitSet subscribedColumns) {
            this.generator = generator;
            this.options = options;
            this.viewport = viewport;
            this.reverseViewport = reverseViewport;
            this.keyspaceViewport = keyspaceViewport;
            this.subscribedColumns = subscribedColumns;
            if (keyspaceViewport != null) {
                this.addRowKeys = keyspaceViewport.intersect(generator.rowsIncluded.original);
                this.addRowOffsets = generator.rowsIncluded.original.invert(this.addRowKeys);
            } else {
                this.addRowKeys = generator.rowsAdded.original.copy();
                this.addRowOffsets = RowSetFactory.flat((long)this.addRowKeys.size());
            }
            this.numAddRows = this.addRowOffsets.size();
        }

        @Override
        public void forEachStream(Consumer<InputStream> visitor) throws IOException {
            long startTm = System.nanoTime();
            ByteBuffer metadata = this.generator.getSnapshotMetadata(this);
            MutableLong bytesWritten = new MutableLong(0L);
            int maxBatchSize = this.batchSize();
            MutableInt actualBatchSize = new MutableInt();
            if (this.numAddRows == 0L) {
                visitor.accept(this.generator.getInputStream(this, 0L, 0, actualBatchSize, metadata, (x$0, x$1, x$2, x$3, x$4, x$5) -> this.generator.appendAddColumns(x$0, x$1, x$2, x$3, x$4, x$5)));
            } else {
                this.generator.processBatches(visitor, this, this.numAddRows, maxBatchSize, metadata, (x$0, x$1, x$2, x$3, x$4, x$5) -> this.generator.appendAddColumns(x$0, x$1, x$2, x$3, x$4, x$5), bytesWritten);
            }
            this.addRowOffsets.close();
            this.addRowKeys.close();
            this.generator.writeConsumer.onWrite(bytesWritten.longValue(), System.nanoTime() - startTm);
        }

        private int batchSize() {
            int batchSize = this.options().batchSize();
            if (batchSize <= 0) {
                batchSize = DEFAULT_BATCH_SIZE;
            }
            return batchSize;
        }

        @Override
        public int clientMaxMessageSize() {
            return this.options.maxMessageSize();
        }

        @Override
        public boolean isViewport() {
            return this.viewport != null;
        }

        @Override
        public final StreamReaderOptions options() {
            return this.options;
        }

        @Override
        public RowSet addRowOffsets() {
            return this.addRowOffsets;
        }

        @Override
        public RowSet modRowOffsets(int col) {
            throw new UnsupportedOperationException("asked for mod row on SnapshotView");
        }
    }

    public static class SubView
    implements View {
        public final BarrageStreamGeneratorImpl generator;
        public final BarrageSubscriptionOptions options;
        public final boolean isInitialSnapshot;
        public final RowSet viewport;
        public final boolean reverseViewport;
        public final RowSet keyspaceViewport;
        public final BitSet subscribedColumns;
        public final long numAddRows;
        public final long numModRows;
        public final RowSet addRowOffsets;
        public final RowSet addRowKeys;
        public final RowSet[] modRowOffsets;

        public SubView(BarrageStreamGeneratorImpl generator, BarrageSubscriptionOptions options, boolean isInitialSnapshot, @Nullable RowSet viewport, boolean reverseViewport, @Nullable RowSet keyspaceViewport, @Nullable BitSet subscribedColumns) {
            this.generator = generator;
            this.options = options;
            this.isInitialSnapshot = isInitialSnapshot;
            this.viewport = viewport;
            this.reverseViewport = reverseViewport;
            this.keyspaceViewport = keyspaceViewport;
            this.subscribedColumns = subscribedColumns;
            this.modRowOffsets = keyspaceViewport != null ? new WritableRowSet[generator.modColumnData.length] : null;
            long numModRows = 0L;
            for (int ii = 0; ii < generator.modColumnData.length; ++ii) {
                ModColumnData mcd = generator.modColumnData[ii];
                if (keyspaceViewport != null) {
                    try (WritableRowSet intersect = keyspaceViewport.intersect(mcd.rowsModified.original);){
                        this.modRowOffsets[ii] = mcd.rowsModified.original.invert((RowSet)intersect);
                        numModRows = Math.max(numModRows, intersect.size());
                        continue;
                    }
                }
                numModRows = Math.max(numModRows, mcd.rowsModified.original.size());
            }
            this.numModRows = numModRows;
            if (keyspaceViewport != null) {
                this.addRowKeys = keyspaceViewport.intersect(generator.rowsIncluded.original);
                this.addRowOffsets = generator.rowsIncluded.original.invert(this.addRowKeys);
            } else if (!generator.rowsAdded.original.equals(generator.rowsIncluded.original)) {
                this.addRowKeys = generator.rowsAdded.original.copy();
                this.addRowOffsets = generator.rowsIncluded.original.invert(this.addRowKeys);
            } else {
                this.addRowKeys = generator.rowsAdded.original.copy();
                this.addRowOffsets = RowSetFactory.flat((long)generator.rowsAdded.original.size());
            }
            this.numAddRows = this.addRowOffsets.size();
        }

        @Override
        public void forEachStream(Consumer<InputStream> visitor) throws IOException {
            long startTm = System.nanoTime();
            ByteBuffer metadata = this.generator.getSubscriptionMetadata(this);
            MutableLong bytesWritten = new MutableLong(0L);
            int maxBatchSize = this.batchSize();
            MutableInt actualBatchSize = new MutableInt();
            if (this.numAddRows == 0L && this.numModRows == 0L) {
                InputStream is = this.generator.getInputStream(this, 0L, 0, actualBatchSize, metadata, (x$0, x$1, x$2, x$3, x$4, x$5) -> this.generator.appendAddColumns(x$0, x$1, x$2, x$3, x$4, x$5));
                bytesWritten.add((long)is.available());
                visitor.accept(is);
                this.generator.writeConsumer.onWrite(bytesWritten.longValue(), System.nanoTime() - startTm);
                return;
            }
            this.generator.processBatches(visitor, this, this.numAddRows, maxBatchSize, metadata, (x$0, x$1, x$2, x$3, x$4, x$5) -> this.generator.appendAddColumns(x$0, x$1, x$2, x$3, x$4, x$5), bytesWritten);
            this.generator.processBatches(visitor, this, this.numModRows, maxBatchSize, this.numAddRows > 0L ? null : metadata, (x$0, x$1, x$2, x$3, x$4, x$5) -> this.generator.appendModColumns(x$0, x$1, x$2, x$3, x$4, x$5), bytesWritten);
            this.addRowOffsets.close();
            this.addRowKeys.close();
            if (this.modRowOffsets != null) {
                for (RowSet modViewport : this.modRowOffsets) {
                    modViewport.close();
                }
            }
            this.generator.writeConsumer.onWrite(bytesWritten.longValue(), System.nanoTime() - startTm);
        }

        private int batchSize() {
            int batchSize = this.options().batchSize();
            if (batchSize <= 0) {
                batchSize = DEFAULT_BATCH_SIZE;
            }
            return batchSize;
        }

        @Override
        public int clientMaxMessageSize() {
            return this.options.maxMessageSize();
        }

        @Override
        public boolean isViewport() {
            return this.viewport != null;
        }

        @Override
        public StreamReaderOptions options() {
            return this.options;
        }

        @Override
        public RowSet addRowOffsets() {
            return this.addRowOffsets;
        }

        @Override
        public RowSet modRowOffsets(int col) {
            if (this.modRowOffsets == null) {
                return null;
            }
            return this.modRowOffsets[col];
        }
    }

    public static class ModColumnData {
        public final RowSetGenerator rowsModified;
        public final ChunkListInputStreamGenerator data;

        ModColumnData(BarrageMessage.ModColumnData col) throws IOException {
            this.rowsModified = new RowSetGenerator(col.rowsModified);
            this.data = new ChunkListInputStreamGenerator(col);
        }
    }

    public static class ChunkListInputStreamGenerator
    implements SafeCloseable {
        public ChunkInputStreamGenerator[] generators;
        public ChunkInputStreamGenerator emptyGenerator;

        ChunkListInputStreamGenerator(BarrageMessage.AddColumnData acd) {
            this.generators = new ChunkInputStreamGenerator[acd.data.size()];
            long rowOffset = 0L;
            for (int i = 0; i < acd.data.size(); ++i) {
                Chunk valuesChunk = (Chunk)acd.data.get(i);
                this.generators[i] = ChunkInputStreamGenerator.makeInputStreamGenerator(valuesChunk.getChunkType(), acd.type, acd.componentType, (Chunk<Values>)valuesChunk, rowOffset);
                rowOffset += (long)valuesChunk.size();
            }
            this.emptyGenerator = ChunkInputStreamGenerator.makeInputStreamGenerator(acd.chunkType, acd.type, acd.componentType, (Chunk<Values>)acd.chunkType.getEmptyChunk(), 0L);
        }

        ChunkListInputStreamGenerator(BarrageMessage.ModColumnData mcd) {
            this.generators = new ChunkInputStreamGenerator[mcd.data.size()];
            long rowOffset = 0L;
            for (int i = 0; i < mcd.data.size(); ++i) {
                Chunk valuesChunk = (Chunk)mcd.data.get(i);
                this.generators[i] = ChunkInputStreamGenerator.makeInputStreamGenerator(mcd.chunkType, mcd.type, mcd.componentType, (Chunk<Values>)valuesChunk, rowOffset);
                rowOffset += (long)valuesChunk.size();
            }
            this.emptyGenerator = ChunkInputStreamGenerator.makeInputStreamGenerator(mcd.chunkType, mcd.type, mcd.componentType, (Chunk<Values>)mcd.chunkType.getEmptyChunk(), 0L);
        }

        public void close() {
            for (int i = 0; i < this.generators.length; ++i) {
                this.generators[i].close();
                this.generators[i] = null;
            }
            this.emptyGenerator.close();
        }
    }

    public static class ArrowFactory
    extends Factory {
        @Override
        public BarrageStreamGenerator<View> newGenerator(BarrageMessage message, BarragePerformanceLog.WriteMetricsConsumer metricsConsumer) {
            return new BarrageStreamGeneratorImpl(message, metricsConsumer){

                @Override
                protected void writeHeader(ByteBuffer metadata, MutableInt size, FlatBufferBuilder header, BarrageProtoUtil.ExposedByteArrayOutputStream baos) throws IOException {
                    baos.write(MessageHelper.toIpcBytes((FlatBufferBuilder)header));
                }
            };
        }
    }

    public static class Factory
    implements BarrageStreamGenerator.Factory<View> {
        @Override
        public BarrageStreamGenerator<View> newGenerator(BarrageMessage message, BarragePerformanceLog.WriteMetricsConsumer metricsConsumer) {
            return new BarrageStreamGeneratorImpl(message, metricsConsumer);
        }

        @Override
        public View getSchemaView(@NotNull ToIntFunction<FlatBufferBuilder> schemaPayloadWriter) {
            FlatBufferBuilder builder = new FlatBufferBuilder();
            int schemaOffset = schemaPayloadWriter.applyAsInt(builder);
            builder.finish(MessageHelper.wrapInMessage((FlatBufferBuilder)builder, (int)schemaOffset, (byte)1));
            return new SchemaView(builder.dataBuffer());
        }
    }

    public static interface View {
        public void forEachStream(Consumer<InputStream> var1) throws IOException;

        public boolean isViewport();

        public StreamReaderOptions options();

        public int clientMaxMessageSize();

        public RowSet addRowOffsets();

        public RowSet modRowOffsets(int var1);
    }
}

