/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage;

import com.google.flatbuffers.FlatBufferBuilder;
import io.deephaven.annotations.BuildableStyle;
import io.deephaven.barrage.flatbuf.BarrageSubscriptionRequest;
import io.deephaven.extensions.barrage.ColumnConversionMode;
import io.deephaven.extensions.barrage.ImmutableBarrageSubscriptionOptions;
import io.deephaven.extensions.barrage.util.StreamReaderOptions;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class BarrageSubscriptionOptions
implements StreamReaderOptions {
    public static Builder builder() {
        return ImmutableBarrageSubscriptionOptions.builder();
    }

    public static BarrageSubscriptionOptions of(io.deephaven.barrage.flatbuf.BarrageSubscriptionOptions options) {
        if (options == null) {
            return BarrageSubscriptionOptions.builder().build();
        }
        byte mode = options.columnConversionMode();
        return BarrageSubscriptionOptions.builder().useDeephavenNulls(options.useDeephavenNulls()).columnConversionMode(ColumnConversionMode.conversionModeFbToEnum(mode)).minUpdateIntervalMs(options.minUpdateIntervalMs()).batchSize(options.batchSize()).maxMessageSize(options.maxMessageSize()).columnsAsList(options.columnsAsList()).build();
    }

    public static BarrageSubscriptionOptions of(BarrageSubscriptionRequest subscriptionRequest) {
        return BarrageSubscriptionOptions.of(subscriptionRequest.subscriptionOptions());
    }

    @Override
    @Value.Default
    public boolean useDeephavenNulls() {
        return false;
    }

    @Override
    @Value.Default
    public boolean columnsAsList() {
        return false;
    }

    @Value.Default
    public int minUpdateIntervalMs() {
        return 0;
    }

    @Override
    @Value.Default
    public int batchSize() {
        return 0;
    }

    @Override
    @Value.Default
    public int maxMessageSize() {
        return 0;
    }

    @Override
    @Value.Default
    public ColumnConversionMode columnConversionMode() {
        return ColumnConversionMode.Stringify;
    }

    public int appendTo(FlatBufferBuilder builder) {
        return io.deephaven.barrage.flatbuf.BarrageSubscriptionOptions.createBarrageSubscriptionOptions((FlatBufferBuilder)builder, (byte)ColumnConversionMode.conversionModeEnumToFb(this.columnConversionMode()), (boolean)this.useDeephavenNulls(), (int)this.minUpdateIntervalMs(), (int)this.batchSize(), (int)this.maxMessageSize(), (boolean)this.columnsAsList());
    }

    public static interface Builder {
        public Builder useDeephavenNulls(boolean var1);

        public Builder columnsAsList(boolean var1);

        public Builder columnConversionMode(ColumnConversionMode var1);

        public Builder minUpdateIntervalMs(int var1);

        public Builder batchSize(int var1);

        public Builder maxMessageSize(int var1);

        public BarrageSubscriptionOptions build();
    }
}

