/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage;

import io.deephaven.engine.context.ExecutionContext;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.updategraph.UpdateSourceRegistrar;
import io.deephaven.extensions.barrage.BarrageSubscriptionPerformanceLogger;
import io.deephaven.extensions.barrage.BarrageSubscriptionPerformanceStreamPublisher;
import io.deephaven.stream.StreamPublisher;
import io.deephaven.stream.StreamToBlinkTableAdapter;
import io.deephaven.time.DateTimeUtils;
import java.time.Instant;
import java.util.Map;
import org.HdrHistogram.Histogram;

class BarrageSubscriptionPerformanceLoggerImpl
implements BarrageSubscriptionPerformanceLogger {
    private final BarrageSubscriptionPerformanceStreamPublisher publisher = new BarrageSubscriptionPerformanceStreamPublisher();
    private final StreamToBlinkTableAdapter adapter = new StreamToBlinkTableAdapter(BarrageSubscriptionPerformanceStreamPublisher.definition(), (StreamPublisher)this.publisher, (UpdateSourceRegistrar)ExecutionContext.getContext().getUpdateGraph(), BarrageSubscriptionPerformanceLoggerImpl.class.getName(), Map.of("BarragePerformanceTableKey", BarrageSubscriptionPerformanceLogger.getDefaultTableName()));
    private final Table blink = this.adapter.table();

    @Override
    public void log(String tableId, String tableKey, String statType, Instant now, Histogram hist) {
        this.publisher.add(tableId, tableKey, statType, DateTimeUtils.epochNanos((Instant)now), hist.getTotalCount(), (double)hist.getValueAtPercentile(50.0) / 1000000.0, (double)hist.getValueAtPercentile(75.0) / 1000000.0, (double)hist.getValueAtPercentile(90.0) / 1000000.0, (double)hist.getValueAtPercentile(95.0) / 1000000.0, (double)hist.getValueAtPercentile(99.0) / 1000000.0, (double)hist.getMaxValue() / 1000000.0);
    }

    public Table blinkTable() {
        return this.blink;
    }
}

