/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage;

import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnDefinition;
import io.deephaven.engine.table.TableDefinition;
import io.deephaven.stream.StreamChunkUtils;
import io.deephaven.stream.StreamConsumer;
import io.deephaven.stream.StreamPublisher;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

class BarrageSubscriptionPerformanceStreamPublisher
implements StreamPublisher {
    private static final TableDefinition DEFINITION = TableDefinition.of((ColumnDefinition[])new ColumnDefinition[]{ColumnDefinition.ofString((String)"TableId"), ColumnDefinition.ofString((String)"TableKey"), ColumnDefinition.ofString((String)"StatType"), ColumnDefinition.ofTime((String)"Time"), ColumnDefinition.ofLong((String)"Count"), ColumnDefinition.ofDouble((String)"Pct50"), ColumnDefinition.ofDouble((String)"Pct75"), ColumnDefinition.ofDouble((String)"Pct90"), ColumnDefinition.ofDouble((String)"Pct95"), ColumnDefinition.ofDouble((String)"Pct99"), ColumnDefinition.ofDouble((String)"Max")});
    private static final int CHUNK_SIZE = 2048;
    private WritableChunk<Values>[] chunks = StreamChunkUtils.makeChunksForDefinition((TableDefinition)DEFINITION, (int)2048);
    private StreamConsumer consumer;

    public static TableDefinition definition() {
        return DEFINITION;
    }

    BarrageSubscriptionPerformanceStreamPublisher() {
    }

    public void register(@NotNull StreamConsumer consumer) {
        if (this.consumer != null) {
            throw new IllegalStateException("Can not register multiple StreamConsumers.");
        }
        this.consumer = Objects.requireNonNull(consumer);
    }

    public synchronized void add(String tableId, String tableKey, String statType, long timeNanos, long count, double p50, double p75, double p90, double p95, double p99, double max) {
        this.chunks[0].asWritableObjectChunk().add((Object)tableId);
        this.chunks[1].asWritableObjectChunk().add((Object)tableKey);
        this.chunks[2].asWritableObjectChunk().add((Object)statType);
        this.chunks[3].asWritableLongChunk().add(timeNanos);
        this.chunks[4].asWritableLongChunk().add(count);
        this.chunks[5].asWritableDoubleChunk().add(p50);
        this.chunks[6].asWritableDoubleChunk().add(p75);
        this.chunks[7].asWritableDoubleChunk().add(p90);
        this.chunks[8].asWritableDoubleChunk().add(p95);
        this.chunks[9].asWritableDoubleChunk().add(p99);
        this.chunks[10].asWritableDoubleChunk().add(max);
        if (this.chunks[0].size() == 2048) {
            this.flushInternal();
        }
    }

    public synchronized void flush() {
        if (this.chunks[0].size() == 0) {
            return;
        }
        this.flushInternal();
    }

    private void flushInternal() {
        this.consumer.accept(this.chunks);
        this.chunks = StreamChunkUtils.makeChunksForDefinition((TableDefinition)DEFINITION, (int)2048);
    }

    public void acceptFailure(Throwable e) {
        this.consumer.acceptFailure(e);
    }

    public void shutdown() {
    }
}

