/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.deephaven.extensions.barrage.BarrageSnapshotOptions;
import io.deephaven.extensions.barrage.ColumnConversionMode;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="BarrageSnapshotOptions", generator="Immutables")
@Immutable
final class ImmutableBarrageSnapshotOptions
extends BarrageSnapshotOptions {
    private final boolean useDeephavenNulls;
    private final int batchSize;
    private final int maxMessageSize;
    private final ColumnConversionMode columnConversionMode;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBarrageSnapshotOptions(Builder builder) {
        if (builder.useDeephavenNullsIsSet()) {
            this.initShim.useDeephavenNulls(builder.useDeephavenNulls);
        }
        if (builder.batchSizeIsSet()) {
            this.initShim.batchSize(builder.batchSize);
        }
        if (builder.maxMessageSizeIsSet()) {
            this.initShim.maxMessageSize(builder.maxMessageSize);
        }
        if (builder.columnConversionModeIsSet()) {
            this.initShim.columnConversionMode(builder.columnConversionMode);
        }
        this.useDeephavenNulls = this.initShim.useDeephavenNulls();
        this.batchSize = this.initShim.batchSize();
        this.maxMessageSize = this.initShim.maxMessageSize();
        this.columnConversionMode = this.initShim.columnConversionMode();
        this.initShim = null;
    }

    @Override
    public boolean useDeephavenNulls() {
        InitShim shim = this.initShim;
        return shim != null ? shim.useDeephavenNulls() : this.useDeephavenNulls;
    }

    @Override
    public int batchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.batchSize() : this.batchSize;
    }

    @Override
    public int maxMessageSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.maxMessageSize() : this.maxMessageSize;
    }

    @Override
    public ColumnConversionMode columnConversionMode() {
        InitShim shim = this.initShim;
        return shim != null ? shim.columnConversionMode() : this.columnConversionMode;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBarrageSnapshotOptions && this.equalTo(0, (ImmutableBarrageSnapshotOptions)another);
    }

    private boolean equalTo(int synthetic, ImmutableBarrageSnapshotOptions another) {
        return this.useDeephavenNulls == another.useDeephavenNulls && this.batchSize == another.batchSize && this.maxMessageSize == another.maxMessageSize && this.columnConversionMode.equals((Object)another.columnConversionMode);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + Boolean.hashCode(this.useDeephavenNulls);
        h += (h << 5) + this.batchSize;
        h += (h << 5) + this.maxMessageSize;
        h += (h << 5) + this.columnConversionMode.hashCode();
        return h;
    }

    public String toString() {
        return "BarrageSnapshotOptions{useDeephavenNulls=" + this.useDeephavenNulls + ", batchSize=" + this.batchSize + ", maxMessageSize=" + this.maxMessageSize + ", columnConversionMode=" + this.columnConversionMode + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BarrageSnapshotOptions", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements BarrageSnapshotOptions.Builder {
        private static final long OPT_BIT_USE_DEEPHAVEN_NULLS = 1L;
        private static final long OPT_BIT_BATCH_SIZE = 2L;
        private static final long OPT_BIT_MAX_MESSAGE_SIZE = 4L;
        private static final long OPT_BIT_COLUMN_CONVERSION_MODE = 8L;
        private long optBits;
        private boolean useDeephavenNulls;
        private int batchSize;
        private int maxMessageSize;
        @Nullable
        private ColumnConversionMode columnConversionMode;

        private Builder() {
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder useDeephavenNulls(boolean useDeephavenNulls) {
            Builder.checkNotIsSet(this.useDeephavenNullsIsSet(), "useDeephavenNulls");
            this.useDeephavenNulls = useDeephavenNulls;
            this.optBits |= 1L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder batchSize(int batchSize) {
            Builder.checkNotIsSet(this.batchSizeIsSet(), "batchSize");
            this.batchSize = batchSize;
            this.optBits |= 2L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder maxMessageSize(int maxMessageSize) {
            Builder.checkNotIsSet(this.maxMessageSizeIsSet(), "maxMessageSize");
            this.maxMessageSize = maxMessageSize;
            this.optBits |= 4L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder columnConversionMode(ColumnConversionMode columnConversionMode) {
            Builder.checkNotIsSet(this.columnConversionModeIsSet(), "columnConversionMode");
            this.columnConversionMode = Objects.requireNonNull(columnConversionMode, "columnConversionMode");
            this.optBits |= 8L;
            return this;
        }

        @Override
        public ImmutableBarrageSnapshotOptions build() {
            return new ImmutableBarrageSnapshotOptions(this);
        }

        private boolean useDeephavenNullsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean batchSizeIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean maxMessageSizeIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean columnConversionModeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of BarrageSnapshotOptions is strict, attribute is already set: ".concat(name));
            }
        }
    }

    @Generated(from="BarrageSnapshotOptions", generator="Immutables")
    private final class InitShim {
        private byte useDeephavenNullsBuildStage = 0;
        private boolean useDeephavenNulls;
        private byte batchSizeBuildStage = 0;
        private int batchSize;
        private byte maxMessageSizeBuildStage = 0;
        private int maxMessageSize;
        private byte columnConversionModeBuildStage = 0;
        private ColumnConversionMode columnConversionMode;

        private InitShim() {
        }

        boolean useDeephavenNulls() {
            if (this.useDeephavenNullsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.useDeephavenNullsBuildStage == 0) {
                this.useDeephavenNullsBuildStage = (byte)-1;
                this.useDeephavenNulls = ImmutableBarrageSnapshotOptions.super.useDeephavenNulls();
                this.useDeephavenNullsBuildStage = 1;
            }
            return this.useDeephavenNulls;
        }

        void useDeephavenNulls(boolean useDeephavenNulls) {
            this.useDeephavenNulls = useDeephavenNulls;
            this.useDeephavenNullsBuildStage = 1;
        }

        int batchSize() {
            if (this.batchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.batchSizeBuildStage == 0) {
                this.batchSizeBuildStage = (byte)-1;
                this.batchSize = ImmutableBarrageSnapshotOptions.super.batchSize();
                this.batchSizeBuildStage = 1;
            }
            return this.batchSize;
        }

        void batchSize(int batchSize) {
            this.batchSize = batchSize;
            this.batchSizeBuildStage = 1;
        }

        int maxMessageSize() {
            if (this.maxMessageSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxMessageSizeBuildStage == 0) {
                this.maxMessageSizeBuildStage = (byte)-1;
                this.maxMessageSize = ImmutableBarrageSnapshotOptions.super.maxMessageSize();
                this.maxMessageSizeBuildStage = 1;
            }
            return this.maxMessageSize;
        }

        void maxMessageSize(int maxMessageSize) {
            this.maxMessageSize = maxMessageSize;
            this.maxMessageSizeBuildStage = 1;
        }

        ColumnConversionMode columnConversionMode() {
            if (this.columnConversionModeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.columnConversionModeBuildStage == 0) {
                this.columnConversionModeBuildStage = (byte)-1;
                this.columnConversionMode = Objects.requireNonNull(ImmutableBarrageSnapshotOptions.super.columnConversionMode(), "columnConversionMode");
                this.columnConversionModeBuildStage = 1;
            }
            return this.columnConversionMode;
        }

        void columnConversionMode(ColumnConversionMode columnConversionMode) {
            this.columnConversionMode = columnConversionMode;
            this.columnConversionModeBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.useDeephavenNullsBuildStage == -1) {
                attributes.add("useDeephavenNulls");
            }
            if (this.batchSizeBuildStage == -1) {
                attributes.add("batchSize");
            }
            if (this.maxMessageSizeBuildStage == -1) {
                attributes.add("maxMessageSize");
            }
            if (this.columnConversionModeBuildStage == -1) {
                attributes.add("columnConversionMode");
            }
            return "Cannot build BarrageSnapshotOptions, attribute initializers form cycle " + attributes;
        }
    }
}

