/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.deephaven.extensions.barrage.BarrageSubscriptionOptions;
import io.deephaven.extensions.barrage.ColumnConversionMode;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="BarrageSubscriptionOptions", generator="Immutables")
@Immutable
final class ImmutableBarrageSubscriptionOptions
extends BarrageSubscriptionOptions {
    private final boolean useDeephavenNulls;
    private final boolean columnsAsList;
    private final int minUpdateIntervalMs;
    private final int batchSize;
    private final int maxMessageSize;
    private final ColumnConversionMode columnConversionMode;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBarrageSubscriptionOptions(Builder builder) {
        if (builder.useDeephavenNullsIsSet()) {
            this.initShim.useDeephavenNulls(builder.useDeephavenNulls);
        }
        if (builder.columnsAsListIsSet()) {
            this.initShim.columnsAsList(builder.columnsAsList);
        }
        if (builder.minUpdateIntervalMsIsSet()) {
            this.initShim.minUpdateIntervalMs(builder.minUpdateIntervalMs);
        }
        if (builder.batchSizeIsSet()) {
            this.initShim.batchSize(builder.batchSize);
        }
        if (builder.maxMessageSizeIsSet()) {
            this.initShim.maxMessageSize(builder.maxMessageSize);
        }
        if (builder.columnConversionModeIsSet()) {
            this.initShim.columnConversionMode(builder.columnConversionMode);
        }
        this.useDeephavenNulls = this.initShim.useDeephavenNulls();
        this.columnsAsList = this.initShim.columnsAsList();
        this.minUpdateIntervalMs = this.initShim.minUpdateIntervalMs();
        this.batchSize = this.initShim.batchSize();
        this.maxMessageSize = this.initShim.maxMessageSize();
        this.columnConversionMode = this.initShim.columnConversionMode();
        this.initShim = null;
    }

    @Override
    public boolean useDeephavenNulls() {
        InitShim shim = this.initShim;
        return shim != null ? shim.useDeephavenNulls() : this.useDeephavenNulls;
    }

    @Override
    public boolean columnsAsList() {
        InitShim shim = this.initShim;
        return shim != null ? shim.columnsAsList() : this.columnsAsList;
    }

    @Override
    public int minUpdateIntervalMs() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minUpdateIntervalMs() : this.minUpdateIntervalMs;
    }

    @Override
    public int batchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.batchSize() : this.batchSize;
    }

    @Override
    public int maxMessageSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.maxMessageSize() : this.maxMessageSize;
    }

    @Override
    public ColumnConversionMode columnConversionMode() {
        InitShim shim = this.initShim;
        return shim != null ? shim.columnConversionMode() : this.columnConversionMode;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBarrageSubscriptionOptions && this.equalTo(0, (ImmutableBarrageSubscriptionOptions)another);
    }

    private boolean equalTo(int synthetic, ImmutableBarrageSubscriptionOptions another) {
        return this.useDeephavenNulls == another.useDeephavenNulls && this.columnsAsList == another.columnsAsList && this.minUpdateIntervalMs == another.minUpdateIntervalMs && this.batchSize == another.batchSize && this.maxMessageSize == another.maxMessageSize && this.columnConversionMode.equals((Object)another.columnConversionMode);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + Boolean.hashCode(this.useDeephavenNulls);
        h += (h << 5) + Boolean.hashCode(this.columnsAsList);
        h += (h << 5) + this.minUpdateIntervalMs;
        h += (h << 5) + this.batchSize;
        h += (h << 5) + this.maxMessageSize;
        h += (h << 5) + this.columnConversionMode.hashCode();
        return h;
    }

    public String toString() {
        return "BarrageSubscriptionOptions{useDeephavenNulls=" + this.useDeephavenNulls + ", columnsAsList=" + this.columnsAsList + ", minUpdateIntervalMs=" + this.minUpdateIntervalMs + ", batchSize=" + this.batchSize + ", maxMessageSize=" + this.maxMessageSize + ", columnConversionMode=" + this.columnConversionMode + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BarrageSubscriptionOptions", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements BarrageSubscriptionOptions.Builder {
        private static final long OPT_BIT_USE_DEEPHAVEN_NULLS = 1L;
        private static final long OPT_BIT_COLUMNS_AS_LIST = 2L;
        private static final long OPT_BIT_MIN_UPDATE_INTERVAL_MS = 4L;
        private static final long OPT_BIT_BATCH_SIZE = 8L;
        private static final long OPT_BIT_MAX_MESSAGE_SIZE = 16L;
        private static final long OPT_BIT_COLUMN_CONVERSION_MODE = 32L;
        private long optBits;
        private boolean useDeephavenNulls;
        private boolean columnsAsList;
        private int minUpdateIntervalMs;
        private int batchSize;
        private int maxMessageSize;
        @Nullable
        private ColumnConversionMode columnConversionMode;

        private Builder() {
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder useDeephavenNulls(boolean useDeephavenNulls) {
            Builder.checkNotIsSet(this.useDeephavenNullsIsSet(), "useDeephavenNulls");
            this.useDeephavenNulls = useDeephavenNulls;
            this.optBits |= 1L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder columnsAsList(boolean columnsAsList) {
            Builder.checkNotIsSet(this.columnsAsListIsSet(), "columnsAsList");
            this.columnsAsList = columnsAsList;
            this.optBits |= 2L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder minUpdateIntervalMs(int minUpdateIntervalMs) {
            Builder.checkNotIsSet(this.minUpdateIntervalMsIsSet(), "minUpdateIntervalMs");
            this.minUpdateIntervalMs = minUpdateIntervalMs;
            this.optBits |= 4L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder batchSize(int batchSize) {
            Builder.checkNotIsSet(this.batchSizeIsSet(), "batchSize");
            this.batchSize = batchSize;
            this.optBits |= 8L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder maxMessageSize(int maxMessageSize) {
            Builder.checkNotIsSet(this.maxMessageSizeIsSet(), "maxMessageSize");
            this.maxMessageSize = maxMessageSize;
            this.optBits |= 0x10L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder columnConversionMode(ColumnConversionMode columnConversionMode) {
            Builder.checkNotIsSet(this.columnConversionModeIsSet(), "columnConversionMode");
            this.columnConversionMode = Objects.requireNonNull(columnConversionMode, "columnConversionMode");
            this.optBits |= 0x20L;
            return this;
        }

        @Override
        public ImmutableBarrageSubscriptionOptions build() {
            return new ImmutableBarrageSubscriptionOptions(this);
        }

        private boolean useDeephavenNullsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean columnsAsListIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean minUpdateIntervalMsIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean batchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean maxMessageSizeIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean columnConversionModeIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of BarrageSubscriptionOptions is strict, attribute is already set: ".concat(name));
            }
        }
    }

    @Generated(from="BarrageSubscriptionOptions", generator="Immutables")
    private final class InitShim {
        private byte useDeephavenNullsBuildStage = 0;
        private boolean useDeephavenNulls;
        private byte columnsAsListBuildStage = 0;
        private boolean columnsAsList;
        private byte minUpdateIntervalMsBuildStage = 0;
        private int minUpdateIntervalMs;
        private byte batchSizeBuildStage = 0;
        private int batchSize;
        private byte maxMessageSizeBuildStage = 0;
        private int maxMessageSize;
        private byte columnConversionModeBuildStage = 0;
        private ColumnConversionMode columnConversionMode;

        private InitShim() {
        }

        boolean useDeephavenNulls() {
            if (this.useDeephavenNullsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.useDeephavenNullsBuildStage == 0) {
                this.useDeephavenNullsBuildStage = (byte)-1;
                this.useDeephavenNulls = ImmutableBarrageSubscriptionOptions.super.useDeephavenNulls();
                this.useDeephavenNullsBuildStage = 1;
            }
            return this.useDeephavenNulls;
        }

        void useDeephavenNulls(boolean useDeephavenNulls) {
            this.useDeephavenNulls = useDeephavenNulls;
            this.useDeephavenNullsBuildStage = 1;
        }

        boolean columnsAsList() {
            if (this.columnsAsListBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.columnsAsListBuildStage == 0) {
                this.columnsAsListBuildStage = (byte)-1;
                this.columnsAsList = ImmutableBarrageSubscriptionOptions.super.columnsAsList();
                this.columnsAsListBuildStage = 1;
            }
            return this.columnsAsList;
        }

        void columnsAsList(boolean columnsAsList) {
            this.columnsAsList = columnsAsList;
            this.columnsAsListBuildStage = 1;
        }

        int minUpdateIntervalMs() {
            if (this.minUpdateIntervalMsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minUpdateIntervalMsBuildStage == 0) {
                this.minUpdateIntervalMsBuildStage = (byte)-1;
                this.minUpdateIntervalMs = ImmutableBarrageSubscriptionOptions.super.minUpdateIntervalMs();
                this.minUpdateIntervalMsBuildStage = 1;
            }
            return this.minUpdateIntervalMs;
        }

        void minUpdateIntervalMs(int minUpdateIntervalMs) {
            this.minUpdateIntervalMs = minUpdateIntervalMs;
            this.minUpdateIntervalMsBuildStage = 1;
        }

        int batchSize() {
            if (this.batchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.batchSizeBuildStage == 0) {
                this.batchSizeBuildStage = (byte)-1;
                this.batchSize = ImmutableBarrageSubscriptionOptions.super.batchSize();
                this.batchSizeBuildStage = 1;
            }
            return this.batchSize;
        }

        void batchSize(int batchSize) {
            this.batchSize = batchSize;
            this.batchSizeBuildStage = 1;
        }

        int maxMessageSize() {
            if (this.maxMessageSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxMessageSizeBuildStage == 0) {
                this.maxMessageSizeBuildStage = (byte)-1;
                this.maxMessageSize = ImmutableBarrageSubscriptionOptions.super.maxMessageSize();
                this.maxMessageSizeBuildStage = 1;
            }
            return this.maxMessageSize;
        }

        void maxMessageSize(int maxMessageSize) {
            this.maxMessageSize = maxMessageSize;
            this.maxMessageSizeBuildStage = 1;
        }

        ColumnConversionMode columnConversionMode() {
            if (this.columnConversionModeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.columnConversionModeBuildStage == 0) {
                this.columnConversionModeBuildStage = (byte)-1;
                this.columnConversionMode = Objects.requireNonNull(ImmutableBarrageSubscriptionOptions.super.columnConversionMode(), "columnConversionMode");
                this.columnConversionModeBuildStage = 1;
            }
            return this.columnConversionMode;
        }

        void columnConversionMode(ColumnConversionMode columnConversionMode) {
            this.columnConversionMode = columnConversionMode;
            this.columnConversionModeBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.useDeephavenNullsBuildStage == -1) {
                attributes.add("useDeephavenNulls");
            }
            if (this.columnsAsListBuildStage == -1) {
                attributes.add("columnsAsList");
            }
            if (this.minUpdateIntervalMsBuildStage == -1) {
                attributes.add("minUpdateIntervalMs");
            }
            if (this.batchSizeBuildStage == -1) {
                attributes.add("batchSize");
            }
            if (this.maxMessageSizeBuildStage == -1) {
                attributes.add("maxMessageSize");
            }
            if (this.columnConversionModeBuildStage == -1) {
                attributes.add("columnConversionMode");
            }
            return "Cannot build BarrageSubscriptionOptions, attribute initializers form cycle " + attributes;
        }
    }
}

