/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage.chunk;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.chunk.util.pools.PoolableChunk;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSequenceFactory;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.extensions.barrage.chunk.ChunkInputStreamGenerator;
import io.deephaven.extensions.barrage.util.StreamReaderOptions;
import io.deephaven.util.datastructures.LongSizedDataStructure;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public abstract class BaseChunkInputStreamGenerator<T extends Chunk<Values>>
implements ChunkInputStreamGenerator {
    public static final byte[] PADDING_BUFFER = new byte[8];
    public static final int REMAINDER_MOD_8_MASK = 7;
    private volatile int refCount = 1;
    protected static final AtomicIntegerFieldUpdater<BaseChunkInputStreamGenerator> REFERENCE_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(BaseChunkInputStreamGenerator.class, "refCount");
    protected final T chunk;
    protected final int elementSize;
    private final long rowOffset;

    BaseChunkInputStreamGenerator(T chunk, int elementSize, long rowOffset) {
        this.chunk = chunk;
        this.elementSize = elementSize;
        this.rowOffset = rowOffset;
    }

    @Override
    public long getRowOffset() {
        return this.rowOffset;
    }

    @Override
    public long getLastRowOffset() {
        return this.rowOffset + (long)this.chunk.size() - 1L;
    }

    public void close() {
        if (REFERENCE_COUNT_UPDATER.decrementAndGet(this) == 0 && this.chunk instanceof PoolableChunk) {
            ((PoolableChunk)this.chunk).close();
        }
    }

    protected static int getValidityMapSerializationSizeFor(int numElements) {
        return BaseChunkInputStreamGenerator.getNumLongsForBitPackOfSize(numElements) * 8;
    }

    protected static int getNumLongsForBitPackOfSize(int numElements) {
        return (numElements + 63) / 64;
    }

    protected static final class SerContext {
        long accumulator = 0L;
        long count = 0L;

        protected SerContext() {
        }
    }

    static abstract class BaseChunkInputStream
    extends ChunkInputStreamGenerator.DrainableColumn {
        protected final StreamReaderOptions options;
        protected final RowSequence subset;
        protected boolean read = false;
        final /* synthetic */ BaseChunkInputStreamGenerator this$0;

        BaseChunkInputStream(T chunk, StreamReaderOptions options, RowSet subset) {
            this.this$0 = this$0;
            this.options = options;
            this.subset = chunk.size() == 0 ? RowSequenceFactory.EMPTY : (subset != null ? subset.copy() : RowSequenceFactory.forRange((long)0L, (long)(chunk.size() - 1)));
            REFERENCE_COUNT_UPDATER.incrementAndGet(this$0);
            if (chunk.size() > 0 && this.subset.lastRowKey() >= (long)chunk.size()) {
                throw new IllegalStateException("Subset " + this.subset + " is out of bounds for chunk of size " + chunk.size());
            }
        }

        @Override
        public void close() throws IOException {
            this.this$0.close();
            this.subset.close();
        }

        protected int getRawSize() throws IOException {
            long size = 0L;
            if (this.sendValidityBuffer()) {
                size += (long)BaseChunkInputStreamGenerator.getValidityMapSerializationSizeFor(this.subset.intSize());
            }
            return LongSizedDataStructure.intSize((String)"BaseChunkInputStream.getRawSize", (long)(size += (long)this.this$0.elementSize * this.subset.size()));
        }

        @Override
        public int available() throws IOException {
            int rawSize = this.getRawSize();
            int rawMod8 = rawSize & 7;
            return this.read ? 0 : rawSize + (rawMod8 > 0 ? 8 - rawMod8 : 0);
        }

        protected boolean sendValidityBuffer() {
            return this.nullCount() != 0;
        }
    }
}

