/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage.chunk;

import com.google.common.io.LittleEndianDataOutputStream;
import io.deephaven.UncheckedDeephavenException;
import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableByteChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.chunk.util.pools.PoolableChunk;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.extensions.barrage.chunk.BaseChunkInputStreamGenerator;
import io.deephaven.extensions.barrage.chunk.ChunkInputStreamGenerator;
import io.deephaven.extensions.barrage.util.StreamReaderOptions;
import io.deephaven.util.BooleanUtils;
import io.deephaven.util.datastructures.LongSizedDataStructure;
import java.io.DataInput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import org.jetbrains.annotations.Nullable;

public class BooleanChunkInputStreamGenerator
extends BaseChunkInputStreamGenerator<ByteChunk<Values>> {
    private static final String DEBUG_NAME = "BooleanChunkInputStreamGenerator";

    public static BooleanChunkInputStreamGenerator convertBoxed(ObjectChunk<Boolean, Values> inChunk, long rowOffset) {
        WritableByteChunk outChunk = WritableByteChunk.makeWritableChunk((int)inChunk.size());
        for (int i = 0; i < inChunk.size(); ++i) {
            Boolean value = (Boolean)inChunk.get(i);
            outChunk.set(i, BooleanUtils.booleanAsByte((Boolean)value));
        }
        if (inChunk instanceof PoolableChunk) {
            ((PoolableChunk)inChunk).close();
        }
        return new BooleanChunkInputStreamGenerator((ByteChunk<Values>)outChunk, rowOffset);
    }

    BooleanChunkInputStreamGenerator(ByteChunk<Values> chunk, long rowOffset) {
        super(chunk, 0, rowOffset);
    }

    @Override
    public ChunkInputStreamGenerator.DrainableColumn getInputStream(StreamReaderOptions options, @Nullable RowSet subset) {
        return new BooleanChunkInputStream(options, subset);
    }

    static WritableChunk<Values> extractChunkFromInputStream(StreamReaderOptions options, Iterator<ChunkInputStreamGenerator.FieldNodeInfo> fieldNodeIter, PrimitiveIterator.OfLong bufferInfoIter, DataInput is, WritableChunk<Values> outChunk, int outOffset, int totalRows) throws IOException {
        return BooleanChunkInputStreamGenerator.extractChunkFromInputStreamWithConversion(options, ByteConversion.IDENTITY, fieldNodeIter, bufferInfoIter, is, outChunk, outOffset, totalRows);
    }

    static WritableChunk<Values> extractChunkFromInputStreamWithConversion(StreamReaderOptions options, ByteConversion conversion, Iterator<ChunkInputStreamGenerator.FieldNodeInfo> fieldNodeIter, PrimitiveIterator.OfLong bufferInfoIter, DataInput is, WritableChunk<Values> outChunk, int outOffset, int totalRows) throws IOException {
        WritableByteChunk chunk;
        ChunkInputStreamGenerator.FieldNodeInfo nodeInfo = fieldNodeIter.next();
        long validityBuffer = bufferInfoIter.nextLong();
        long payloadBuffer = bufferInfoIter.nextLong();
        if (outChunk != null) {
            chunk = outChunk.asWritableByteChunk();
        } else {
            int numRows = Math.max(totalRows, nodeInfo.numElements);
            chunk = WritableByteChunk.makeWritableChunk((int)numRows);
            chunk.setSize(numRows);
        }
        if (nodeInfo.numElements == 0) {
            return chunk;
        }
        int numValidityLongs = (nodeInfo.numElements + 63) / 64;
        try (WritableLongChunk isValid = WritableLongChunk.makeWritableChunk((int)numValidityLongs);){
            int jj = 0;
            while ((long)jj < Math.min((long)numValidityLongs, validityBuffer / 8L)) {
                isValid.set(jj, is.readLong());
                ++jj;
            }
            long valBufRead = (long)jj * 8L;
            if (valBufRead < validityBuffer) {
                is.skipBytes(LongSizedDataStructure.intSize((String)DEBUG_NAME, (long)(validityBuffer - valBufRead)));
            }
            while (jj < numValidityLongs) {
                isValid.set(jj, -1L);
                ++jj;
            }
            int numPayloadBytesNeeded = (int)(((long)nodeInfo.numElements + 7L) / 8L);
            if (payloadBuffer < (long)numPayloadBytesNeeded) {
                throw new IllegalStateException("payload buffer is too short for expected number of elements");
            }
            BooleanChunkInputStreamGenerator.useValidityBuffer(conversion, is, nodeInfo, (WritableByteChunk<Values>)chunk, outOffset, (WritableLongChunk<Values>)isValid);
            long payloadRead = (long)BooleanChunkInputStreamGenerator.getNumLongsForBitPackOfSize(nodeInfo.numElements) * 8L;
            long overhangPayload = payloadBuffer - payloadRead;
            if (overhangPayload > 0L) {
                is.skipBytes(LongSizedDataStructure.intSize((String)DEBUG_NAME, (long)overhangPayload));
            }
        }
        return chunk;
    }

    private static void useValidityBuffer(ByteConversion conversion, DataInput is, ChunkInputStreamGenerator.FieldNodeInfo nodeInfo, WritableByteChunk<Values> chunk, int offset, WritableLongChunk<Values> isValid) throws IOException {
        int numElements = nodeInfo.numElements;
        int numValidityWords = (numElements + 63) / 64;
        int ei = 0;
        int pendingSkips = 0;
        for (int vi = 0; vi < numValidityWords; ++vi) {
            int bitsLeftInThisWord = Math.min(64, numElements - vi * 64);
            long validityWord = isValid.get(vi);
            long payloadWord = is.readLong();
            do {
                if ((validityWord & 1L) == 1L) {
                    if (pendingSkips > 0) {
                        chunk.fillWithNullValue(offset + ei, pendingSkips);
                        ei += pendingSkips;
                        pendingSkips = 0;
                    }
                    byte value = (payloadWord & 1L) == 1L ? (byte)1 : 0;
                    chunk.set(offset + ei++, conversion.apply(value));
                    validityWord >>= 1;
                    payloadWord >>= 1;
                    --bitsLeftInThisWord;
                    continue;
                }
                int skips = Math.min(Long.numberOfTrailingZeros(validityWord), bitsLeftInThisWord);
                pendingSkips += skips;
                validityWord >>= skips;
                payloadWord >>= skips;
                bitsLeftInThisWord -= skips;
            } while (bitsLeftInThisWord > 0);
        }
        if (pendingSkips > 0) {
            chunk.fillWithNullValue(offset + ei, pendingSkips);
        }
    }

    @FunctionalInterface
    public static interface ByteConversion {
        public static final ByteConversion IDENTITY = a -> a;

        public byte apply(byte var1);
    }

    private class BooleanChunkInputStream
    extends BaseChunkInputStreamGenerator.BaseChunkInputStream {
        private int cachedNullCount;

        private BooleanChunkInputStream(StreamReaderOptions options, RowSet subset) {
            super((BaseChunkInputStreamGenerator)BooleanChunkInputStreamGenerator.this, (Chunk)((ByteChunk)BooleanChunkInputStreamGenerator.this.chunk), options, subset);
            this.cachedNullCount = -1;
        }

        @Override
        public int nullCount() {
            if (this.cachedNullCount == -1) {
                this.cachedNullCount = 0;
                this.subset.forAllRowKeys(row -> {
                    if (((ByteChunk)BooleanChunkInputStreamGenerator.this.chunk).get((int)row) == -128) {
                        ++this.cachedNullCount;
                    }
                });
            }
            return this.cachedNullCount;
        }

        @Override
        protected int getRawSize() {
            long size = 0L;
            if (this.sendValidityBuffer()) {
                size += (long)BaseChunkInputStreamGenerator.getValidityMapSerializationSizeFor(this.subset.intSize(BooleanChunkInputStreamGenerator.DEBUG_NAME));
            }
            return LongSizedDataStructure.intSize((String)BooleanChunkInputStreamGenerator.DEBUG_NAME, (long)(size += (long)BaseChunkInputStreamGenerator.getNumLongsForBitPackOfSize(this.subset.intSize(BooleanChunkInputStreamGenerator.DEBUG_NAME)) * 8L));
        }

        @Override
        public void visitFieldNodes(ChunkInputStreamGenerator.FieldNodeListener listener) {
            listener.noteLogicalFieldNode(this.subset.intSize(BooleanChunkInputStreamGenerator.DEBUG_NAME), this.nullCount());
        }

        @Override
        public void visitBuffers(ChunkInputStreamGenerator.BufferListener listener) {
            int validityLen = this.sendValidityBuffer() ? BaseChunkInputStreamGenerator.getValidityMapSerializationSizeFor(this.subset.intSize(BooleanChunkInputStreamGenerator.DEBUG_NAME)) : 0;
            listener.noteLogicalBuffer(validityLen);
            listener.noteLogicalBuffer((long)BaseChunkInputStreamGenerator.getNumLongsForBitPackOfSize(this.subset.intSize(BooleanChunkInputStreamGenerator.DEBUG_NAME)) * 8L);
        }

        public int drainTo(OutputStream outputStream) throws IOException {
            if (this.read || this.subset.isEmpty()) {
                return 0;
            }
            long bytesWritten = 0L;
            this.read = true;
            LittleEndianDataOutputStream dos = new LittleEndianDataOutputStream(outputStream);
            BaseChunkInputStreamGenerator.SerContext context = new BaseChunkInputStreamGenerator.SerContext();
            Runnable flush = () -> {
                try {
                    dos.writeLong(context.accumulator);
                }
                catch (IOException e) {
                    throw new UncheckedDeephavenException("Unexpected exception while draining data to OutputStream: ", (Throwable)e);
                }
                context.accumulator = 0L;
                context.count = 0L;
            };
            if (this.sendValidityBuffer()) {
                this.subset.forAllRowKeys(row -> {
                    if (((ByteChunk)BooleanChunkInputStreamGenerator.this.chunk).get((int)row) != -128) {
                        context.accumulator |= 1L << (int)context.count;
                    }
                    if (++context.count == 64L) {
                        flush.run();
                    }
                });
                if (context.count > 0L) {
                    flush.run();
                }
                bytesWritten += (long)BaseChunkInputStreamGenerator.getValidityMapSerializationSizeFor(this.subset.intSize(BooleanChunkInputStreamGenerator.DEBUG_NAME));
            }
            this.subset.forAllRowKeys(row -> {
                byte byteValue = ((ByteChunk)BooleanChunkInputStreamGenerator.this.chunk).get((int)row);
                if (byteValue != -128) {
                    context.accumulator = context.accumulator | (byteValue > 0 ? 1L : 0L) << (int)context.count;
                }
                if (++context.count == 64L) {
                    flush.run();
                }
            });
            if (context.count > 0L) {
                flush.run();
            }
            return LongSizedDataStructure.intSize((String)BooleanChunkInputStreamGenerator.DEBUG_NAME, (long)(bytesWritten += (long)BaseChunkInputStreamGenerator.getNumLongsForBitPackOfSize(this.subset.intSize(BooleanChunkInputStreamGenerator.DEBUG_NAME)) * 8L));
        }
    }
}

