/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage.chunk;

import com.google.common.io.LittleEndianDataOutputStream;
import io.deephaven.UncheckedDeephavenException;
import io.deephaven.chunk.CharChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableCharChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.chunk.util.pools.PoolableChunk;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.extensions.barrage.chunk.BaseChunkInputStreamGenerator;
import io.deephaven.extensions.barrage.chunk.ChunkInputStreamGenerator;
import io.deephaven.extensions.barrage.util.StreamReaderOptions;
import io.deephaven.util.datastructures.LongSizedDataStructure;
import io.deephaven.util.type.TypeUtils;
import java.io.DataInput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import org.jetbrains.annotations.Nullable;

public class CharChunkInputStreamGenerator
extends BaseChunkInputStreamGenerator<CharChunk<Values>> {
    private static final String DEBUG_NAME = "CharChunkInputStreamGenerator";

    public static CharChunkInputStreamGenerator convertBoxed(ObjectChunk<Character, Values> inChunk, long rowOffset) {
        WritableCharChunk outChunk = WritableCharChunk.makeWritableChunk((int)inChunk.size());
        for (int i = 0; i < inChunk.size(); ++i) {
            Character value = (Character)inChunk.get(i);
            outChunk.set(i, TypeUtils.unbox((Character)value));
        }
        if (inChunk instanceof PoolableChunk) {
            ((PoolableChunk)inChunk).close();
        }
        return new CharChunkInputStreamGenerator((CharChunk<Values>)outChunk, 2, rowOffset);
    }

    CharChunkInputStreamGenerator(CharChunk<Values> chunk, int elementSize, long rowOffset) {
        super(chunk, elementSize, rowOffset);
    }

    @Override
    public ChunkInputStreamGenerator.DrainableColumn getInputStream(StreamReaderOptions options, @Nullable RowSet subset) {
        return new CharChunkInputStream(options, subset);
    }

    static WritableChunk<Values> extractChunkFromInputStream(int elementSize, StreamReaderOptions options, Iterator<ChunkInputStreamGenerator.FieldNodeInfo> fieldNodeIter, PrimitiveIterator.OfLong bufferInfoIter, DataInput is, WritableChunk<Values> outChunk, int outOffset, int totalRows) throws IOException {
        return CharChunkInputStreamGenerator.extractChunkFromInputStreamWithConversion(elementSize, options, CharConversion.IDENTITY, fieldNodeIter, bufferInfoIter, is, outChunk, outOffset, totalRows);
    }

    static WritableChunk<Values> extractChunkFromInputStreamWithConversion(int elementSize, StreamReaderOptions options, CharConversion conversion, Iterator<ChunkInputStreamGenerator.FieldNodeInfo> fieldNodeIter, PrimitiveIterator.OfLong bufferInfoIter, DataInput is, WritableChunk<Values> outChunk, int outOffset, int totalRows) throws IOException {
        WritableCharChunk chunk;
        ChunkInputStreamGenerator.FieldNodeInfo nodeInfo = fieldNodeIter.next();
        long validityBuffer = bufferInfoIter.nextLong();
        long payloadBuffer = bufferInfoIter.nextLong();
        if (outChunk != null) {
            chunk = outChunk.asWritableCharChunk();
        } else {
            int numRows = Math.max(totalRows, nodeInfo.numElements);
            chunk = WritableCharChunk.makeWritableChunk((int)numRows);
            chunk.setSize(numRows);
        }
        if (nodeInfo.numElements == 0) {
            return chunk;
        }
        int numValidityLongs = options.useDeephavenNulls() ? 0 : (nodeInfo.numElements + 63) / 64;
        try (WritableLongChunk isValid = WritableLongChunk.makeWritableChunk((int)numValidityLongs);){
            if (options.useDeephavenNulls() && validityBuffer != 0L) {
                throw new IllegalStateException("validity buffer is non-empty, but is unnecessary");
            }
            int jj = 0;
            while ((long)jj < Math.min((long)numValidityLongs, validityBuffer / 8L)) {
                isValid.set(jj, is.readLong());
                ++jj;
            }
            long valBufRead = (long)jj * 8L;
            if (valBufRead < validityBuffer) {
                is.skipBytes(LongSizedDataStructure.intSize((String)DEBUG_NAME, (long)(validityBuffer - valBufRead)));
            }
            while (jj < numValidityLongs) {
                isValid.set(jj, -1L);
                ++jj;
            }
            long payloadRead = (long)nodeInfo.numElements * (long)elementSize;
            if (payloadBuffer < payloadRead) {
                throw new IllegalStateException("payload buffer is too short for expected number of elements");
            }
            if (options.useDeephavenNulls()) {
                CharChunkInputStreamGenerator.useDeephavenNulls(conversion, is, nodeInfo, (WritableCharChunk<Values>)chunk, outOffset);
            } else {
                CharChunkInputStreamGenerator.useValidityBuffer(elementSize, conversion, is, nodeInfo, (WritableCharChunk<Values>)chunk, outOffset, (WritableLongChunk<Values>)isValid);
            }
            long overhangPayload = payloadBuffer - payloadRead;
            if (overhangPayload > 0L) {
                is.skipBytes(LongSizedDataStructure.intSize((String)DEBUG_NAME, (long)overhangPayload));
            }
        }
        return chunk;
    }

    private static void useDeephavenNulls(CharConversion conversion, DataInput is, ChunkInputStreamGenerator.FieldNodeInfo nodeInfo, WritableCharChunk<Values> chunk, int offset) throws IOException {
        if (conversion == CharConversion.IDENTITY) {
            for (int ii = 0; ii < nodeInfo.numElements; ++ii) {
                chunk.set(offset + ii, is.readChar());
            }
        } else {
            for (int ii = 0; ii < nodeInfo.numElements; ++ii) {
                char in = is.readChar();
                char out = in == '\uffff' ? in : conversion.apply(in);
                chunk.set(offset + ii, out);
            }
        }
    }

    private static void useValidityBuffer(int elementSize, CharConversion conversion, DataInput is, ChunkInputStreamGenerator.FieldNodeInfo nodeInfo, WritableCharChunk<Values> chunk, int offset, WritableLongChunk<Values> isValid) throws IOException {
        int numElements = nodeInfo.numElements;
        int numValidityWords = (numElements + 63) / 64;
        int ei = 0;
        int pendingSkips = 0;
        for (int vi = 0; vi < numValidityWords; ++vi) {
            int bitsLeftInThisWord = Math.min(64, numElements - vi * 64);
            long validityWord = isValid.get(vi);
            do {
                if ((validityWord & 1L) == 1L) {
                    if (pendingSkips > 0) {
                        is.skipBytes(pendingSkips * elementSize);
                        chunk.fillWithNullValue(offset + ei, pendingSkips);
                        ei += pendingSkips;
                        pendingSkips = 0;
                    }
                    chunk.set(offset + ei++, conversion.apply(is.readChar()));
                    validityWord >>= 1;
                    --bitsLeftInThisWord;
                    continue;
                }
                int skips = Math.min(Long.numberOfTrailingZeros(validityWord), bitsLeftInThisWord);
                pendingSkips += skips;
                validityWord >>= skips;
                bitsLeftInThisWord -= skips;
            } while (bitsLeftInThisWord > 0);
        }
        if (pendingSkips > 0) {
            is.skipBytes(pendingSkips * elementSize);
            chunk.fillWithNullValue(offset + ei, pendingSkips);
        }
    }

    @FunctionalInterface
    public static interface CharConversion {
        public static final CharConversion IDENTITY = a -> a;

        public char apply(char var1);
    }

    private class CharChunkInputStream
    extends BaseChunkInputStreamGenerator.BaseChunkInputStream {
        private int cachedNullCount;

        private CharChunkInputStream(StreamReaderOptions options, RowSet subset) {
            super((BaseChunkInputStreamGenerator)CharChunkInputStreamGenerator.this, (Chunk)((CharChunk)CharChunkInputStreamGenerator.this.chunk), options, subset);
            this.cachedNullCount = -1;
        }

        @Override
        public int nullCount() {
            if (this.options.useDeephavenNulls()) {
                return 0;
            }
            if (this.cachedNullCount == -1) {
                this.cachedNullCount = 0;
                this.subset.forAllRowKeys(row -> {
                    if (((CharChunk)CharChunkInputStreamGenerator.this.chunk).get((int)row) == '\uffff') {
                        ++this.cachedNullCount;
                    }
                });
            }
            return this.cachedNullCount;
        }

        @Override
        public void visitFieldNodes(ChunkInputStreamGenerator.FieldNodeListener listener) {
            listener.noteLogicalFieldNode(this.subset.intSize(CharChunkInputStreamGenerator.DEBUG_NAME), this.nullCount());
        }

        @Override
        public void visitBuffers(ChunkInputStreamGenerator.BufferListener listener) {
            listener.noteLogicalBuffer(this.sendValidityBuffer() ? (long)BaseChunkInputStreamGenerator.getValidityMapSerializationSizeFor(this.subset.intSize()) : 0L);
            long length = (long)CharChunkInputStreamGenerator.this.elementSize * this.subset.size();
            long bytesExtended = length & 7L;
            if (bytesExtended > 0L) {
                length += 8L - bytesExtended;
            }
            listener.noteLogicalBuffer(length);
        }

        public int drainTo(OutputStream outputStream) throws IOException {
            if (this.read || this.subset.isEmpty()) {
                return 0;
            }
            long bytesWritten = 0L;
            this.read = true;
            LittleEndianDataOutputStream dos = new LittleEndianDataOutputStream(outputStream);
            if (this.sendValidityBuffer()) {
                BaseChunkInputStreamGenerator.SerContext context = new BaseChunkInputStreamGenerator.SerContext();
                Runnable flush = () -> {
                    try {
                        dos.writeLong(context.accumulator);
                    }
                    catch (IOException e) {
                        throw new UncheckedDeephavenException("Unexpected exception while draining data to OutputStream: ", (Throwable)e);
                    }
                    context.accumulator = 0L;
                    context.count = 0L;
                };
                this.subset.forAllRowKeys(row -> {
                    if (((CharChunk)CharChunkInputStreamGenerator.this.chunk).get((int)row) != '\uffff') {
                        context.accumulator |= 1L << (int)context.count;
                    }
                    if (++context.count == 64L) {
                        flush.run();
                    }
                });
                if (context.count > 0L) {
                    flush.run();
                }
                bytesWritten += (long)BaseChunkInputStreamGenerator.getValidityMapSerializationSizeFor(this.subset.intSize());
            }
            this.subset.forAllRowKeys(row -> {
                try {
                    char val = ((CharChunk)CharChunkInputStreamGenerator.this.chunk).get((int)row);
                    dos.writeChar((int)val);
                }
                catch (IOException e) {
                    throw new UncheckedDeephavenException("Unexpected exception while draining data to OutputStream: ", (Throwable)e);
                }
            });
            long bytesExtended = (bytesWritten += (long)CharChunkInputStreamGenerator.this.elementSize * this.subset.size()) & 7L;
            if (bytesExtended > 0L) {
                bytesWritten += 8L - bytesExtended;
                dos.write(BaseChunkInputStreamGenerator.PADDING_BUFFER, 0, (int)(8L - bytesExtended));
            }
            return LongSizedDataStructure.intSize((String)CharChunkInputStreamGenerator.DEBUG_NAME, (long)bytesWritten);
        }
    }
}

