/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage.chunk;

import com.google.common.base.Charsets;
import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.CharChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.FloatChunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.ShortChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.chunk.util.pools.PoolableChunk;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.extensions.barrage.ColumnConversionMode;
import io.deephaven.extensions.barrage.chunk.BooleanChunkInputStreamGenerator;
import io.deephaven.extensions.barrage.chunk.ByteChunkInputStreamGenerator;
import io.deephaven.extensions.barrage.chunk.CharChunkInputStreamGenerator;
import io.deephaven.extensions.barrage.chunk.DoubleChunkInputStreamGenerator;
import io.deephaven.extensions.barrage.chunk.FixedWidthChunkInputStreamGenerator;
import io.deephaven.extensions.barrage.chunk.FloatChunkInputStreamGenerator;
import io.deephaven.extensions.barrage.chunk.IntChunkInputStreamGenerator;
import io.deephaven.extensions.barrage.chunk.LongChunkInputStreamGenerator;
import io.deephaven.extensions.barrage.chunk.ShortChunkInputStreamGenerator;
import io.deephaven.extensions.barrage.chunk.VarBinaryChunkInputStreamGenerator;
import io.deephaven.extensions.barrage.chunk.VarListChunkInputStreamGenerator;
import io.deephaven.extensions.barrage.chunk.VectorChunkInputStreamGenerator;
import io.deephaven.extensions.barrage.util.DefensiveDrainable;
import io.deephaven.extensions.barrage.util.StreamReaderOptions;
import io.deephaven.time.DateTimeUtils;
import io.deephaven.util.SafeCloseable;
import io.deephaven.util.datastructures.LongSizedDataStructure;
import io.deephaven.util.type.TypeUtils;
import io.deephaven.vector.Vector;
import java.io.DataInput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import org.apache.arrow.flatbuf.FieldNode;
import org.jetbrains.annotations.Nullable;

public interface ChunkInputStreamGenerator
extends SafeCloseable {
    public static <T> ChunkInputStreamGenerator makeInputStreamGenerator(ChunkType chunkType, Class<T> type, Class<?> componentType, Chunk<Values> chunk, long rowOffset) {
        switch (chunkType) {
            case Boolean: {
                throw new UnsupportedOperationException("Booleans are reinterpreted as bytes");
            }
            case Char: {
                return new CharChunkInputStreamGenerator((CharChunk<Values>)chunk.asCharChunk(), 2, rowOffset);
            }
            case Byte: {
                if (type == Boolean.class || type == Boolean.TYPE) {
                    return new BooleanChunkInputStreamGenerator((ByteChunk<Values>)chunk.asByteChunk(), rowOffset);
                }
                return new ByteChunkInputStreamGenerator((ByteChunk<Values>)chunk.asByteChunk(), 1, rowOffset);
            }
            case Short: {
                return new ShortChunkInputStreamGenerator((ShortChunk<Values>)chunk.asShortChunk(), 2, rowOffset);
            }
            case Int: {
                return new IntChunkInputStreamGenerator((IntChunk<Values>)chunk.asIntChunk(), 4, rowOffset);
            }
            case Long: {
                return new LongChunkInputStreamGenerator((LongChunk<Values>)chunk.asLongChunk(), 8, rowOffset);
            }
            case Float: {
                return new FloatChunkInputStreamGenerator((FloatChunk<Values>)chunk.asFloatChunk(), 4, rowOffset);
            }
            case Double: {
                return new DoubleChunkInputStreamGenerator((DoubleChunk<Values>)chunk.asDoubleChunk(), 8, rowOffset);
            }
            case Object: {
                if (type.isArray()) {
                    if (componentType == Byte.TYPE) {
                        return new VarBinaryChunkInputStreamGenerator<Object>(chunk.asObjectChunk(), rowOffset, (out, item) -> out.write((byte[])item));
                    }
                    return new VarListChunkInputStreamGenerator<T>(type, chunk.asObjectChunk(), rowOffset);
                }
                if (Vector.class.isAssignableFrom(type)) {
                    return new VectorChunkInputStreamGenerator(type, componentType, chunk.asObjectChunk(), rowOffset);
                }
                if (type == String.class) {
                    return new VarBinaryChunkInputStreamGenerator<String>(chunk.asObjectChunk(), rowOffset, (out, str) -> out.write(str.getBytes(Charsets.UTF_8)));
                }
                if (type == BigInteger.class) {
                    return new VarBinaryChunkInputStreamGenerator<BigInteger>(chunk.asObjectChunk(), rowOffset, (out, item) -> out.write(item.toByteArray()));
                }
                if (type == BigDecimal.class) {
                    return new VarBinaryChunkInputStreamGenerator<BigDecimal>(chunk.asObjectChunk(), rowOffset, (out, item) -> {
                        BigDecimal normal = item.stripTrailingZeros();
                        int v = normal.scale();
                        out.write(0xFF & v);
                        out.write(0xFF & v >> 8);
                        out.write(0xFF & v >> 16);
                        out.write(0xFF & v >> 24);
                        out.write(normal.unscaledValue().toByteArray());
                    });
                }
                if (type == Instant.class) {
                    ObjectChunk objChunk = chunk.asObjectChunk();
                    WritableLongChunk outChunk = WritableLongChunk.makeWritableChunk((int)objChunk.size());
                    for (int i = 0; i < objChunk.size(); ++i) {
                        outChunk.set(i, DateTimeUtils.epochNanos((Instant)((Instant)objChunk.get(i))));
                    }
                    if (chunk instanceof PoolableChunk) {
                        ((PoolableChunk)chunk).close();
                    }
                    return new LongChunkInputStreamGenerator((LongChunk<Values>)outChunk, 8, rowOffset);
                }
                if (type == ZonedDateTime.class) {
                    ObjectChunk objChunk = chunk.asObjectChunk();
                    WritableLongChunk outChunk = WritableLongChunk.makeWritableChunk((int)objChunk.size());
                    for (int i = 0; i < objChunk.size(); ++i) {
                        outChunk.set(i, DateTimeUtils.epochNanos((ZonedDateTime)((ZonedDateTime)objChunk.get(i))));
                    }
                    if (chunk instanceof PoolableChunk) {
                        ((PoolableChunk)chunk).close();
                    }
                    return new LongChunkInputStreamGenerator((LongChunk<Values>)outChunk, 8, rowOffset);
                }
                if (type == Boolean.class) {
                    return BooleanChunkInputStreamGenerator.convertBoxed((ObjectChunk<Boolean, Values>)chunk.asObjectChunk(), rowOffset);
                }
                if (type == Byte.class) {
                    return ByteChunkInputStreamGenerator.convertBoxed((ObjectChunk<Byte, Values>)chunk.asObjectChunk(), rowOffset);
                }
                if (type == Character.class) {
                    return CharChunkInputStreamGenerator.convertBoxed((ObjectChunk<Character, Values>)chunk.asObjectChunk(), rowOffset);
                }
                if (type == Double.class) {
                    return DoubleChunkInputStreamGenerator.convertBoxed((ObjectChunk<Double, Values>)chunk.asObjectChunk(), rowOffset);
                }
                if (type == Float.class) {
                    return FloatChunkInputStreamGenerator.convertBoxed((ObjectChunk<Float, Values>)chunk.asObjectChunk(), rowOffset);
                }
                if (type == Integer.class) {
                    return IntChunkInputStreamGenerator.convertBoxed((ObjectChunk<Integer, Values>)chunk.asObjectChunk(), rowOffset);
                }
                if (type == Long.class) {
                    return LongChunkInputStreamGenerator.convertBoxed((ObjectChunk<Long, Values>)chunk.asObjectChunk(), rowOffset);
                }
                if (type == Short.class) {
                    return ShortChunkInputStreamGenerator.convertBoxed((ObjectChunk<Short, Values>)chunk.asObjectChunk(), rowOffset);
                }
                return new VarBinaryChunkInputStreamGenerator<Object>(chunk.asObjectChunk(), rowOffset, (out, item) -> out.write(item.toString().getBytes(Charsets.UTF_8)));
            }
        }
        throw new UnsupportedOperationException();
    }

    public static WritableChunk<Values> extractChunkFromInputStream(StreamReaderOptions options, ChunkType chunkType, Class<?> type, Class<?> componentType, Iterator<FieldNodeInfo> fieldNodeIter, PrimitiveIterator.OfLong bufferInfoIter, DataInput is, WritableChunk<Values> outChunk, int offset, int totalRows) throws IOException {
        return ChunkInputStreamGenerator.extractChunkFromInputStream(options, 1, chunkType, type, componentType, fieldNodeIter, bufferInfoIter, is, outChunk, offset, totalRows);
    }

    public static WritableChunk<Values> extractChunkFromInputStream(StreamReaderOptions options, int factor, ChunkType chunkType, Class<?> type, Class<?> componentType, Iterator<FieldNodeInfo> fieldNodeIter, PrimitiveIterator.OfLong bufferInfoIter, DataInput is, WritableChunk<Values> outChunk, int outOffset, int totalRows) throws IOException {
        switch (chunkType) {
            case Boolean: {
                throw new UnsupportedOperationException("Booleans are reinterpreted as bytes");
            }
            case Char: {
                return CharChunkInputStreamGenerator.extractChunkFromInputStream(2, options, fieldNodeIter, bufferInfoIter, is, outChunk, outOffset, totalRows);
            }
            case Byte: {
                if (type == Boolean.class || type == Boolean.TYPE) {
                    return BooleanChunkInputStreamGenerator.extractChunkFromInputStream(options, fieldNodeIter, bufferInfoIter, is, outChunk, outOffset, totalRows);
                }
                return ByteChunkInputStreamGenerator.extractChunkFromInputStream(1, options, fieldNodeIter, bufferInfoIter, is, outChunk, outOffset, totalRows);
            }
            case Short: {
                return ShortChunkInputStreamGenerator.extractChunkFromInputStream(2, options, fieldNodeIter, bufferInfoIter, is, outChunk, outOffset, totalRows);
            }
            case Int: {
                return IntChunkInputStreamGenerator.extractChunkFromInputStream(4, options, fieldNodeIter, bufferInfoIter, is, outChunk, outOffset, totalRows);
            }
            case Long: {
                if (factor == 1) {
                    return LongChunkInputStreamGenerator.extractChunkFromInputStream(8, options, fieldNodeIter, bufferInfoIter, is, outChunk, outOffset, totalRows);
                }
                return LongChunkInputStreamGenerator.extractChunkFromInputStreamWithConversion(8, options, v -> v * (long)factor, fieldNodeIter, bufferInfoIter, is, outChunk, outOffset, totalRows);
            }
            case Float: {
                return FloatChunkInputStreamGenerator.extractChunkFromInputStream(4, options, fieldNodeIter, bufferInfoIter, is, outChunk, outOffset, totalRows);
            }
            case Double: {
                return DoubleChunkInputStreamGenerator.extractChunkFromInputStream(8, options, fieldNodeIter, bufferInfoIter, is, outChunk, outOffset, totalRows);
            }
            case Object: {
                if (type.isArray()) {
                    if (componentType == Byte.TYPE) {
                        return VarBinaryChunkInputStreamGenerator.extractChunkFromInputStream(is, fieldNodeIter, bufferInfoIter, (buf, off, len) -> Arrays.copyOfRange(buf, off, off + len), outChunk, outOffset, totalRows);
                    }
                    return VarListChunkInputStreamGenerator.extractChunkFromInputStream(options, type, fieldNodeIter, bufferInfoIter, is, outChunk, outOffset, totalRows);
                }
                if (Vector.class.isAssignableFrom(type)) {
                    return VectorChunkInputStreamGenerator.extractChunkFromInputStream(options, type, componentType, fieldNodeIter, bufferInfoIter, is, outChunk, outOffset, totalRows);
                }
                if (type == BigInteger.class) {
                    return VarBinaryChunkInputStreamGenerator.extractChunkFromInputStream(is, fieldNodeIter, bufferInfoIter, BigInteger::new, outChunk, outOffset, totalRows);
                }
                if (type == BigDecimal.class) {
                    return VarBinaryChunkInputStreamGenerator.extractChunkFromInputStream(is, fieldNodeIter, bufferInfoIter, (buf, offset, length) -> {
                        byte b1 = buf[offset];
                        byte b2 = buf[offset + 1];
                        byte b3 = buf[offset + 2];
                        byte b4 = buf[offset + 3];
                        int scale = b4 << 24 | (b3 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b1 & 0xFF;
                        return new BigDecimal(new BigInteger(buf, offset + 4, length - 4), scale);
                    }, outChunk, outOffset, totalRows);
                }
                if (type == Instant.class) {
                    return FixedWidthChunkInputStreamGenerator.extractChunkFromInputStreamWithTypeConversion(8, options, io -> DateTimeUtils.epochNanosToInstant((long)io.readLong()), fieldNodeIter, bufferInfoIter, is, outChunk, outOffset, totalRows);
                }
                if (type == ZonedDateTime.class) {
                    return FixedWidthChunkInputStreamGenerator.extractChunkFromInputStreamWithTypeConversion(8, options, io -> DateTimeUtils.epochNanosToZonedDateTime((long)io.readLong(), (ZoneId)DateTimeUtils.timeZone()), fieldNodeIter, bufferInfoIter, is, outChunk, outOffset, totalRows);
                }
                if (type == Byte.class) {
                    return FixedWidthChunkInputStreamGenerator.extractChunkFromInputStreamWithTypeConversion(1, options, io -> TypeUtils.box((byte)io.readByte()), fieldNodeIter, bufferInfoIter, is, outChunk, outOffset, totalRows);
                }
                if (type == Character.class) {
                    return FixedWidthChunkInputStreamGenerator.extractChunkFromInputStreamWithTypeConversion(2, options, io -> TypeUtils.box((char)io.readChar()), fieldNodeIter, bufferInfoIter, is, outChunk, outOffset, totalRows);
                }
                if (type == Double.class) {
                    return FixedWidthChunkInputStreamGenerator.extractChunkFromInputStreamWithTypeConversion(8, options, io -> TypeUtils.box((double)io.readDouble()), fieldNodeIter, bufferInfoIter, is, outChunk, outOffset, totalRows);
                }
                if (type == Float.class) {
                    return FixedWidthChunkInputStreamGenerator.extractChunkFromInputStreamWithTypeConversion(4, options, io -> TypeUtils.box((float)io.readFloat()), fieldNodeIter, bufferInfoIter, is, outChunk, outOffset, totalRows);
                }
                if (type == Integer.class) {
                    return FixedWidthChunkInputStreamGenerator.extractChunkFromInputStreamWithTypeConversion(4, options, io -> TypeUtils.box((int)io.readInt()), fieldNodeIter, bufferInfoIter, is, outChunk, outOffset, totalRows);
                }
                if (type == Long.class) {
                    return FixedWidthChunkInputStreamGenerator.extractChunkFromInputStreamWithTypeConversion(8, options, io -> TypeUtils.box((long)io.readLong()), fieldNodeIter, bufferInfoIter, is, outChunk, outOffset, totalRows);
                }
                if (type == Short.class) {
                    return FixedWidthChunkInputStreamGenerator.extractChunkFromInputStreamWithTypeConversion(2, options, io -> TypeUtils.box((short)io.readShort()), fieldNodeIter, bufferInfoIter, is, outChunk, outOffset, totalRows);
                }
                if (type == String.class || options.columnConversionMode().equals((Object)ColumnConversionMode.Stringify)) {
                    return VarBinaryChunkInputStreamGenerator.extractChunkFromInputStream(is, fieldNodeIter, bufferInfoIter, (buf, off, len) -> new String(buf, off, len, Charsets.UTF_8), outChunk, outOffset, totalRows);
                }
                throw new UnsupportedOperationException("Do not yet support column conversion mode: " + options.columnConversionMode());
            }
        }
        throw new UnsupportedOperationException();
    }

    public long getRowOffset();

    public long getLastRowOffset();

    public DrainableColumn getInputStream(StreamReaderOptions var1, @Nullable RowSet var2) throws IOException;

    public static abstract class DrainableColumn
    extends DefensiveDrainable {
        public abstract void visitFieldNodes(FieldNodeListener var1);

        public abstract void visitBuffers(BufferListener var1);

        public abstract int nullCount();
    }

    @FunctionalInterface
    public static interface BufferListener {
        public void noteLogicalBuffer(long var1);
    }

    @FunctionalInterface
    public static interface FieldNodeListener {
        public void noteLogicalFieldNode(int var1, int var2);
    }

    public static final class BufferInfo {
        public final long length;

        public BufferInfo(long length) {
            this.length = length;
        }
    }

    public static final class FieldNodeInfo {
        public final int numElements;
        public final int nullCount;

        public FieldNodeInfo(int numElements, int nullCount) {
            this.numElements = numElements;
            this.nullCount = nullCount;
        }

        public FieldNodeInfo(FieldNode node) {
            this(LongSizedDataStructure.intSize((String)"FieldNodeInfo", (long)node.length()), LongSizedDataStructure.intSize((String)"FieldNodeInfo", (long)node.nullCount()));
        }
    }
}

