/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage.chunk;

import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.extensions.barrage.chunk.ChunkInputStreamGenerator;
import io.deephaven.extensions.barrage.util.StreamReaderOptions;
import io.deephaven.util.datastructures.LongSizedDataStructure;
import java.io.DataInput;
import java.io.IOException;
import java.util.Iterator;
import java.util.PrimitiveIterator;

public class FixedWidthChunkInputStreamGenerator {
    private static final String DEBUG_NAME = "FixedWidthChunkInputStreamGenerator";

    static <T> WritableObjectChunk<T, Values> extractChunkFromInputStreamWithTypeConversion(int elementSize, StreamReaderOptions options, TypeConversion<T> conversion, Iterator<ChunkInputStreamGenerator.FieldNodeInfo> fieldNodeIter, PrimitiveIterator.OfLong bufferInfoIter, DataInput is, WritableChunk<Values> outChunk, int outOffset, int totalRows) throws IOException {
        WritableObjectChunk chunk;
        ChunkInputStreamGenerator.FieldNodeInfo nodeInfo = fieldNodeIter.next();
        long validityBuffer = bufferInfoIter.nextLong();
        long payloadBuffer = bufferInfoIter.nextLong();
        if (outChunk != null) {
            chunk = outChunk.asWritableObjectChunk();
        } else {
            int numRows = Math.max(nodeInfo.numElements, totalRows);
            chunk = WritableObjectChunk.makeWritableChunk((int)numRows);
            chunk.setSize(numRows);
        }
        if (nodeInfo.numElements == 0) {
            return chunk;
        }
        int numValidityLongs = options.useDeephavenNulls() ? 0 : (nodeInfo.numElements + 63) / 64;
        try (WritableLongChunk isValid = WritableLongChunk.makeWritableChunk((int)numValidityLongs);){
            if (options.useDeephavenNulls() && validityBuffer != 0L) {
                throw new IllegalStateException("validity buffer is non-empty, but is unnecessary");
            }
            int jj = 0;
            long numValidityLongsPresent = Math.min((long)numValidityLongs, validityBuffer / 8L);
            while ((long)jj < numValidityLongsPresent) {
                isValid.set(jj, is.readLong());
                ++jj;
            }
            long valBufRead = (long)jj * 8L;
            if (valBufRead < validityBuffer) {
                is.skipBytes(LongSizedDataStructure.intSize((String)DEBUG_NAME, (long)(validityBuffer - valBufRead)));
            }
            while (jj < numValidityLongs) {
                isValid.set(jj, -1L);
                ++jj;
            }
            long payloadRead = (long)nodeInfo.numElements * (long)elementSize;
            if (payloadBuffer < payloadRead) {
                throw new IllegalStateException("payload buffer is too short for expected number of elements");
            }
            if (options.useDeephavenNulls()) {
                for (int ii = 0; ii < nodeInfo.numElements; ++ii) {
                    chunk.set(outOffset + ii, conversion.apply(is));
                }
            } else {
                FixedWidthChunkInputStreamGenerator.useValidityBuffer(elementSize, conversion, is, nodeInfo, chunk, outOffset, (WritableLongChunk<Values>)isValid);
            }
            long overhangPayload = payloadBuffer - payloadRead;
            if (overhangPayload > 0L) {
                is.skipBytes(LongSizedDataStructure.intSize((String)DEBUG_NAME, (long)overhangPayload));
            }
        }
        return chunk;
    }

    private static <T> void useValidityBuffer(int elementSize, TypeConversion<T> conversion, DataInput is, ChunkInputStreamGenerator.FieldNodeInfo nodeInfo, WritableObjectChunk<T, Values> chunk, int outOffset, WritableLongChunk<Values> isValid) throws IOException {
        int numElements = nodeInfo.numElements;
        int numValidityWords = (numElements + 63) / 64;
        int ei = 0;
        int pendingSkips = 0;
        for (int vi = 0; vi < numValidityWords; ++vi) {
            int bitsLeftInThisWord = Math.min(64, numElements - vi * 64);
            long validityWord = isValid.get(vi);
            do {
                if ((validityWord & 1L) == 1L) {
                    if (pendingSkips > 0) {
                        is.skipBytes(pendingSkips * elementSize);
                        chunk.fillWithNullValue(outOffset + ei, pendingSkips);
                        ei += pendingSkips;
                        pendingSkips = 0;
                    }
                    chunk.set(outOffset + ei++, conversion.apply(is));
                    validityWord >>= 1;
                    --bitsLeftInThisWord;
                    continue;
                }
                int skips = Math.min(Long.numberOfTrailingZeros(validityWord), bitsLeftInThisWord);
                pendingSkips += skips;
                validityWord >>= skips;
                bitsLeftInThisWord -= skips;
            } while (bitsLeftInThisWord > 0);
        }
        if (pendingSkips > 0) {
            is.skipBytes(pendingSkips * elementSize);
            chunk.fillWithNullValue(outOffset + ei, pendingSkips);
        }
    }

    @FunctionalInterface
    public static interface TypeConversion<T> {
        public T apply(DataInput var1) throws IOException;
    }
}

