/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage.chunk;

import com.google.common.io.LittleEndianDataOutputStream;
import io.deephaven.UncheckedDeephavenException;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.FloatChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableFloatChunk;
import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.chunk.util.pools.PoolableChunk;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.extensions.barrage.chunk.BaseChunkInputStreamGenerator;
import io.deephaven.extensions.barrage.chunk.ChunkInputStreamGenerator;
import io.deephaven.extensions.barrage.util.StreamReaderOptions;
import io.deephaven.util.datastructures.LongSizedDataStructure;
import io.deephaven.util.type.TypeUtils;
import java.io.DataInput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import org.jetbrains.annotations.Nullable;

public class FloatChunkInputStreamGenerator
extends BaseChunkInputStreamGenerator<FloatChunk<Values>> {
    private static final String DEBUG_NAME = "FloatChunkInputStreamGenerator";

    public static FloatChunkInputStreamGenerator convertBoxed(ObjectChunk<Float, Values> inChunk, long rowOffset) {
        WritableFloatChunk outChunk = WritableFloatChunk.makeWritableChunk((int)inChunk.size());
        for (int i = 0; i < inChunk.size(); ++i) {
            Float value = (Float)inChunk.get(i);
            outChunk.set(i, TypeUtils.unbox((Float)value));
        }
        if (inChunk instanceof PoolableChunk) {
            ((PoolableChunk)inChunk).close();
        }
        return new FloatChunkInputStreamGenerator((FloatChunk<Values>)outChunk, 4, rowOffset);
    }

    FloatChunkInputStreamGenerator(FloatChunk<Values> chunk, int elementSize, long rowOffset) {
        super(chunk, elementSize, rowOffset);
    }

    @Override
    public ChunkInputStreamGenerator.DrainableColumn getInputStream(StreamReaderOptions options, @Nullable RowSet subset) {
        return new FloatChunkInputStream(options, subset);
    }

    static WritableChunk<Values> extractChunkFromInputStream(int elementSize, StreamReaderOptions options, Iterator<ChunkInputStreamGenerator.FieldNodeInfo> fieldNodeIter, PrimitiveIterator.OfLong bufferInfoIter, DataInput is, WritableChunk<Values> outChunk, int outOffset, int totalRows) throws IOException {
        return FloatChunkInputStreamGenerator.extractChunkFromInputStreamWithConversion(elementSize, options, FloatConversion.IDENTITY, fieldNodeIter, bufferInfoIter, is, outChunk, outOffset, totalRows);
    }

    static WritableChunk<Values> extractChunkFromInputStreamWithConversion(int elementSize, StreamReaderOptions options, FloatConversion conversion, Iterator<ChunkInputStreamGenerator.FieldNodeInfo> fieldNodeIter, PrimitiveIterator.OfLong bufferInfoIter, DataInput is, WritableChunk<Values> outChunk, int outOffset, int totalRows) throws IOException {
        WritableFloatChunk chunk;
        ChunkInputStreamGenerator.FieldNodeInfo nodeInfo = fieldNodeIter.next();
        long validityBuffer = bufferInfoIter.nextLong();
        long payloadBuffer = bufferInfoIter.nextLong();
        if (outChunk != null) {
            chunk = outChunk.asWritableFloatChunk();
        } else {
            int numRows = Math.max(totalRows, nodeInfo.numElements);
            chunk = WritableFloatChunk.makeWritableChunk((int)numRows);
            chunk.setSize(numRows);
        }
        if (nodeInfo.numElements == 0) {
            return chunk;
        }
        int numValidityLongs = options.useDeephavenNulls() ? 0 : (nodeInfo.numElements + 63) / 64;
        try (WritableLongChunk isValid = WritableLongChunk.makeWritableChunk((int)numValidityLongs);){
            if (options.useDeephavenNulls() && validityBuffer != 0L) {
                throw new IllegalStateException("validity buffer is non-empty, but is unnecessary");
            }
            int jj = 0;
            while ((long)jj < Math.min((long)numValidityLongs, validityBuffer / 8L)) {
                isValid.set(jj, is.readLong());
                ++jj;
            }
            long valBufRead = (long)jj * 8L;
            if (valBufRead < validityBuffer) {
                is.skipBytes(LongSizedDataStructure.intSize((String)DEBUG_NAME, (long)(validityBuffer - valBufRead)));
            }
            while (jj < numValidityLongs) {
                isValid.set(jj, -1L);
                ++jj;
            }
            long payloadRead = (long)nodeInfo.numElements * (long)elementSize;
            if (payloadBuffer < payloadRead) {
                throw new IllegalStateException("payload buffer is too short for expected number of elements");
            }
            if (options.useDeephavenNulls()) {
                FloatChunkInputStreamGenerator.useDeephavenNulls(conversion, is, nodeInfo, (WritableFloatChunk<Values>)chunk, outOffset);
            } else {
                FloatChunkInputStreamGenerator.useValidityBuffer(elementSize, conversion, is, nodeInfo, (WritableFloatChunk<Values>)chunk, outOffset, (WritableLongChunk<Values>)isValid);
            }
            long overhangPayload = payloadBuffer - payloadRead;
            if (overhangPayload > 0L) {
                is.skipBytes(LongSizedDataStructure.intSize((String)DEBUG_NAME, (long)overhangPayload));
            }
        }
        return chunk;
    }

    private static void useDeephavenNulls(FloatConversion conversion, DataInput is, ChunkInputStreamGenerator.FieldNodeInfo nodeInfo, WritableFloatChunk<Values> chunk, int offset) throws IOException {
        if (conversion == FloatConversion.IDENTITY) {
            for (int ii = 0; ii < nodeInfo.numElements; ++ii) {
                chunk.set(offset + ii, is.readFloat());
            }
        } else {
            for (int ii = 0; ii < nodeInfo.numElements; ++ii) {
                float in = is.readFloat();
                float out = in == -3.4028235E38f ? in : conversion.apply(in);
                chunk.set(offset + ii, out);
            }
        }
    }

    private static void useValidityBuffer(int elementSize, FloatConversion conversion, DataInput is, ChunkInputStreamGenerator.FieldNodeInfo nodeInfo, WritableFloatChunk<Values> chunk, int offset, WritableLongChunk<Values> isValid) throws IOException {
        int numElements = nodeInfo.numElements;
        int numValidityWords = (numElements + 63) / 64;
        int ei = 0;
        int pendingSkips = 0;
        for (int vi = 0; vi < numValidityWords; ++vi) {
            int bitsLeftInThisWord = Math.min(64, numElements - vi * 64);
            long validityWord = isValid.get(vi);
            do {
                if ((validityWord & 1L) == 1L) {
                    if (pendingSkips > 0) {
                        is.skipBytes(pendingSkips * elementSize);
                        chunk.fillWithNullValue(offset + ei, pendingSkips);
                        ei += pendingSkips;
                        pendingSkips = 0;
                    }
                    chunk.set(offset + ei++, conversion.apply(is.readFloat()));
                    validityWord >>= 1;
                    --bitsLeftInThisWord;
                    continue;
                }
                int skips = Math.min(Long.numberOfTrailingZeros(validityWord), bitsLeftInThisWord);
                pendingSkips += skips;
                validityWord >>= skips;
                bitsLeftInThisWord -= skips;
            } while (bitsLeftInThisWord > 0);
        }
        if (pendingSkips > 0) {
            is.skipBytes(pendingSkips * elementSize);
            chunk.fillWithNullValue(offset + ei, pendingSkips);
        }
    }

    @FunctionalInterface
    public static interface FloatConversion {
        public static final FloatConversion IDENTITY = a -> a;

        public float apply(float var1);
    }

    private class FloatChunkInputStream
    extends BaseChunkInputStreamGenerator.BaseChunkInputStream {
        private int cachedNullCount;

        private FloatChunkInputStream(StreamReaderOptions options, RowSet subset) {
            super((BaseChunkInputStreamGenerator)FloatChunkInputStreamGenerator.this, (Chunk)((FloatChunk)FloatChunkInputStreamGenerator.this.chunk), options, subset);
            this.cachedNullCount = -1;
        }

        @Override
        public int nullCount() {
            if (this.options.useDeephavenNulls()) {
                return 0;
            }
            if (this.cachedNullCount == -1) {
                this.cachedNullCount = 0;
                this.subset.forAllRowKeys(row -> {
                    if (((FloatChunk)FloatChunkInputStreamGenerator.this.chunk).get((int)row) == -3.4028235E38f) {
                        ++this.cachedNullCount;
                    }
                });
            }
            return this.cachedNullCount;
        }

        @Override
        public void visitFieldNodes(ChunkInputStreamGenerator.FieldNodeListener listener) {
            listener.noteLogicalFieldNode(this.subset.intSize(FloatChunkInputStreamGenerator.DEBUG_NAME), this.nullCount());
        }

        @Override
        public void visitBuffers(ChunkInputStreamGenerator.BufferListener listener) {
            listener.noteLogicalBuffer(this.sendValidityBuffer() ? (long)BaseChunkInputStreamGenerator.getValidityMapSerializationSizeFor(this.subset.intSize()) : 0L);
            long length = (long)FloatChunkInputStreamGenerator.this.elementSize * this.subset.size();
            long bytesExtended = length & 7L;
            if (bytesExtended > 0L) {
                length += 8L - bytesExtended;
            }
            listener.noteLogicalBuffer(length);
        }

        public int drainTo(OutputStream outputStream) throws IOException {
            if (this.read || this.subset.isEmpty()) {
                return 0;
            }
            long bytesWritten = 0L;
            this.read = true;
            LittleEndianDataOutputStream dos = new LittleEndianDataOutputStream(outputStream);
            if (this.sendValidityBuffer()) {
                BaseChunkInputStreamGenerator.SerContext context = new BaseChunkInputStreamGenerator.SerContext();
                Runnable flush = () -> {
                    try {
                        dos.writeLong(context.accumulator);
                    }
                    catch (IOException e) {
                        throw new UncheckedDeephavenException("Unexpected exception while draining data to OutputStream: ", (Throwable)e);
                    }
                    context.accumulator = 0L;
                    context.count = 0L;
                };
                this.subset.forAllRowKeys(row -> {
                    if (((FloatChunk)FloatChunkInputStreamGenerator.this.chunk).get((int)row) != -3.4028235E38f) {
                        context.accumulator |= 1L << (int)context.count;
                    }
                    if (++context.count == 64L) {
                        flush.run();
                    }
                });
                if (context.count > 0L) {
                    flush.run();
                }
                bytesWritten += (long)BaseChunkInputStreamGenerator.getValidityMapSerializationSizeFor(this.subset.intSize());
            }
            this.subset.forAllRowKeys(row -> {
                try {
                    float val = ((FloatChunk)FloatChunkInputStreamGenerator.this.chunk).get((int)row);
                    dos.writeFloat(val);
                }
                catch (IOException e) {
                    throw new UncheckedDeephavenException("Unexpected exception while draining data to OutputStream: ", (Throwable)e);
                }
            });
            long bytesExtended = (bytesWritten += (long)FloatChunkInputStreamGenerator.this.elementSize * this.subset.size()) & 7L;
            if (bytesExtended > 0L) {
                bytesWritten += 8L - bytesExtended;
                dos.write(BaseChunkInputStreamGenerator.PADDING_BUFFER, 0, (int)(8L - bytesExtended));
            }
            return LongSizedDataStructure.intSize((String)FloatChunkInputStreamGenerator.DEBUG_NAME, (long)bytesWritten);
        }
    }
}

