/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage.chunk;

import com.google.common.io.LittleEndianDataOutputStream;
import io.deephaven.extensions.barrage.chunk.ChunkInputStreamGenerator;
import java.io.IOException;
import java.io.OutputStream;

public class SingleElementListHeaderInputStreamGenerator
extends ChunkInputStreamGenerator.DrainableColumn {
    private final int numElements;

    public SingleElementListHeaderInputStreamGenerator(int numElements) {
        this.numElements = numElements;
    }

    @Override
    public void visitFieldNodes(ChunkInputStreamGenerator.FieldNodeListener listener) {
        listener.noteLogicalFieldNode(1, 0);
    }

    @Override
    public void visitBuffers(ChunkInputStreamGenerator.BufferListener listener) {
        listener.noteLogicalBuffer(0L);
        listener.noteLogicalBuffer(8L);
    }

    @Override
    public int nullCount() {
        return 0;
    }

    public int drainTo(OutputStream outputStream) throws IOException {
        LittleEndianDataOutputStream dos = new LittleEndianDataOutputStream(outputStream);
        dos.writeInt(0);
        dos.writeInt(this.numElements);
        dos.flush();
        return 8;
    }

    @Override
    public int available() throws IOException {
        return 8;
    }
}

