/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage.chunk;

import com.google.common.io.LittleEndianDataOutputStream;
import io.deephaven.UncheckedDeephavenException;
import io.deephaven.base.verify.Assert;
import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.ByteChunkToOutputStreamAdapter;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableByteChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableIntChunk;
import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.ChunkPositions;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.chunk.util.pools.PoolableChunk;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.extensions.barrage.chunk.BaseChunkInputStreamGenerator;
import io.deephaven.extensions.barrage.chunk.ChunkInputStreamGenerator;
import io.deephaven.extensions.barrage.util.StreamReaderOptions;
import io.deephaven.util.SafeCloseable;
import io.deephaven.util.datastructures.LongSizedDataStructure;
import java.io.DataInput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VarBinaryChunkInputStreamGenerator<T>
extends BaseChunkInputStreamGenerator<ObjectChunk<T, Values>> {
    private static final String DEBUG_NAME = "ObjectChunkInputStream Serialization";
    private static final int BYTE_CHUNK_SIZE = 65536;
    private final Appender<T> appendItem;
    private ByteStorage byteStorage = null;

    VarBinaryChunkInputStreamGenerator(ObjectChunk<T, Values> chunk, long rowOffset, Appender<T> appendItem) {
        super(chunk, 0, rowOffset);
        this.appendItem = appendItem;
    }

    private synchronized void computePayload() throws IOException {
        if (this.byteStorage != null) {
            return;
        }
        this.byteStorage = new ByteStorage(((ObjectChunk)this.chunk).size() == 0 ? 0 : ((ObjectChunk)this.chunk).size() + 1);
        if (((ObjectChunk)this.chunk).size() > 0) {
            this.byteStorage.offsets.set(0, 0L);
        }
        for (int i = 0; i < ((ObjectChunk)this.chunk).size(); ++i) {
            if (((ObjectChunk)this.chunk).get(i) != null) {
                this.appendItem.append(this.byteStorage, ((ObjectChunk)this.chunk).get(i));
            }
            this.byteStorage.offsets.set(i + 1, this.byteStorage.size());
        }
    }

    @Override
    public void close() {
        if (REFERENCE_COUNT_UPDATER.decrementAndGet(this) == 0) {
            if (this.chunk instanceof PoolableChunk) {
                ((PoolableChunk)this.chunk).close();
            }
            if (this.byteStorage != null) {
                this.byteStorage.close();
            }
        }
    }

    @Override
    public ChunkInputStreamGenerator.DrainableColumn getInputStream(StreamReaderOptions options, @Nullable RowSet subset) throws IOException {
        this.computePayload();
        return new ObjectChunkInputStream(options, subset);
    }

    static <T> WritableObjectChunk<T, Values> extractChunkFromInputStream(DataInput is, Iterator<ChunkInputStreamGenerator.FieldNodeInfo> fieldNodeIter, PrimitiveIterator.OfLong bufferInfoIter, Mapper<T> mapper, WritableChunk<Values> outChunk, int outOffset, int totalRows) throws IOException {
        WritableObjectChunk chunk;
        ChunkInputStreamGenerator.FieldNodeInfo nodeInfo = fieldNodeIter.next();
        long validityBuffer = bufferInfoIter.nextLong();
        long offsetsBuffer = bufferInfoIter.nextLong();
        long payloadBuffer = bufferInfoIter.nextLong();
        int numElements = nodeInfo.numElements;
        if (outChunk != null) {
            chunk = outChunk.asWritableObjectChunk();
        } else {
            int numRows = Math.max(totalRows, numElements);
            chunk = WritableObjectChunk.makeWritableChunk((int)numRows);
            chunk.setSize(numRows);
        }
        if (numElements == 0) {
            return chunk;
        }
        int numValidityWords = (numElements + 63) / 64;
        try (WritableLongChunk isValid = WritableLongChunk.makeWritableChunk((int)numValidityWords);
             WritableIntChunk offsets = WritableIntChunk.makeWritableChunk((int)(numElements + 1));){
            int jj = 0;
            while ((long)jj < Math.min((long)numValidityWords, validityBuffer / 8L)) {
                isValid.set(jj, is.readLong());
                ++jj;
            }
            long valBufRead = (long)jj * 8L;
            if (valBufRead < validityBuffer) {
                is.skipBytes(LongSizedDataStructure.intSize((String)DEBUG_NAME, (long)(validityBuffer - valBufRead)));
            }
            while (jj < numValidityWords) {
                isValid.set(jj, -1L);
                ++jj;
            }
            long offBufRead = ((long)numElements + 1L) * 4L;
            if (offsetsBuffer < offBufRead) {
                throw new IllegalStateException("offset buffer is too short for the expected number of elements");
            }
            for (int i = 0; i < numElements + 1; ++i) {
                offsets.set(i, is.readInt());
            }
            if (offBufRead < offsetsBuffer) {
                is.skipBytes(LongSizedDataStructure.intSize((String)DEBUG_NAME, (long)(offsetsBuffer - offBufRead)));
            }
            int bytesRead = LongSizedDataStructure.intSize((String)DEBUG_NAME, (long)payloadBuffer);
            byte[] serializedData = new byte[bytesRead];
            is.readFully(serializedData);
            int ei = 0;
            int pendingSkips = 0;
            for (int vi = 0; vi < numValidityWords; ++vi) {
                int bitsLeftInThisWord = Math.min(64, numElements - vi * 64);
                long validityWord = isValid.get(vi);
                do {
                    if ((validityWord & 1L) == 1L) {
                        if (pendingSkips > 0) {
                            chunk.fillWithNullValue(outOffset + ei, pendingSkips);
                            ei += pendingSkips;
                            pendingSkips = 0;
                        }
                        int offset = offsets.get(ei);
                        int length = offsets.get(ei + 1) - offset;
                        Assert.geq((int)length, (String)"length", (int)0);
                        if (offset + length > serializedData.length) {
                            throw new IllegalStateException("not enough data was serialized to parse this element: elementIndex=" + ei + " offset=" + offset + " length=" + length + " serializedLen=" + serializedData.length);
                        }
                        chunk.set(outOffset + ei++, mapper.constructFrom(serializedData, offset, length));
                        validityWord >>= 1;
                        --bitsLeftInThisWord;
                        continue;
                    }
                    int skips = Math.min(Long.numberOfTrailingZeros(validityWord), bitsLeftInThisWord);
                    pendingSkips += skips;
                    validityWord >>= skips;
                    bitsLeftInThisWord -= skips;
                } while (bitsLeftInThisWord > 0);
            }
            if (pendingSkips > 0) {
                chunk.fillWithNullValue(outOffset + ei, pendingSkips);
            }
        }
        return chunk;
    }

    private class ObjectChunkInputStream
    extends BaseChunkInputStreamGenerator.BaseChunkInputStream {
        private int cachedSize;
        private int cachedNullCount;

        private ObjectChunkInputStream(StreamReaderOptions options, RowSet subset) {
            super((BaseChunkInputStreamGenerator)VarBinaryChunkInputStreamGenerator.this, (Chunk)((ObjectChunk)VarBinaryChunkInputStreamGenerator.this.chunk), options, subset);
            this.cachedSize = -1;
            this.cachedNullCount = -1;
        }

        @Override
        public int nullCount() {
            if (this.cachedNullCount == -1) {
                this.cachedNullCount = 0;
                this.subset.forAllRowKeys(i -> {
                    if (((ObjectChunk)VarBinaryChunkInputStreamGenerator.this.chunk).get((int)i) == null) {
                        ++this.cachedNullCount;
                    }
                });
            }
            return this.cachedNullCount;
        }

        @Override
        public void visitFieldNodes(ChunkInputStreamGenerator.FieldNodeListener listener) {
            listener.noteLogicalFieldNode(this.subset.intSize(VarBinaryChunkInputStreamGenerator.DEBUG_NAME), this.nullCount());
        }

        @Override
        public void visitBuffers(ChunkInputStreamGenerator.BufferListener listener) {
            int numElements = this.subset.intSize(VarBinaryChunkInputStreamGenerator.DEBUG_NAME);
            listener.noteLogicalBuffer(this.sendValidityBuffer() ? (long)BaseChunkInputStreamGenerator.getValidityMapSerializationSizeFor(numElements) : 0L);
            long numOffsetBytes = 4L * ((long)numElements + (long)(numElements > 0 ? 1 : 0));
            long bytesExtended = numOffsetBytes & 7L;
            if (bytesExtended > 0L) {
                numOffsetBytes += 8L - bytesExtended;
            }
            listener.noteLogicalBuffer(numOffsetBytes);
            MutableLong numPayloadBytes = new MutableLong();
            this.subset.forAllRowKeyRanges((s, e) -> numPayloadBytes.add(VarBinaryChunkInputStreamGenerator.this.byteStorage.getPayloadSize((int)s, (int)e)));
            long payloadExtended = numPayloadBytes.longValue() & 7L;
            if (payloadExtended > 0L) {
                numPayloadBytes.add(8L - payloadExtended);
            }
            listener.noteLogicalBuffer(numPayloadBytes.longValue());
        }

        @Override
        protected int getRawSize() {
            if (this.cachedSize == -1) {
                MutableLong totalCachedSize = new MutableLong(0L);
                if (this.sendValidityBuffer()) {
                    totalCachedSize.add((long)BaseChunkInputStreamGenerator.getValidityMapSerializationSizeFor(this.subset.intSize(VarBinaryChunkInputStreamGenerator.DEBUG_NAME)));
                }
                if (!this.subset.isEmpty() && this.subset.size() == (long)(VarBinaryChunkInputStreamGenerator.this.byteStorage.offsets.size() - 1)) {
                    totalCachedSize.add((long)VarBinaryChunkInputStreamGenerator.this.byteStorage.offsets.size() * 4L);
                    totalCachedSize.add(VarBinaryChunkInputStreamGenerator.this.byteStorage.size());
                } else {
                    totalCachedSize.add(this.subset.isEmpty() ? 0L : 4L);
                    this.subset.forAllRowKeyRanges((s, e) -> {
                        totalCachedSize.add((e - s + 1L) * 4L);
                        totalCachedSize.add(VarBinaryChunkInputStreamGenerator.this.byteStorage.getPayloadSize((int)s, (int)e));
                    });
                }
                if (!this.subset.isEmpty() && (this.subset.size() & 1L) == 0L) {
                    totalCachedSize.add(4L);
                }
                this.cachedSize = LongSizedDataStructure.intSize((String)VarBinaryChunkInputStreamGenerator.DEBUG_NAME, (long)totalCachedSize.longValue());
            }
            return this.cachedSize;
        }

        public int drainTo(OutputStream outputStream) throws IOException {
            if (this.read || this.subset.isEmpty()) {
                return 0;
            }
            this.read = true;
            long bytesWritten = 0L;
            LittleEndianDataOutputStream dos = new LittleEndianDataOutputStream(outputStream);
            if (this.sendValidityBuffer()) {
                BaseChunkInputStreamGenerator.SerContext context = new BaseChunkInputStreamGenerator.SerContext();
                Runnable flush = () -> {
                    try {
                        dos.writeLong(context.accumulator);
                    }
                    catch (IOException e) {
                        throw new UncheckedDeephavenException("couldn't drain data to OutputStream", (Throwable)e);
                    }
                    context.accumulator = 0L;
                    context.count = 0L;
                };
                this.subset.forAllRowKeys(rawRow -> {
                    int row = LongSizedDataStructure.intSize((String)VarBinaryChunkInputStreamGenerator.DEBUG_NAME, (long)rawRow);
                    if (((ObjectChunk)VarBinaryChunkInputStreamGenerator.this.chunk).get(row) != null) {
                        context.accumulator |= 1L << (int)context.count;
                    }
                    if (++context.count == 64L) {
                        flush.run();
                    }
                });
                if (context.count > 0L) {
                    flush.run();
                }
                bytesWritten += (long)BaseChunkInputStreamGenerator.getValidityMapSerializationSizeFor(this.subset.intSize(VarBinaryChunkInputStreamGenerator.DEBUG_NAME));
            }
            dos.writeInt(0);
            MutableInt logicalSize = new MutableInt();
            this.subset.forAllRowKeys(idx -> {
                try {
                    logicalSize.add((Number)VarBinaryChunkInputStreamGenerator.this.byteStorage.getPayloadSize((int)idx, (int)idx));
                    dos.writeInt(logicalSize.intValue());
                }
                catch (IOException e) {
                    throw new UncheckedDeephavenException("couldn't drain data to OutputStream", (Throwable)e);
                }
            });
            bytesWritten += 4L * (this.subset.size() + 1L);
            if ((this.subset.size() & 1L) == 0L) {
                dos.writeInt(0);
                bytesWritten += 4L;
            }
            MutableLong payloadLen = new MutableLong();
            this.subset.forAllRowKeyRanges((s, e) -> {
                try {
                    payloadLen.add(VarBinaryChunkInputStreamGenerator.this.byteStorage.writePayload(dos, (int)s, (int)e));
                }
                catch (IOException err) {
                    throw new UncheckedDeephavenException("couldn't drain data to OutputStream", (Throwable)err);
                }
            });
            long bytesExtended = (bytesWritten += payloadLen.longValue()) & 7L;
            if (bytesExtended > 0L) {
                bytesWritten += 8L - bytesExtended;
                dos.write(BaseChunkInputStreamGenerator.PADDING_BUFFER, 0, (int)(8L - bytesExtended));
            }
            return LongSizedDataStructure.intSize((String)VarBinaryChunkInputStreamGenerator.DEBUG_NAME, (long)bytesWritten);
        }
    }

    public static interface Mapper<T> {
        public T constructFrom(byte[] var1, int var2, int var3) throws IOException;
    }

    public static interface Appender<T> {
        public void append(OutputStream var1, T var2) throws IOException;
    }

    public static class ByteStorage
    extends OutputStream
    implements SafeCloseable {
        private final WritableLongChunk<ChunkPositions> offsets;
        private final ArrayList<WritableByteChunk<Values>> byteChunks;
        private long writtenTotalByteCount = 0L;
        private int activeChunkByteCount = 0;
        private WritableByteChunk<Values> activeChunk = null;

        public ByteStorage(int size) {
            this.offsets = WritableLongChunk.makeWritableChunk((int)size);
            this.byteChunks = new ArrayList();
            this.activeChunk = WritableByteChunk.makeWritableChunk((int)65536);
            this.byteChunks.add((WritableByteChunk<Values>)this.activeChunk);
        }

        public boolean isEmpty() {
            return this.writtenTotalByteCount == 0L;
        }

        @Override
        public synchronized void write(int b) throws IOException {
            this.activeChunk.set(this.activeChunkByteCount++, (byte)b);
            ++this.writtenTotalByteCount;
            if (this.activeChunkByteCount == 65536) {
                this.activeChunk = WritableByteChunk.makeWritableChunk((int)65536);
                this.byteChunks.add((WritableByteChunk<Values>)this.activeChunk);
                this.activeChunkByteCount = 0;
            }
        }

        @Override
        public synchronized void write(@NotNull byte[] b, int off, int len) throws IOException {
            int writeLen;
            for (int remaining = len; remaining > 0; remaining -= writeLen) {
                writeLen = Math.min(remaining, 65536 - this.activeChunkByteCount);
                this.activeChunk.copyFromTypedArray(b, off, this.activeChunkByteCount, writeLen);
                this.writtenTotalByteCount += (long)writeLen;
                this.activeChunkByteCount += writeLen;
                off += writeLen;
                if (this.activeChunkByteCount != 65536) continue;
                this.activeChunk = WritableByteChunk.makeWritableChunk((int)65536);
                this.byteChunks.add((WritableByteChunk<Values>)this.activeChunk);
                this.activeChunkByteCount = 0;
            }
        }

        public long size() {
            return this.writtenTotalByteCount;
        }

        public long getPayloadSize(int sPos, int ePos) {
            return this.offsets.get(ePos + 1) - this.offsets.get(sPos);
        }

        public long writePayload(LittleEndianDataOutputStream dos, int sPos, int ePos) throws IOException {
            long writeLen;
            int len;
            long startBytePos = this.offsets.get(sPos);
            for (long remainingBytes = writeLen = this.getPayloadSize(sPos, ePos); remainingBytes > 0L; remainingBytes -= (long)len) {
                int chunkIdx = (int)(startBytePos / 65536L);
                int byteIdx = (int)(startBytePos % 65536L);
                ByteChunk chunk = (ByteChunk)this.byteChunks.get(chunkIdx);
                len = (int)Math.min(remainingBytes, (long)(65536 - byteIdx));
                ByteChunkToOutputStreamAdapter.write((OutputStream)dos, (ByteChunk)chunk, (int)byteIdx, (int)len);
                startBytePos += (long)len;
            }
            return writeLen;
        }

        @Override
        public void close() {
            try {
                super.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.offsets.close();
            for (WritableByteChunk<Values> chunk : this.byteChunks) {
                chunk.close();
            }
        }
    }
}

