/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage.chunk;

import com.google.common.io.LittleEndianDataOutputStream;
import io.deephaven.UncheckedDeephavenException;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableIntChunk;
import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.ChunkPositions;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.chunk.util.pools.PoolableChunk;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetBuilderSequential;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.extensions.barrage.chunk.BaseChunkInputStreamGenerator;
import io.deephaven.extensions.barrage.chunk.ChunkInputStreamGenerator;
import io.deephaven.extensions.barrage.chunk.vector.VectorExpansionKernel;
import io.deephaven.extensions.barrage.util.StreamReaderOptions;
import io.deephaven.util.datastructures.LongSizedDataStructure;
import io.deephaven.vector.Vector;
import java.io.DataInput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class VectorChunkInputStreamGenerator
extends BaseChunkInputStreamGenerator<ObjectChunk<Vector<?>, Values>> {
    private static final String DEBUG_NAME = "VarListChunkInputStreamGenerator";
    private final Class<?> componentType;
    private WritableIntChunk<ChunkPositions> offsets;
    private ChunkInputStreamGenerator innerGenerator;

    VectorChunkInputStreamGenerator(Class<Vector<?>> type, Class<?> componentType, ObjectChunk<Vector<?>, Values> chunk, long rowOffset) {
        super(chunk, 0, rowOffset);
        this.componentType = VectorExpansionKernel.getComponentType(type, componentType);
    }

    private synchronized void computePayload() {
        if (this.innerGenerator != null) {
            return;
        }
        Class<?> innerComponentType = this.componentType != null ? this.componentType.getComponentType() : null;
        ChunkType chunkType = ChunkType.fromElementType(this.componentType);
        VectorExpansionKernel kernel = VectorExpansionKernel.makeExpansionKernel(chunkType, this.componentType);
        this.offsets = WritableIntChunk.makeWritableChunk((int)(((ObjectChunk)this.chunk).size() + 1));
        WritableChunk innerChunk = kernel.expand((ObjectChunk)this.chunk, this.offsets);
        this.innerGenerator = ChunkInputStreamGenerator.makeInputStreamGenerator(chunkType, this.componentType, innerComponentType, innerChunk, 0L);
    }

    @Override
    public void close() {
        if (REFERENCE_COUNT_UPDATER.decrementAndGet(this) == 0) {
            if (this.chunk instanceof PoolableChunk) {
                ((PoolableChunk)this.chunk).close();
            }
            if (this.offsets != null) {
                this.offsets.close();
            }
            if (this.innerGenerator != null) {
                this.innerGenerator.close();
            }
        }
    }

    @Override
    public ChunkInputStreamGenerator.DrainableColumn getInputStream(StreamReaderOptions options, @Nullable RowSet subset) throws IOException {
        this.computePayload();
        return new VarListInputStream(options, subset);
    }

    static WritableObjectChunk<Vector<?>, Values> extractChunkFromInputStream(StreamReaderOptions options, Class<Vector<?>> type, Class<?> inComponentType, Iterator<ChunkInputStreamGenerator.FieldNodeInfo> fieldNodeIter, PrimitiveIterator.OfLong bufferInfoIter, DataInput is, WritableChunk<Values> outChunk, int outOffset, int totalRows) throws IOException {
        WritableObjectChunk<Vector<?>, Values> chunk;
        ChunkInputStreamGenerator.FieldNodeInfo nodeInfo = fieldNodeIter.next();
        long validityBuffer = bufferInfoIter.nextLong();
        long offsetsBuffer = bufferInfoIter.nextLong();
        Class<?> componentType = VectorExpansionKernel.getComponentType(type, inComponentType);
        ChunkType chunkType = ChunkType.fromElementType(componentType);
        if (nodeInfo.numElements == 0) {
            try (WritableChunk<Values> ignored = ChunkInputStreamGenerator.extractChunkFromInputStream(options, chunkType, componentType, componentType.getComponentType(), fieldNodeIter, bufferInfoIter, is, null, 0, 0);){
                if (outChunk != null) {
                    WritableObjectChunk writableObjectChunk = outChunk.asWritableObjectChunk();
                    return writableObjectChunk;
                }
                WritableObjectChunk writableObjectChunk = WritableObjectChunk.makeWritableChunk((int)totalRows);
                return writableObjectChunk;
            }
        }
        int numValidityLongs = (nodeInfo.numElements + 63) / 64;
        try (WritableLongChunk isValid = WritableLongChunk.makeWritableChunk((int)numValidityLongs);
             WritableIntChunk offsets = WritableIntChunk.makeWritableChunk((int)(nodeInfo.numElements + 1));){
            int jj = 0;
            while ((long)jj < Math.min((long)numValidityLongs, validityBuffer / 8L)) {
                isValid.set(jj, is.readLong());
                ++jj;
            }
            long valBufRead = (long)jj * 8L;
            if (valBufRead < validityBuffer) {
                is.skipBytes(LongSizedDataStructure.intSize((String)DEBUG_NAME, (long)(validityBuffer - valBufRead)));
            }
            while (jj < numValidityLongs) {
                isValid.set(jj, -1L);
                ++jj;
            }
            long offBufRead = ((long)nodeInfo.numElements + 1L) * 4L;
            if (offsetsBuffer < offBufRead) {
                throw new IllegalStateException("offset buffer is too short for the expected number of elements");
            }
            for (int i = 0; i < nodeInfo.numElements + 1; ++i) {
                offsets.set(i, is.readInt());
            }
            if (offBufRead < offsetsBuffer) {
                is.skipBytes(LongSizedDataStructure.intSize((String)DEBUG_NAME, (long)(offsetsBuffer - offBufRead)));
            }
            VectorExpansionKernel kernel = VectorExpansionKernel.makeExpansionKernel(chunkType, componentType);
            try (WritableChunk<Values> inner = ChunkInputStreamGenerator.extractChunkFromInputStream(options, chunkType, componentType, componentType.getComponentType(), fieldNodeIter, bufferInfoIter, is, null, 0, 0);){
                chunk = kernel.contract(inner, (IntChunk<ChunkPositions>)offsets, outChunk, outOffset, totalRows);
                long nextValid = 0L;
                for (int ii = 0; ii < nodeInfo.numElements; ++ii) {
                    if (ii % 64 == 0) {
                        nextValid = isValid.get(ii / 64);
                    }
                    if ((nextValid & 1L) == 0L) {
                        chunk.set(outOffset + ii, null);
                    }
                    nextValid >>= 1;
                }
            }
        }
        return chunk;
    }

    private class VarListInputStream
    extends BaseChunkInputStreamGenerator.BaseChunkInputStream {
        private int cachedSize;
        private final WritableIntChunk<ChunkPositions> myOffsets;
        private final ChunkInputStreamGenerator.DrainableColumn innerStream;
        private int cachedNullCount;

        private VarListInputStream(StreamReaderOptions options, RowSet subsetIn) throws IOException {
            super((BaseChunkInputStreamGenerator)VectorChunkInputStreamGenerator.this, (Chunk)((ObjectChunk)VectorChunkInputStreamGenerator.this.chunk), options, subsetIn);
            this.cachedSize = -1;
            this.cachedNullCount = -1;
            if (this.subset.size() != (long)(VectorChunkInputStreamGenerator.this.offsets.size() - 1)) {
                this.myOffsets = WritableIntChunk.makeWritableChunk((int)(this.subset.intSize(VectorChunkInputStreamGenerator.DEBUG_NAME) + 1));
                this.myOffsets.set(0, 0);
                RowSetBuilderSequential myOffsetBuilder = RowSetFactory.builderSequential();
                MutableInt off = new MutableInt();
                this.subset.forAllRowKeys(key -> {
                    int startOffset = VectorChunkInputStreamGenerator.this.offsets.get(LongSizedDataStructure.intSize((String)VectorChunkInputStreamGenerator.DEBUG_NAME, (long)key));
                    int endOffset = VectorChunkInputStreamGenerator.this.offsets.get(LongSizedDataStructure.intSize((String)VectorChunkInputStreamGenerator.DEBUG_NAME, (long)(key + 1L)));
                    int idx = off.incrementAndGet();
                    this.myOffsets.set(idx, endOffset - startOffset + this.myOffsets.get(idx - 1));
                    if (endOffset > startOffset) {
                        myOffsetBuilder.appendRange((long)startOffset, (long)(endOffset - 1));
                    }
                });
                try (WritableRowSet mySubset = myOffsetBuilder.build();){
                    this.innerStream = VectorChunkInputStreamGenerator.this.innerGenerator.getInputStream(options, (RowSet)mySubset);
                }
            } else {
                this.myOffsets = null;
                this.innerStream = VectorChunkInputStreamGenerator.this.innerGenerator.getInputStream(options, null);
            }
        }

        @Override
        public int nullCount() {
            if (this.cachedNullCount == -1) {
                this.cachedNullCount = 0;
                this.subset.forAllRowKeys(i -> {
                    if (((ObjectChunk)VectorChunkInputStreamGenerator.this.chunk).get((int)i) == null) {
                        ++this.cachedNullCount;
                    }
                });
            }
            return this.cachedNullCount;
        }

        @Override
        public void visitFieldNodes(ChunkInputStreamGenerator.FieldNodeListener listener) {
            listener.noteLogicalFieldNode(this.subset.intSize(VectorChunkInputStreamGenerator.DEBUG_NAME), this.nullCount());
            this.innerStream.visitFieldNodes(listener);
        }

        @Override
        public void visitBuffers(ChunkInputStreamGenerator.BufferListener listener) {
            int numElements = this.subset.intSize(VectorChunkInputStreamGenerator.DEBUG_NAME);
            listener.noteLogicalBuffer(this.sendValidityBuffer() ? (long)BaseChunkInputStreamGenerator.getValidityMapSerializationSizeFor(numElements) : 0L);
            long numOffsetBytes = 4L * ((long)numElements + (long)(numElements > 0 ? 1 : 0));
            long bytesExtended = numOffsetBytes & 7L;
            if (bytesExtended > 0L) {
                numOffsetBytes += 8L - bytesExtended;
            }
            listener.noteLogicalBuffer(numOffsetBytes);
            this.innerStream.visitBuffers(listener);
        }

        @Override
        public void close() throws IOException {
            super.close();
            if (this.myOffsets != null) {
                this.myOffsets.close();
            }
            this.innerStream.close();
        }

        @Override
        protected int getRawSize() throws IOException {
            if (this.cachedSize == -1) {
                this.cachedSize = this.sendValidityBuffer() ? BaseChunkInputStreamGenerator.getValidityMapSerializationSizeFor(this.subset.intSize(VectorChunkInputStreamGenerator.DEBUG_NAME)) : 0;
                this.cachedSize = (int)((long)this.cachedSize + (this.subset.size() * 4L + (long)(this.subset.isEmpty() ? 0 : 4)));
                if (!this.subset.isEmpty() && (this.subset.size() & 1L) == 0L) {
                    this.cachedSize += 4;
                }
                this.cachedSize += this.innerStream.available();
            }
            return this.cachedSize;
        }

        public int drainTo(OutputStream outputStream) throws IOException {
            if (this.read || this.subset.isEmpty()) {
                return 0;
            }
            this.read = true;
            long bytesWritten = 0L;
            LittleEndianDataOutputStream dos = new LittleEndianDataOutputStream(outputStream);
            if (this.sendValidityBuffer()) {
                BaseChunkInputStreamGenerator.SerContext context = new BaseChunkInputStreamGenerator.SerContext();
                Runnable flush = () -> {
                    try {
                        dos.writeLong(context.accumulator);
                    }
                    catch (IOException e) {
                        throw new UncheckedDeephavenException("couldn't drain data to OutputStream", (Throwable)e);
                    }
                    context.accumulator = 0L;
                    context.count = 0L;
                };
                this.subset.forAllRowKeys(rawRow -> {
                    int row = LongSizedDataStructure.intSize((String)VectorChunkInputStreamGenerator.DEBUG_NAME, (long)rawRow);
                    if (((ObjectChunk)VectorChunkInputStreamGenerator.this.chunk).get(row) != null) {
                        context.accumulator |= 1L << (int)context.count;
                    }
                    if (++context.count == 64L) {
                        flush.run();
                    }
                });
                if (context.count > 0L) {
                    flush.run();
                }
                bytesWritten += (long)BaseChunkInputStreamGenerator.getValidityMapSerializationSizeFor(this.subset.intSize(VectorChunkInputStreamGenerator.DEBUG_NAME));
            }
            WritableIntChunk<ChunkPositions> offsetsToUse = this.myOffsets == null ? VectorChunkInputStreamGenerator.this.offsets : this.myOffsets;
            for (int i = 0; i < offsetsToUse.size(); ++i) {
                dos.writeInt(offsetsToUse.get(i));
            }
            long bytesExtended = (bytesWritten += (long)offsetsToUse.size() * 4L) & 7L;
            if (bytesExtended > 0L) {
                bytesWritten += 8L - bytesExtended;
                dos.write(BaseChunkInputStreamGenerator.PADDING_BUFFER, 0, (int)(8L - bytesExtended));
            }
            return LongSizedDataStructure.intSize((String)VectorChunkInputStreamGenerator.DEBUG_NAME, (long)(bytesWritten += (long)this.innerStream.drainTo(outputStream)));
        }
    }
}

