/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage.chunk.array;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableIntChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.attributes.ChunkPositions;
import io.deephaven.extensions.barrage.chunk.array.BooleanArrayExpansionKernel;
import io.deephaven.extensions.barrage.chunk.array.BoxedBooleanArrayExpansionKernel;
import io.deephaven.extensions.barrage.chunk.array.ByteArrayExpansionKernel;
import io.deephaven.extensions.barrage.chunk.array.CharArrayExpansionKernel;
import io.deephaven.extensions.barrage.chunk.array.DoubleArrayExpansionKernel;
import io.deephaven.extensions.barrage.chunk.array.FloatArrayExpansionKernel;
import io.deephaven.extensions.barrage.chunk.array.IntArrayExpansionKernel;
import io.deephaven.extensions.barrage.chunk.array.LongArrayExpansionKernel;
import io.deephaven.extensions.barrage.chunk.array.ObjectArrayExpansionKernel;
import io.deephaven.extensions.barrage.chunk.array.ShortArrayExpansionKernel;

public interface ArrayExpansionKernel {
    public static ArrayExpansionKernel makeExpansionKernel(ChunkType chunkType, Class<?> componentType) {
        switch (chunkType) {
            case Char: {
                return CharArrayExpansionKernel.INSTANCE;
            }
            case Byte: {
                if (componentType == Boolean.TYPE) {
                    return BooleanArrayExpansionKernel.INSTANCE;
                }
                if (componentType == Boolean.class) {
                    return BoxedBooleanArrayExpansionKernel.INSTANCE;
                }
                return ByteArrayExpansionKernel.INSTANCE;
            }
            case Short: {
                return ShortArrayExpansionKernel.INSTANCE;
            }
            case Int: {
                return IntArrayExpansionKernel.INSTANCE;
            }
            case Long: {
                return LongArrayExpansionKernel.INSTANCE;
            }
            case Float: {
                return FloatArrayExpansionKernel.INSTANCE;
            }
            case Double: {
                return DoubleArrayExpansionKernel.INSTANCE;
            }
        }
        return new ObjectArrayExpansionKernel(componentType);
    }

    public <T, A extends Any> WritableChunk<A> expand(ObjectChunk<T, A> var1, WritableIntChunk<ChunkPositions> var2);

    public <T, A extends Any> WritableObjectChunk<T, A> contract(Chunk<A> var1, IntChunk<ChunkPositions> var2, WritableChunk<A> var3, int var4, int var5);
}

