/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage.chunk.array;

import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableByteChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableIntChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.attributes.ChunkPositions;
import io.deephaven.extensions.barrage.chunk.array.ArrayExpansionKernel;
import io.deephaven.util.datastructures.LongSizedDataStructure;

public class BooleanArrayExpansionKernel
implements ArrayExpansionKernel {
    private static final boolean[] ZERO_LEN_ARRAY = new boolean[0];
    public static final BooleanArrayExpansionKernel INSTANCE = new BooleanArrayExpansionKernel();

    @Override
    public <T, A extends Any> WritableChunk<A> expand(ObjectChunk<T, A> source, WritableIntChunk<ChunkPositions> perElementLengthDest) {
        if (source.size() == 0) {
            perElementLengthDest.setSize(0);
            return WritableByteChunk.makeWritableChunk((int)0);
        }
        ObjectChunk typedSource = source.asObjectChunk();
        long totalSize = 0L;
        for (int i = 0; i < typedSource.size(); ++i) {
            boolean[] row = (boolean[])typedSource.get(i);
            totalSize += row == null ? 0L : (long)row.length;
        }
        WritableByteChunk result = WritableByteChunk.makeWritableChunk((int)LongSizedDataStructure.intSize((String)"ExpansionKernel", (long)totalSize));
        int lenWritten = 0;
        perElementLengthDest.setSize(source.size() + 1);
        for (int i = 0; i < typedSource.size(); ++i) {
            boolean[] row = (boolean[])typedSource.get(i);
            perElementLengthDest.set(i, lenWritten);
            if (row == null) continue;
            for (int j = 0; j < row.length; ++j) {
                byte value = row[j] ? (byte)1 : 0;
                result.set(lenWritten + j, value);
            }
            lenWritten += row.length;
        }
        perElementLengthDest.set(typedSource.size(), lenWritten);
        return result;
    }

    @Override
    public <T, A extends Any> WritableObjectChunk<T, A> contract(Chunk<A> source, IntChunk<ChunkPositions> perElementLengthDest, WritableChunk<A> outChunk, int outOffset, int totalRows) {
        WritableObjectChunk result;
        if (perElementLengthDest.size() == 0) {
            if (outChunk != null) {
                return outChunk.asWritableObjectChunk();
            }
            return WritableObjectChunk.makeWritableChunk((int)totalRows);
        }
        int itemsInBatch = perElementLengthDest.size() - 1;
        ByteChunk typedSource = source.asByteChunk();
        if (outChunk != null) {
            result = outChunk.asWritableObjectChunk();
        } else {
            int numRows = Math.max(itemsInBatch, totalRows);
            result = WritableObjectChunk.makeWritableChunk((int)numRows);
            result.setSize(numRows);
        }
        int lenRead = 0;
        for (int i = 0; i < itemsInBatch; ++i) {
            int rowLen = perElementLengthDest.get(i + 1) - perElementLengthDest.get(i);
            if (rowLen == 0) {
                result.set(outOffset + i, (Object)ZERO_LEN_ARRAY);
                continue;
            }
            boolean[] row = new boolean[rowLen];
            for (int j = 0; j < rowLen; ++j) {
                row[j] = typedSource.get(lenRead + j) > 0;
            }
            lenRead += rowLen;
            result.set(outOffset + i, (Object)row);
        }
        return result;
    }
}

