/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage.chunk.array;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.FloatChunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableFloatChunk;
import io.deephaven.chunk.WritableIntChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.attributes.ChunkPositions;
import io.deephaven.extensions.barrage.chunk.array.ArrayExpansionKernel;
import io.deephaven.util.datastructures.LongSizedDataStructure;

public class FloatArrayExpansionKernel
implements ArrayExpansionKernel {
    private static final float[] ZERO_LEN_ARRAY = new float[0];
    public static final FloatArrayExpansionKernel INSTANCE = new FloatArrayExpansionKernel();

    @Override
    public <T, A extends Any> WritableChunk<A> expand(ObjectChunk<T, A> source, WritableIntChunk<ChunkPositions> perElementLengthDest) {
        if (source.size() == 0) {
            perElementLengthDest.setSize(0);
            return WritableFloatChunk.makeWritableChunk((int)0);
        }
        ObjectChunk typedSource = source.asObjectChunk();
        long totalSize = 0L;
        for (int i = 0; i < typedSource.size(); ++i) {
            float[] row = (float[])typedSource.get(i);
            totalSize += row == null ? 0L : (long)row.length;
        }
        WritableFloatChunk result = WritableFloatChunk.makeWritableChunk((int)LongSizedDataStructure.intSize((String)"ExpansionKernel", (long)totalSize));
        int lenWritten = 0;
        perElementLengthDest.setSize(source.size() + 1);
        for (int i = 0; i < typedSource.size(); ++i) {
            float[] row = (float[])typedSource.get(i);
            perElementLengthDest.set(i, lenWritten);
            if (row == null) continue;
            result.copyFromArray((Object)row, 0, lenWritten, row.length);
            lenWritten += row.length;
        }
        perElementLengthDest.set(typedSource.size(), lenWritten);
        return result;
    }

    @Override
    public <T, A extends Any> WritableObjectChunk<T, A> contract(Chunk<A> source, IntChunk<ChunkPositions> perElementLengthDest, WritableChunk<A> outChunk, int outOffset, int totalRows) {
        WritableObjectChunk result;
        if (perElementLengthDest.size() == 0) {
            if (outChunk != null) {
                return outChunk.asWritableObjectChunk();
            }
            return WritableObjectChunk.makeWritableChunk((int)totalRows);
        }
        int itemsInBatch = perElementLengthDest.size() - 1;
        FloatChunk typedSource = source.asFloatChunk();
        if (outChunk != null) {
            result = outChunk.asWritableObjectChunk();
        } else {
            int numRows = Math.max(itemsInBatch, totalRows);
            result = WritableObjectChunk.makeWritableChunk((int)numRows);
            result.setSize(numRows);
        }
        int lenRead = 0;
        for (int i = 0; i < itemsInBatch; ++i) {
            int rowLen = perElementLengthDest.get(i + 1) - perElementLengthDest.get(i);
            if (rowLen == 0) {
                result.set(outOffset + i, (Object)ZERO_LEN_ARRAY);
                continue;
            }
            float[] row = new float[rowLen];
            typedSource.copyToArray(lenRead, (Object)row, 0, rowLen);
            lenRead += rowLen;
            result.set(outOffset + i, (Object)row);
        }
        return result;
    }
}

