/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage.chunk.vector;

import io.deephaven.chunk.CharChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableCharChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableIntChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.attributes.ChunkPositions;
import io.deephaven.engine.primitive.function.CharConsumer;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfChar;
import io.deephaven.extensions.barrage.chunk.vector.VectorExpansionKernel;
import io.deephaven.util.datastructures.LongSizedDataStructure;
import io.deephaven.vector.CharVector;
import io.deephaven.vector.CharVectorDirect;
import io.deephaven.vector.Vector;

public class CharVectorExpansionKernel
implements VectorExpansionKernel {
    public static final CharVectorExpansionKernel INSTANCE = new CharVectorExpansionKernel();

    @Override
    public <A extends Any> WritableChunk<A> expand(ObjectChunk<Vector<?>, A> source, WritableIntChunk<ChunkPositions> perElementLengthDest) {
        if (source.size() == 0) {
            perElementLengthDest.setSize(0);
            return WritableCharChunk.makeWritableChunk((int)0);
        }
        ObjectChunk typedSource = source.asObjectChunk();
        long totalSize = 0L;
        for (int i = 0; i < typedSource.size(); ++i) {
            CharVector row = (CharVector)typedSource.get(i);
            totalSize += row == null ? 0L : row.size();
        }
        WritableCharChunk result = WritableCharChunk.makeWritableChunk((int)LongSizedDataStructure.intSize((String)"ExpansionKernel", (long)totalSize));
        result.setSize(0);
        perElementLengthDest.setSize(source.size() + 1);
        for (int i = 0; i < typedSource.size(); ++i) {
            CharVector row = (CharVector)typedSource.get(i);
            perElementLengthDest.set(i, result.size());
            if (row == null) continue;
            CharConsumer consumer = arg_0 -> ((WritableCharChunk)result).add(arg_0);
            try (CloseablePrimitiveIteratorOfChar iter = row.iterator();){
                iter.forEachRemaining(consumer);
                continue;
            }
        }
        perElementLengthDest.set(typedSource.size(), result.size());
        return result;
    }

    @Override
    public <A extends Any> WritableObjectChunk<Vector<?>, A> contract(Chunk<A> source, IntChunk<ChunkPositions> perElementLengthDest, WritableChunk<A> outChunk, int outOffset, int totalRows) {
        WritableObjectChunk result;
        if (perElementLengthDest.size() == 0) {
            if (outChunk != null) {
                return outChunk.asWritableObjectChunk();
            }
            return WritableObjectChunk.makeWritableChunk((int)totalRows);
        }
        int itemsInBatch = perElementLengthDest.size() - 1;
        CharChunk typedSource = source.asCharChunk();
        if (outChunk != null) {
            result = outChunk.asWritableObjectChunk();
        } else {
            int numRows = Math.max(itemsInBatch, totalRows);
            result = WritableObjectChunk.makeWritableChunk((int)numRows);
            result.setSize(numRows);
        }
        int lenRead = 0;
        for (int i = 0; i < itemsInBatch; ++i) {
            int rowLen = perElementLengthDest.get(i + 1) - perElementLengthDest.get(i);
            if (rowLen == 0) {
                result.set(outOffset + i, (Object)CharVectorDirect.ZERO_LENGTH_VECTOR);
                continue;
            }
            char[] row = new char[rowLen];
            typedSource.copyToArray(lenRead, (Object)row, 0, rowLen);
            lenRead += rowLen;
            result.set(outOffset + i, (Object)new CharVectorDirect(row));
        }
        return result;
    }
}

