/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage.chunk.vector;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableDoubleChunk;
import io.deephaven.chunk.WritableIntChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.attributes.ChunkPositions;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfDouble;
import io.deephaven.extensions.barrage.chunk.vector.VectorExpansionKernel;
import io.deephaven.util.datastructures.LongSizedDataStructure;
import io.deephaven.vector.DoubleVector;
import io.deephaven.vector.DoubleVectorDirect;
import io.deephaven.vector.Vector;
import java.util.function.DoubleConsumer;

public class DoubleVectorExpansionKernel
implements VectorExpansionKernel {
    public static final DoubleVectorExpansionKernel INSTANCE = new DoubleVectorExpansionKernel();

    @Override
    public <A extends Any> WritableChunk<A> expand(ObjectChunk<Vector<?>, A> source, WritableIntChunk<ChunkPositions> perElementLengthDest) {
        if (source.size() == 0) {
            perElementLengthDest.setSize(0);
            return WritableDoubleChunk.makeWritableChunk((int)0);
        }
        ObjectChunk typedSource = source.asObjectChunk();
        long totalSize = 0L;
        for (int i = 0; i < typedSource.size(); ++i) {
            DoubleVector row = (DoubleVector)typedSource.get(i);
            totalSize += row == null ? 0L : row.size();
        }
        WritableDoubleChunk result = WritableDoubleChunk.makeWritableChunk((int)LongSizedDataStructure.intSize((String)"ExpansionKernel", (long)totalSize));
        result.setSize(0);
        perElementLengthDest.setSize(source.size() + 1);
        for (int i = 0; i < typedSource.size(); ++i) {
            DoubleVector row = (DoubleVector)typedSource.get(i);
            perElementLengthDest.set(i, result.size());
            if (row == null) continue;
            DoubleConsumer consumer = arg_0 -> ((WritableDoubleChunk)result).add(arg_0);
            try (CloseablePrimitiveIteratorOfDouble iter = row.iterator();){
                iter.forEachRemaining(consumer);
                continue;
            }
        }
        perElementLengthDest.set(typedSource.size(), result.size());
        return result;
    }

    @Override
    public <A extends Any> WritableObjectChunk<Vector<?>, A> contract(Chunk<A> source, IntChunk<ChunkPositions> perElementLengthDest, WritableChunk<A> outChunk, int outOffset, int totalRows) {
        WritableObjectChunk result;
        if (perElementLengthDest.size() == 0) {
            if (outChunk != null) {
                return outChunk.asWritableObjectChunk();
            }
            return WritableObjectChunk.makeWritableChunk((int)totalRows);
        }
        int itemsInBatch = perElementLengthDest.size() - 1;
        DoubleChunk typedSource = source.asDoubleChunk();
        if (outChunk != null) {
            result = outChunk.asWritableObjectChunk();
        } else {
            int numRows = Math.max(itemsInBatch, totalRows);
            result = WritableObjectChunk.makeWritableChunk((int)numRows);
            result.setSize(numRows);
        }
        int lenRead = 0;
        for (int i = 0; i < itemsInBatch; ++i) {
            int rowLen = perElementLengthDest.get(i + 1) - perElementLengthDest.get(i);
            if (rowLen == 0) {
                result.set(outOffset + i, (Object)DoubleVectorDirect.ZERO_LENGTH_VECTOR);
                continue;
            }
            double[] row = new double[rowLen];
            typedSource.copyToArray(lenRead, (Object)row, 0, rowLen);
            lenRead += rowLen;
            result.set(outOffset + i, (Object)new DoubleVectorDirect(row));
        }
        return result;
    }
}

