/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage.chunk.vector;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableIntChunk;
import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.attributes.ChunkPositions;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfLong;
import io.deephaven.extensions.barrage.chunk.vector.VectorExpansionKernel;
import io.deephaven.util.datastructures.LongSizedDataStructure;
import io.deephaven.vector.LongVector;
import io.deephaven.vector.LongVectorDirect;
import io.deephaven.vector.Vector;
import java.util.function.LongConsumer;

public class LongVectorExpansionKernel
implements VectorExpansionKernel {
    public static final LongVectorExpansionKernel INSTANCE = new LongVectorExpansionKernel();

    @Override
    public <A extends Any> WritableChunk<A> expand(ObjectChunk<Vector<?>, A> source, WritableIntChunk<ChunkPositions> perElementLengthDest) {
        if (source.size() == 0) {
            perElementLengthDest.setSize(0);
            return WritableLongChunk.makeWritableChunk((int)0);
        }
        ObjectChunk typedSource = source.asObjectChunk();
        long totalSize = 0L;
        for (int i = 0; i < typedSource.size(); ++i) {
            LongVector row = (LongVector)typedSource.get(i);
            totalSize += row == null ? 0L : row.size();
        }
        WritableLongChunk result = WritableLongChunk.makeWritableChunk((int)LongSizedDataStructure.intSize((String)"ExpansionKernel", (long)totalSize));
        result.setSize(0);
        perElementLengthDest.setSize(source.size() + 1);
        for (int i = 0; i < typedSource.size(); ++i) {
            LongVector row = (LongVector)typedSource.get(i);
            perElementLengthDest.set(i, result.size());
            if (row == null) continue;
            LongConsumer consumer = arg_0 -> ((WritableLongChunk)result).add(arg_0);
            try (CloseablePrimitiveIteratorOfLong iter = row.iterator();){
                iter.forEachRemaining(consumer);
                continue;
            }
        }
        perElementLengthDest.set(typedSource.size(), result.size());
        return result;
    }

    @Override
    public <A extends Any> WritableObjectChunk<Vector<?>, A> contract(Chunk<A> source, IntChunk<ChunkPositions> perElementLengthDest, WritableChunk<A> outChunk, int outOffset, int totalRows) {
        WritableObjectChunk result;
        if (perElementLengthDest.size() == 0) {
            if (outChunk != null) {
                return outChunk.asWritableObjectChunk();
            }
            return WritableObjectChunk.makeWritableChunk((int)totalRows);
        }
        int itemsInBatch = perElementLengthDest.size() - 1;
        LongChunk typedSource = source.asLongChunk();
        if (outChunk != null) {
            result = outChunk.asWritableObjectChunk();
        } else {
            int numRows = Math.max(itemsInBatch, totalRows);
            result = WritableObjectChunk.makeWritableChunk((int)numRows);
            result.setSize(numRows);
        }
        int lenRead = 0;
        for (int i = 0; i < itemsInBatch; ++i) {
            int rowLen = perElementLengthDest.get(i + 1) - perElementLengthDest.get(i);
            if (rowLen == 0) {
                result.set(outOffset + i, (Object)LongVectorDirect.ZERO_LENGTH_VECTOR);
                continue;
            }
            long[] row = new long[rowLen];
            typedSource.copyToArray(lenRead, (Object)row, 0, rowLen);
            lenRead += rowLen;
            result.set(outOffset + i, (Object)new LongVectorDirect(row));
        }
        return result;
    }
}

