/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage.chunk.vector;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableIntChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.attributes.ChunkPositions;
import io.deephaven.engine.primitive.iterator.CloseableIterator;
import io.deephaven.extensions.barrage.chunk.vector.VectorExpansionKernel;
import io.deephaven.util.datastructures.LongSizedDataStructure;
import io.deephaven.vector.ObjectVector;
import io.deephaven.vector.ObjectVectorDirect;
import io.deephaven.vector.Vector;
import java.lang.reflect.Array;

public class ObjectVectorExpansionKernel<T>
implements VectorExpansionKernel {
    private final Class<T> componentType;

    public ObjectVectorExpansionKernel(Class<T> componentType) {
        this.componentType = componentType;
    }

    @Override
    public <A extends Any> WritableChunk<A> expand(ObjectChunk<Vector<?>, A> source, WritableIntChunk<ChunkPositions> perElementLengthDest) {
        if (source.size() == 0) {
            perElementLengthDest.setSize(0);
            return WritableObjectChunk.makeWritableChunk((int)0);
        }
        ObjectChunk typedSource = source.asObjectChunk();
        long totalSize = 0L;
        for (int i = 0; i < typedSource.size(); ++i) {
            ObjectVector row = (ObjectVector)typedSource.get(i);
            totalSize += row == null ? 0L : row.size();
        }
        WritableObjectChunk result = WritableObjectChunk.makeWritableChunk((int)LongSizedDataStructure.intSize((String)"ExpansionKernel", (long)totalSize));
        result.setSize(0);
        perElementLengthDest.setSize(source.size() + 1);
        for (int i = 0; i < typedSource.size(); ++i) {
            ObjectVector row = (ObjectVector)typedSource.get(i);
            perElementLengthDest.set(i, result.size());
            if (row == null) continue;
            try (CloseableIterator iter = row.iterator();){
                iter.forEachRemaining(v -> result.add(v));
                continue;
            }
        }
        perElementLengthDest.set(typedSource.size(), result.size());
        return result;
    }

    @Override
    public <A extends Any> WritableObjectChunk<Vector<?>, A> contract(Chunk<A> source, IntChunk<ChunkPositions> perElementLengthDest, WritableChunk<A> outChunk, int outOffset, int totalRows) {
        WritableObjectChunk result;
        if (perElementLengthDest.size() == 0) {
            if (outChunk != null) {
                return outChunk.asWritableObjectChunk();
            }
            return WritableObjectChunk.makeWritableChunk((int)totalRows);
        }
        int itemsInBatch = perElementLengthDest.size() - 1;
        ObjectChunk typedSource = source.asObjectChunk();
        if (outChunk != null) {
            result = outChunk.asWritableObjectChunk();
        } else {
            int numRows = Math.max(itemsInBatch, totalRows);
            result = WritableObjectChunk.makeWritableChunk((int)numRows);
            result.setSize(numRows);
        }
        int lenRead = 0;
        for (int i = 0; i < itemsInBatch; ++i) {
            int rowLen = perElementLengthDest.get(i + 1) - perElementLengthDest.get(i);
            if (rowLen == 0) {
                result.set(outOffset + i, (Object)ObjectVectorDirect.ZERO_LENGTH_VECTOR);
                continue;
            }
            Object[] row = (Object[])Array.newInstance(this.componentType, rowLen);
            typedSource.copyToArray(lenRead, (Object)row, 0, rowLen);
            lenRead += rowLen;
            result.set(outOffset + i, (Object)new ObjectVectorDirect(row));
        }
        return result;
    }
}

