/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage.chunk.vector;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableIntChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.attributes.ChunkPositions;
import io.deephaven.extensions.barrage.chunk.vector.ByteVectorExpansionKernel;
import io.deephaven.extensions.barrage.chunk.vector.CharVectorExpansionKernel;
import io.deephaven.extensions.barrage.chunk.vector.DoubleVectorExpansionKernel;
import io.deephaven.extensions.barrage.chunk.vector.FloatVectorExpansionKernel;
import io.deephaven.extensions.barrage.chunk.vector.IntVectorExpansionKernel;
import io.deephaven.extensions.barrage.chunk.vector.LongVectorExpansionKernel;
import io.deephaven.extensions.barrage.chunk.vector.ObjectVectorExpansionKernel;
import io.deephaven.extensions.barrage.chunk.vector.ShortVectorExpansionKernel;
import io.deephaven.vector.ByteVector;
import io.deephaven.vector.CharVector;
import io.deephaven.vector.DoubleVector;
import io.deephaven.vector.FloatVector;
import io.deephaven.vector.IntVector;
import io.deephaven.vector.LongVector;
import io.deephaven.vector.ObjectVector;
import io.deephaven.vector.ShortVector;
import io.deephaven.vector.Vector;

public interface VectorExpansionKernel {
    public static Class<?> getComponentType(Class<?> type, Class<?> componentType) {
        if (ByteVector.class.isAssignableFrom(type)) {
            return Byte.TYPE;
        }
        if (CharVector.class.isAssignableFrom(type)) {
            return Character.TYPE;
        }
        if (DoubleVector.class.isAssignableFrom(type)) {
            return Double.TYPE;
        }
        if (FloatVector.class.isAssignableFrom(type)) {
            return Float.TYPE;
        }
        if (IntVector.class.isAssignableFrom(type)) {
            return Integer.TYPE;
        }
        if (LongVector.class.isAssignableFrom(type)) {
            return Long.TYPE;
        }
        if (ShortVector.class.isAssignableFrom(type)) {
            return Short.TYPE;
        }
        if (ObjectVector.class.isAssignableFrom(type)) {
            return componentType != null ? componentType : Object.class;
        }
        throw new IllegalStateException("Unexpected vector type: " + type.getCanonicalName());
    }

    public static <T> VectorExpansionKernel makeExpansionKernel(ChunkType chunkType, Class<T> componentType) {
        switch (chunkType) {
            case Char: {
                return CharVectorExpansionKernel.INSTANCE;
            }
            case Byte: {
                return ByteVectorExpansionKernel.INSTANCE;
            }
            case Short: {
                return ShortVectorExpansionKernel.INSTANCE;
            }
            case Int: {
                return IntVectorExpansionKernel.INSTANCE;
            }
            case Long: {
                return LongVectorExpansionKernel.INSTANCE;
            }
            case Float: {
                return FloatVectorExpansionKernel.INSTANCE;
            }
            case Double: {
                return DoubleVectorExpansionKernel.INSTANCE;
            }
        }
        return new ObjectVectorExpansionKernel<T>(componentType);
    }

    public <A extends Any> WritableChunk<A> expand(ObjectChunk<Vector<?>, A> var1, WritableIntChunk<ChunkPositions> var2);

    public <A extends Any> WritableObjectChunk<Vector<?>, A> contract(Chunk<A> var1, IntChunk<ChunkPositions> var2, WritableChunk<A> var3, int var4, int var5);
}

