/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage.table;

import io.deephaven.base.log.LogOutputAppendable;
import io.deephaven.base.verify.Assert;
import io.deephaven.chunk.Chunk;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.rowset.RowSetShiftData;
import io.deephaven.engine.rowset.TrackingWritableRowSet;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.engine.table.ChunkSink;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.ModifiedColumnSet;
import io.deephaven.engine.table.TableUpdate;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.TableUpdateImpl;
import io.deephaven.engine.table.impl.util.BarrageMessage;
import io.deephaven.engine.updategraph.NotificationQueue;
import io.deephaven.engine.updategraph.UpdateSourceRegistrar;
import io.deephaven.extensions.barrage.table.BarrageTable;
import io.deephaven.io.log.LogLevel;
import java.util.ArrayDeque;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.jetbrains.annotations.Nullable;

public class BarrageBlinkTable
extends BarrageTable {
    private long numRowsLastRefresh = 0L;

    protected BarrageBlinkTable(UpdateSourceRegistrar registrar, NotificationQueue notificationQueue, @Nullable ScheduledExecutorService executorService, LinkedHashMap<String, ColumnSource<?>> columns, WritableColumnSource<?>[] writableSources, Map<String, Object> attributes, @Nullable BarrageTable.ViewportChangedCallback vpCallback) {
        super(registrar, notificationQueue, executorService, columns, writableSources, attributes, vpCallback);
        this.setFlat();
    }

    private void processUpdate(BarrageMessage update) {
        if (DEBUG_ENABLED) {
            this.saveForDebugging(update);
            BarrageMessage.ModColumnData[] mods = RowSetFactory.empty();
            TableUpdateImpl up = new TableUpdateImpl(update.rowsAdded, update.rowsRemoved, (RowSet)mods, update.shifted, ModifiedColumnSet.EMPTY);
            this.beginLog(LogLevel.INFO).append((CharSequence)": Processing delta updates ").append(update.firstSeq).append((CharSequence)"-").append(update.lastSeq).append((CharSequence)" update=").append((LogOutputAppendable)up).append((CharSequence)" included=").append((LogOutputAppendable)update.rowsIncluded).append((CharSequence)" rowset=").append((LogOutputAppendable)this.getRowSet()).append((CharSequence)" isSnapshot=").append(update.isSnapshot).append((CharSequence)" snapshotRowSet=").append((LogOutputAppendable)update.snapshotRowSet).append((CharSequence)" snapshotRowSetIsReversed=").append(update.snapshotRowSetIsReversed).endl();
            mods.close();
        }
        if (update.isSnapshot) {
            this.updateServerViewport(update.snapshotRowSet, update.snapshotColumns, update.snapshotRowSetIsReversed);
        }
        if (update.shifted.nonempty()) {
            throw new IllegalStateException("Barrage blink table cannot shift rows");
        }
        for (BarrageMessage.ModColumnData mcd : update.modColumnData) {
            if (!mcd.rowsModified.isNonempty()) continue;
            throw new IllegalStateException("Barrage blink table cannot modify rows");
        }
        if (update.rowsIncluded.isEmpty()) {
            return;
        }
        int addBatchSize = (int)Math.min(update.rowsIncluded.size(), 65536L);
        WritableRowSet destinationRowSet = RowSetFactory.fromRange((long)this.numRowsLastRefresh, (long)(this.numRowsLastRefresh + update.rowsIncluded.size() - 1L));
        this.numRowsLastRefresh += update.rowsIncluded.size();
        this.ensureCapacity(this.numRowsLastRefresh);
        for (int ii = 0; ii < update.addColumnData.length; ++ii) {
            if (!this.isSubscribedColumn(ii)) continue;
            BarrageMessage.AddColumnData column = update.addColumnData[ii];
            try (ChunkSink.FillFromContext fillContext = this.destSources[ii].makeFillFromContext(addBatchSize);
                 RowSequence.Iterator destIterator = destinationRowSet.getRowSequenceIterator();){
                for (Chunk chunk : column.data) {
                    int effectiveBatchSize;
                    for (int chunkOffset = 0; chunkOffset < chunk.size(); chunkOffset += effectiveBatchSize) {
                        effectiveBatchSize = Math.min(addBatchSize, chunk.size() - chunkOffset);
                        RowSequence chunkKeys = destIterator.getNextRowSequenceWithLength((long)effectiveBatchSize);
                        Chunk slicedChunk = chunk.slice(chunkOffset, effectiveBatchSize);
                        this.destSources[ii].fillFromChunk(fillContext, slicedChunk, chunkKeys);
                    }
                }
                Assert.assertion((!destIterator.hasMore() ? 1 : 0) != 0, (String)"not all rowsIncluded were processed");
                continue;
            }
        }
    }

    private void ensureCapacity(long size) {
        if (this.capacity < size) {
            this.capacity = Long.highestOneBit(Math.max(size * 2L, 8L));
            for (WritableColumnSource source : this.destSources) {
                source.ensureCapacity(this.capacity);
            }
        }
    }

    @Override
    protected TableUpdate applyUpdates(ArrayDeque<BarrageMessage> localPendingUpdates) {
        WritableRowSet removed = RowSetFactory.flat((long)this.numRowsLastRefresh);
        this.numRowsLastRefresh = 0L;
        for (BarrageMessage update : localPendingUpdates) {
            long startTm = System.nanoTime();
            this.processUpdate(update);
            update.close();
            this.recordMetric(stats -> stats.processUpdate, System.nanoTime() - startTm);
        }
        if (this.numRowsLastRefresh > 0L) {
            this.doWakeup();
        }
        if (removed.isNonempty() || this.numRowsLastRefresh > 0L) {
            TrackingWritableRowSet rowSet = this.getRowSet().writableCast();
            if (this.numRowsLastRefresh > removed.size()) {
                rowSet.insertRange(0L, this.numRowsLastRefresh - 1L);
            } else {
                rowSet.removeRange(this.numRowsLastRefresh, removed.size() - 1L);
            }
            return new TableUpdateImpl((RowSet)RowSetFactory.flat((long)this.numRowsLastRefresh), (RowSet)removed, (RowSet)RowSetFactory.empty(), RowSetShiftData.EMPTY, ModifiedColumnSet.EMPTY);
        }
        return null;
    }
}

