/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage.table;

import io.deephaven.base.log.LogOutputAppendable;
import io.deephaven.base.verify.Assert;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TableUpdate;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.TableUpdateImpl;
import io.deephaven.engine.table.impl.util.BarrageMessage;
import io.deephaven.engine.table.impl.util.UpdateCoalescer;
import io.deephaven.engine.table.impl.util.WritableRowRedirection;
import io.deephaven.engine.updategraph.NotificationQueue;
import io.deephaven.engine.updategraph.UpdateSourceRegistrar;
import io.deephaven.extensions.barrage.table.BarrageTable;
import io.deephaven.io.log.LogLevel;
import java.util.ArrayDeque;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.jetbrains.annotations.Nullable;

public class BarrageRedirectedTable
extends BarrageTable {
    private final WritableRowRedirection rowRedirection;
    private WritableRowSet freeset = RowSetFactory.empty();

    protected BarrageRedirectedTable(UpdateSourceRegistrar registrar, NotificationQueue notificationQueue, @Nullable ScheduledExecutorService executorService, LinkedHashMap<String, ColumnSource<?>> columns, WritableColumnSource<?>[] writableSources, WritableRowRedirection rowRedirection, Map<String, Object> attributes, boolean isFlat, @Nullable BarrageTable.ViewportChangedCallback vpCallback) {
        super(registrar, notificationQueue, executorService, columns, writableSources, attributes, vpCallback);
        this.rowRedirection = rowRedirection;
        if (isFlat) {
            this.setFlat();
        }
    }

    /*
     * Unable to fully structure code
     */
    private UpdateCoalescer processUpdate(BarrageMessage update, UpdateCoalescer coalescer) {
        if (BarrageRedirectedTable.DEBUG_ENABLED) {
            this.saveForDebugging(update);
            modifiedColumnSet = this.getModifiedColumnSetForUpdates();
            modifiedColumnSet.clear();
            mods = RowSetFactory.empty();
            for (ci = 0; ci < update.modColumnData.length; ++ci) {
                rowsModified = update.modColumnData[ci].rowsModified;
                if (!rowsModified.isNonempty()) continue;
                mods.insert(rowsModified);
                modifiedColumnSet.setColumnWithIndex(ci);
            }
            up = new TableUpdateImpl(update.rowsAdded, update.rowsRemoved, (RowSet)mods, update.shifted, modifiedColumnSet);
            this.beginLog(LogLevel.INFO).append((CharSequence)": Processing delta updates ").append(update.firstSeq).append((CharSequence)"-").append(update.lastSeq).append((CharSequence)" update=").append((LogOutputAppendable)up).append((CharSequence)" included=").append((LogOutputAppendable)update.rowsIncluded).append((CharSequence)" rowset=").append((LogOutputAppendable)this.getRowSet()).append((CharSequence)" isSnapshot=").append(update.isSnapshot).append((CharSequence)" snapshotRowSet=").append((LogOutputAppendable)update.snapshotRowSet).append((CharSequence)" snapshotRowSetIsReversed=").append(update.snapshotRowSetIsReversed).endl();
            mods.close();
        }
        if (update.isSnapshot) {
            this.updateServerViewport(update.snapshotRowSet, update.snapshotColumns, update.snapshotRowSetIsReversed);
        }
        mightBeInitialSnapshot = (currentRowSet = this.getRowSet().writableCast()).isEmpty() != false && update.isSnapshot != false;
        serverViewport = this.getServerViewport();
        serverReverseViewport = this.getServerReverseViewport();
        currRowsFromPrev = currentRowSet.copy();
        try {
            block100: {
                block98: {
                    block99: {
                        populatedRows = serverViewport != null ? currentRowSet.subSetForPositions((RowSequence)serverViewport, serverReverseViewport) : null;
                        try {
                            block101: {
                                currentRowSet.remove(update.rowsRemoved);
                                removed = serverViewport != null ? populatedRows.extract(update.rowsRemoved) : null;
                                try {
                                    this.freeRows((RowSet)(removed != null ? removed : update.rowsRemoved));
                                }
                                finally {
                                    if (removed != null) {
                                        removed.close();
                                    }
                                }
                                if (update.shifted.nonempty()) {
                                    this.rowRedirection.applyShift((RowSet)currentRowSet, update.shifted);
                                    update.shifted.apply((WritableRowSet)currentRowSet);
                                    if (populatedRows != null) {
                                        update.shifted.apply(populatedRows);
                                    }
                                }
                                currentRowSet.insert(update.rowsAdded);
                                totalMods = RowSetFactory.empty();
                                for (i = 0; i < update.modColumnData.length; ++i) {
                                    column = update.modColumnData[i];
                                    totalMods.insert(column.rowsModified);
                                }
                                if (!update.rowsIncluded.isNonempty()) break block101;
                                addBatchSize = (int)Math.min(update.rowsIncluded.size(), 65536L);
                                if (mightBeInitialSnapshot) {
                                    this.capacity = update.rowsIncluded.size();
                                    for (WritableColumnSource source : this.destSources) {
                                        source.ensureCapacity(this.capacity);
                                    }
                                    this.freeset.insertRange(0L, this.capacity - 1L);
                                }
                                destinationRowSet = RowSetFactory.empty();
                                rowsIncludedIterator = update.rowsIncluded.getRowSequenceIterator();
                                try {
                                    redirContext = this.rowRedirection.makeFillFromContext(addBatchSize);
lbl59:
                                    // 2 sources

                                    try {
                                        while (rowsIncludedIterator.hasMore()) {
                                            rowsToRedirect = rowsIncludedIterator.getNextRowSequenceWithLength((long)addBatchSize);
                                            newRows = this.getFreeRows(rowsToRedirect.intSize());
                                            try {
                                                this.rowRedirection.fillFromChunk(redirContext, (Chunk)newRows.asRowKeyChunk(), rowsToRedirect);
                                                destinationRowSet.insert(newRows);
                                            }
                                            finally {
                                                if (newRows == null) ** GOTO lbl59
                                                newRows.close();
                                            }
                                        }
                                    }
                                    finally {
                                        if (redirContext != null) {
                                            redirContext.close();
                                        }
                                    }
                                }
                                finally {
                                    if (rowsIncludedIterator != null) {
                                        rowsIncludedIterator.close();
                                    }
                                }
                                for (ii = 0; ii < update.addColumnData.length; ++ii) {
                                    if (!this.isSubscribedColumn(ii)) continue;
                                    column = update.addColumnData[ii];
                                    fillContext = this.destSources[ii].makeFillFromContext(addBatchSize);
                                    try {
                                        destIterator = destinationRowSet.getRowSequenceIterator();
                                        try {
                                            for (Chunk chunk : column.data) {
                                                for (chunkOffset = 0; chunkOffset < chunk.size(); chunkOffset += effectiveBatchSize) {
                                                    effectiveBatchSize = Math.min(addBatchSize, chunk.size() - chunkOffset);
                                                    chunkKeys = destIterator.getNextRowSequenceWithLength((long)effectiveBatchSize);
                                                    slicedChunk = chunk.slice(chunkOffset, effectiveBatchSize);
                                                    this.destSources[ii].fillFromChunk(fillContext, slicedChunk, chunkKeys);
                                                }
                                            }
                                            Assert.assertion((boolean)(destIterator.hasMore() == false), (String)"not all rowsIncluded were processed");
                                            continue;
                                        }
                                        finally {
                                            if (destIterator != null) {
                                                destIterator.close();
                                            }
                                        }
                                    }
                                    finally {
                                        if (fillContext != null) {
                                            fillContext.close();
                                        }
                                    }
                                }
                            }
                            modifiedColumnSet = this.getModifiedColumnSetForUpdates();
                            modifiedColumnSet.clear();
                            for (ii = 0; ii < update.modColumnData.length; ++ii) {
                                column = update.modColumnData[ii];
                                if (column.rowsModified.isEmpty()) continue;
                                modBatchSize = (int)Math.min(column.rowsModified.size(), 65536L);
                                modifiedColumnSet.setColumnWithIndex(ii);
                                redirContext = this.rowRedirection.makeFillContext(modBatchSize, null);
                                try {
                                    fillContext = this.destSources[ii].makeFillFromContext(modBatchSize);
                                    try {
                                        keys = WritableLongChunk.makeWritableChunk((int)modBatchSize);
                                        try {
                                            destIterator = column.rowsModified.getRowSequenceIterator();
                                            try {
                                                for (Chunk chunk : column.data) {
                                                    for (chunkOffset = 0; chunkOffset < chunk.size(); chunkOffset += effectiveBatchSize) {
                                                        effectiveBatchSize = Math.min(modBatchSize, chunk.size() - chunkOffset);
                                                        chunkKeys = destIterator.getNextRowSequenceWithLength((long)effectiveBatchSize);
                                                        this.rowRedirection.fillChunk(redirContext, (WritableChunk)keys, chunkKeys);
                                                        slicedChunk = chunk.slice(chunkOffset, effectiveBatchSize);
                                                        this.destSources[ii].fillFromChunkUnordered(fillContext, slicedChunk, (LongChunk)keys);
                                                    }
                                                }
                                                Assert.assertion((boolean)(destIterator.hasMore() == false), (String)"not all rowsModified were processed");
                                                continue;
                                            }
                                            finally {
                                                if (destIterator != null) {
                                                    destIterator.close();
                                                }
                                            }
                                        }
                                        finally {
                                            if (keys != null) {
                                                keys.close();
                                            }
                                        }
                                    }
                                    finally {
                                        if (fillContext != null) {
                                            fillContext.close();
                                        }
                                    }
                                }
                                finally {
                                    if (redirContext != null) {
                                        redirContext.close();
                                    }
                                }
                            }
                            if (serverViewport != null) {
                                newPopulated = currentRowSet.subSetForPositions((RowSequence)serverViewport, serverReverseViewport);
                                try {
                                    populatedRows.remove((RowSet)newPopulated);
                                    this.freeRows((RowSet)populatedRows);
                                }
                                finally {
                                    if (newPopulated != null) {
                                        newPopulated.close();
                                    }
                                }
                            }
                            if (!update.isSnapshot || mightBeInitialSnapshot) break block98;
                            newPopulated = coalescer;
                            if (populatedRows == null) break block99;
                        }
                        catch (Throwable var9_14) {
                            if (populatedRows != null) {
                                try {
                                    populatedRows.close();
                                }
                                catch (Throwable var10_19) {
                                    var9_14.addSuppressed(var10_19);
                                }
                            }
                            throw var9_14;
                        }
                        populatedRows.close();
                    }
                    return newPopulated;
                }
                downstream = new TableUpdateImpl((RowSet)update.rowsAdded.copy(), (RowSet)update.rowsRemoved.copy(), (RowSet)totalMods, update.shifted, modifiedColumnSet);
                v0 = var12_31 = coalescer == null ? new UpdateCoalescer((RowSet)currRowsFromPrev, (TableUpdate)downstream) : coalescer.update((TableUpdate)downstream);
                if (populatedRows == null) break block100;
                populatedRows.close();
            }
            return var12_31;
        }
        finally {
            if (currRowsFromPrev != null) {
                currRowsFromPrev.close();
            }
        }
    }

    private RowSet getFreeRows(long size) {
        WritableRowSet result;
        if (size <= 0L) {
            return RowSetFactory.empty();
        }
        boolean needsResizing = false;
        if (this.capacity == 0L) {
            this.capacity = Long.highestOneBit(Math.max(size * 2L, 8L));
            this.freeset = RowSetFactory.flat((long)this.capacity);
            needsResizing = true;
        } else if (this.freeset.size() < size) {
            long usedSlots = this.capacity - this.freeset.size();
            long prevCapacity = this.capacity;
            do {
                this.capacity *= 2L;
            } while (this.capacity - usedSlots < size);
            this.freeset.insertRange(prevCapacity, this.capacity - 1L);
            needsResizing = true;
        }
        if (needsResizing) {
            for (WritableColumnSource source : this.destSources) {
                source.ensureCapacity(this.capacity);
            }
        }
        Assert.assertion(((result = this.freeset.subSetByPositionRange(0L, size)).size() == size ? 1 : 0) != 0, (String)"result.size() == size");
        this.freeset.removeRange(0L, result.lastRowKey());
        return result;
    }

    private void freeRows(RowSet rowsToFree) {
        if (rowsToFree.isEmpty()) {
            return;
        }
        int chunkSize = (int)Math.min(rowsToFree.size(), 65536L);
        try (WritableLongChunk redirectedRows = WritableLongChunk.makeWritableChunk((int)chunkSize);
             RowSequence.Iterator rowsToFreeIterator = rowsToFree.getRowSequenceIterator();){
            while (rowsToFreeIterator.hasMore()) {
                RowSequence chunkRowsToFree = rowsToFreeIterator.getNextRowSequenceWithLength((long)chunkSize);
                redirectedRows.setSize(0);
                chunkRowsToFree.forAllRowKeys(next -> {
                    long prevIndex = this.rowRedirection.remove(next);
                    Assert.assertion((prevIndex != -1L ? 1 : 0) != 0, (String)"prevIndex != -1", (Object)prevIndex, (String)"prevIndex", (Object)next, (String)"next");
                    redirectedRows.add(prevIndex);
                });
                redirectedRows.sort();
                this.freeset.insert((LongChunk)redirectedRows, 0, redirectedRows.size());
            }
        }
    }

    @Override
    protected TableUpdate applyUpdates(ArrayDeque<BarrageMessage> localPendingUpdates) {
        UpdateCoalescer coalescer = null;
        for (BarrageMessage update : localPendingUpdates) {
            long startTm = System.nanoTime();
            coalescer = this.processUpdate(update, coalescer);
            update.close();
            this.recordMetric(stats -> stats.processUpdate, System.nanoTime() - startTm);
        }
        return coalescer != null ? coalescer.coalesce() : null;
    }

    @Override
    protected boolean maybeEnablePrevTracking() {
        if (!super.maybeEnablePrevTracking()) {
            return false;
        }
        this.rowRedirection.startTrackingPrevValues();
        return true;
    }
}

