/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage.util;

import com.google.common.io.LittleEndianDataInputStream;
import com.google.common.io.LittleEndianDataOutputStream;
import com.google.protobuf.CodedInputStream;
import io.deephaven.UncheckedDeephavenException;
import io.deephaven.barrage.flatbuf.BarrageMessageWrapper;
import io.deephaven.datastructures.util.CollectionUtil;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.impl.ExternalizableRowSetUtils;
import io.deephaven.extensions.barrage.BarrageSubscriptionOptions;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.io.streams.ByteBufferInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.arrow.flatbuf.Message;
import org.apache.arrow.flight.impl.Flight;
import org.jetbrains.annotations.NotNull;

public class BarrageProtoUtil {
    public static final BarrageSubscriptionOptions DEFAULT_SER_OPTIONS = BarrageSubscriptionOptions.builder().build();
    private static final int TAG_TYPE_BITS = 3;
    public static final int BODY_TAG = 8002;
    public static final int DATA_HEADER_TAG = 18;
    public static final int APP_METADATA_TAG = 26;
    public static final int FLIGHT_DESCRIPTOR_TAG = 10;
    private static final Logger log = LoggerFactory.getLogger(BarrageProtoUtil.class);

    /*
     * Enabled aggressive exception aggregation
     */
    public static ByteBuffer toByteBuffer(RowSet rowSet) {
        try (ExposedByteArrayOutputStream baos = new ExposedByteArrayOutputStream();){
            ByteBuffer byteBuffer;
            try (LittleEndianDataOutputStream oos = new LittleEndianDataOutputStream((OutputStream)baos);){
                ExternalizableRowSetUtils.writeExternalCompressedDeltas((DataOutput)oos, (RowSet)rowSet);
                oos.flush();
                byteBuffer = ByteBuffer.wrap(baos.peekBuffer(), 0, baos.size());
            }
            return byteBuffer;
        }
        catch (IOException e) {
            throw new UncheckedDeephavenException("Unexpected exception during serialization: ", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static RowSet toRowSet(ByteBuffer string) {
        try (ByteBufferInputStream bais = new ByteBufferInputStream(string);){
            RowSet rowSet;
            try (LittleEndianDataInputStream ois = new LittleEndianDataInputStream((InputStream)bais);){
                rowSet = ExternalizableRowSetUtils.readExternalCompressedDelta((DataInput)ois);
            }
            return rowSet;
        }
        catch (IOException e) {
            throw new UncheckedDeephavenException("Unexpected exception during deserialization: ", (Throwable)e);
        }
    }

    public static MessageInfo parseProtoMessage(InputStream stream) throws IOException {
        MessageInfo mi = new MessageInfo();
        CodedInputStream decoder = CodedInputStream.newInstance((InputStream)stream);
        int tag = decoder.readTag();
        block6: while (tag != 0) {
            switch (tag) {
                case 18: {
                    int size = decoder.readRawVarint32();
                    mi.header = Message.getRootAsMessage((ByteBuffer)ByteBuffer.wrap(decoder.readRawBytes(size)));
                    break;
                }
                case 26: {
                    int size = decoder.readRawVarint32();
                    mi.app_metadata = BarrageMessageWrapper.getRootAsBarrageMessageWrapper((ByteBuffer)ByteBuffer.wrap(decoder.readRawBytes(size)));
                    if (mi.app_metadata.magic() == 1852338276L) break;
                    log.error().append((CharSequence)"received invalid magic").endl();
                    mi.app_metadata = null;
                    break;
                }
                case 10: {
                    int size = decoder.readRawVarint32();
                    byte[] bytes = decoder.readRawBytes(size);
                    mi.descriptor = Flight.FlightDescriptor.parseFrom((byte[])bytes);
                    break;
                }
                case 8002: {
                    int size = decoder.readRawVarint32();
                    mi.inputStream = new LittleEndianDataInputStream((InputStream)new ObjectInputStreamAdapter(decoder, size));
                    break block6;
                }
                default: {
                    log.info().append((CharSequence)"Skipping tag: ").append(tag).endl();
                    decoder.skipField(tag);
                }
            }
            tag = decoder.readTag();
        }
        if (mi.header != null && mi.header.headerType() == 3 && mi.inputStream == null) {
            mi.inputStream = new LittleEndianDataInputStream((InputStream)new ByteArrayInputStream(CollectionUtil.ZERO_LENGTH_BYTE_ARRAY));
        }
        return mi;
    }

    public static final class MessageInfo {
        public Message header = null;
        public BarrageMessageWrapper app_metadata = null;
        public Flight.FlightDescriptor descriptor = null;
        public LittleEndianDataInputStream inputStream = null;
    }

    public static class ObjectInputStreamAdapter
    extends InputStream {
        private int sizeRemaining;
        private final CodedInputStream stream;

        public ObjectInputStreamAdapter(CodedInputStream stream, int size) {
            if (size < 0) {
                throw new IllegalArgumentException("size cannot be negative");
            }
            this.sizeRemaining = size;
            this.stream = stream;
        }

        @Override
        public int read() throws IOException {
            if (this.sizeRemaining <= 0) {
                return -1;
            }
            --this.sizeRemaining;
            int r = this.stream.readRawByte();
            return r < 0 ? 256 + r : r;
        }

        @Override
        public int read(@NotNull byte[] b, int off, int len) throws IOException {
            if (len == 0) {
                return 0;
            }
            if (len < 0) {
                throw new IllegalArgumentException("len should not be less than zero");
            }
            if ((len = Math.min(this.sizeRemaining, len)) <= 0) {
                return -1;
            }
            byte[] arr = this.stream.readRawBytes(len);
            System.arraycopy(arr, 0, b, off, len);
            this.sizeRemaining -= len;
            return len;
        }

        @Override
        public long skip(long n) throws IOException {
            if ((n = Math.min((long)this.sizeRemaining, n)) <= 0L) {
                return 0L;
            }
            int skipped = (int)Math.min(Integer.MAX_VALUE, n);
            this.stream.skipRawBytes(skipped);
            this.sizeRemaining -= skipped;
            return skipped;
        }

        @Override
        public int available() {
            return Math.max(0, this.sizeRemaining);
        }

        @Override
        public void close() throws IOException {
            this.stream.skipRawBytes(this.sizeRemaining);
            this.sizeRemaining = 0;
        }
    }

    public static class ExposedByteArrayOutputStream
    extends ByteArrayOutputStream {
        public byte[] peekBuffer() {
            return this.buf;
        }
    }
}

