/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage.util;

import com.google.flatbuffers.FlatBufferBuilder;
import com.google.protobuf.ByteString;
import com.google.protobuf.ByteStringAccess;
import com.google.rpc.Code;
import io.deephaven.UncheckedDeephavenException;
import io.deephaven.api.util.NameValidator;
import io.deephaven.base.ClassUtil;
import io.deephaven.base.verify.Assert;
import io.deephaven.chunk.ChunkType;
import io.deephaven.configuration.Configuration;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.engine.table.ColumnDefinition;
import io.deephaven.engine.table.GridAttributes;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.TableDefinition;
import io.deephaven.engine.table.impl.BaseTable;
import io.deephaven.engine.table.impl.remote.ConstructSnapshot;
import io.deephaven.engine.table.impl.sources.ReinterpretUtils;
import io.deephaven.engine.table.impl.util.BarrageMessage;
import io.deephaven.engine.updategraph.impl.PeriodicUpdateGraph;
import io.deephaven.engine.util.ColumnFormatting;
import io.deephaven.engine.util.input.InputTableUpdater;
import io.deephaven.extensions.barrage.BarragePerformanceLog;
import io.deephaven.extensions.barrage.BarrageSnapshotOptions;
import io.deephaven.extensions.barrage.BarrageStreamGenerator;
import io.deephaven.extensions.barrage.BarrageStreamGeneratorImpl;
import io.deephaven.extensions.barrage.chunk.vector.VectorExpansionKernel;
import io.deephaven.extensions.barrage.util.StreamReaderOptions;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse;
import io.deephaven.proto.flight.util.MessageHelper;
import io.deephaven.proto.flight.util.SchemaHelper;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.util.type.TypeUtils;
import io.deephaven.vector.Vector;
import io.grpc.stub.StreamObserver;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.arrow.flatbuf.KeyValue;
import org.apache.arrow.flatbuf.Schema;
import org.apache.arrow.util.Collections2;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BarrageUtil {
    public static final BarrageSnapshotOptions DEFAULT_SNAPSHOT_DESER_OPTIONS = BarrageSnapshotOptions.builder().build();
    public static final long FLATBUFFER_MAGIC = 1852338276L;
    private static final Logger log = LoggerFactory.getLogger(BarrageUtil.class);
    public static final double TARGET_SNAPSHOT_PERCENTAGE = Configuration.getInstance().getDoubleForClassWithDefault(BarrageUtil.class, "targetSnapshotPercentage", 0.25);
    public static final long MIN_SNAPSHOT_CELL_COUNT = Configuration.getInstance().getLongForClassWithDefault(BarrageUtil.class, "minSnapshotCellCount", Long.MAX_VALUE);
    public static final long MAX_SNAPSHOT_CELL_COUNT = Configuration.getInstance().getLongForClassWithDefault(BarrageUtil.class, "maxSnapshotCellCount", Long.MAX_VALUE);
    public static final ArrowType.FixedSizeBinary LOCAL_DATE_TYPE = new ArrowType.FixedSizeBinary(6);
    public static final ArrowType.FixedSizeBinary LOCAL_TIME_TYPE = new ArrowType.FixedSizeBinary(7);
    public static final ArrowType.Timestamp NANO_SINCE_EPOCH_TYPE = new ArrowType.Timestamp(TimeUnit.NANOSECOND, "UTC");
    public static final String TABLE_ATTRIBUTE_IS_FLAT = "IsFlat";
    private static final int ATTR_STRING_LEN_CUTOFF = 1024;
    private static final String ATTR_DH_PREFIX = "deephaven:";
    private static final String ATTR_ATTR_TAG = "attribute";
    private static final String ATTR_ATTR_TYPE_TAG = "attribute_type";
    private static final String ATTR_TYPE_TAG = "type";
    private static final String ATTR_COMPONENT_TYPE_TAG = "componentType";
    private static final Set<Class<?>> supportedTypes = new HashSet(Collections2.asImmutableList((Object[])new Class[]{BigDecimal.class, BigInteger.class, String.class, Instant.class, Boolean.class}));

    public static ByteString schemaBytesFromTable(@NotNull Table table) {
        return BarrageUtil.schemaBytesFromTableDefinition(table.getDefinition(), table.getAttributes(), table.isFlat());
    }

    public static ByteString schemaBytesFromTableDefinition(@NotNull TableDefinition tableDefinition, @NotNull Map<String, Object> attributes, boolean isFlat) {
        return BarrageUtil.schemaBytes(fbb -> BarrageUtil.makeTableSchemaPayload(fbb, DEFAULT_SNAPSHOT_DESER_OPTIONS, tableDefinition, attributes, isFlat));
    }

    public static ByteString schemaBytes(@NotNull ToIntFunction<FlatBufferBuilder> schemaPayloadWriter) {
        FlatBufferBuilder builder = new FlatBufferBuilder();
        int schemaOffset = schemaPayloadWriter.applyAsInt(builder);
        builder.finish(MessageHelper.wrapInMessage((FlatBufferBuilder)builder, (int)schemaOffset, (byte)1));
        return ByteStringAccess.wrap((byte[])MessageHelper.toIpcBytes((FlatBufferBuilder)builder));
    }

    public static int makeTableSchemaPayload(@NotNull FlatBufferBuilder builder, @NotNull StreamReaderOptions options, @NotNull TableDefinition tableDefinition, @NotNull Map<String, Object> attributes, boolean isFlat) {
        Map<String, String> schemaMetadata = BarrageUtil.attributesToMetadata(attributes, isFlat);
        Map descriptions = GridAttributes.getColumnDescriptions(attributes);
        InputTableUpdater inputTableUpdater = (InputTableUpdater)attributes.get("InputTable");
        List fields = BarrageUtil.columnDefinitionsToFields(descriptions, inputTableUpdater, tableDefinition, tableDefinition.getColumns(), ignored -> new HashMap(), attributes, options.columnsAsList()).collect(Collectors.toList());
        return new org.apache.arrow.vector.types.pojo.Schema(fields, schemaMetadata).getSchema(builder);
    }

    @NotNull
    public static Map<String, String> attributesToMetadata(@NotNull Map<String, Object> attributes) {
        return BarrageUtil.attributesToMetadata(attributes, false);
    }

    @NotNull
    public static Map<String, String> attributesToMetadata(@NotNull Map<String, Object> attributes, boolean isFlat) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (isFlat) {
            BarrageUtil.putMetadata(metadata, "attribute.IsFlat", "true");
            BarrageUtil.putMetadata(metadata, "attribute_type.IsFlat", Boolean.class.getCanonicalName());
        }
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            String key = entry.getKey();
            Object val = entry.getValue();
            if (val instanceof Byte || val instanceof Short || val instanceof Integer || val instanceof Long || val instanceof Float || val instanceof Double || val instanceof Character || val instanceof Boolean || val instanceof String && ((String)val).length() < 1024) {
                BarrageUtil.putMetadata(metadata, "attribute." + key, val.toString());
                BarrageUtil.putMetadata(metadata, "attribute_type." + key, val.getClass().getCanonicalName());
                continue;
            }
            BarrageUtil.putMetadata(metadata, "unsent.attribute." + key, "");
        }
        return metadata;
    }

    public static Stream<Field> columnDefinitionsToFields(@NotNull Map<String, String> columnDescriptions, @Nullable InputTableUpdater inputTableUpdater, @NotNull TableDefinition tableDefinition, @NotNull Collection<ColumnDefinition<?>> columnDefinitions, @NotNull Function<String, Map<String, String>> fieldMetadataFactory, @NotNull Map<String, Object> attributes) {
        return BarrageUtil.columnDefinitionsToFields(columnDescriptions, inputTableUpdater, tableDefinition, columnDefinitions, fieldMetadataFactory, attributes, false);
    }

    private static boolean isDataTypeSortable(Class<?> dataType) {
        return dataType.isPrimitive() || Comparable.class.isAssignableFrom(dataType);
    }

    public static Stream<Field> columnDefinitionsToFields(@NotNull Map<String, String> columnDescriptions, @Nullable InputTableUpdater inputTableUpdater, @NotNull TableDefinition tableDefinition, @NotNull Collection<ColumnDefinition<?>> columnDefinitions, @NotNull Function<String, Map<String, String>> fieldMetadataFactory, @NotNull Map<String, Object> attributes, boolean columnsAsList) {
        Set sortableColumns;
        HashSet formatColumns = new HashSet();
        columnDefinitions.stream().map(ColumnDefinition::getName).filter(ColumnFormatting::isFormattingColumn).forEach(formatColumns::add);
        if (attributes.containsKey("SortableColumns")) {
            String[] restrictedSortColumns = attributes.get("SortableColumns").toString().split(",");
            sortableColumns = Arrays.stream(restrictedSortColumns).filter(columnName -> BarrageUtil.isDataTypeSortable(tableDefinition.getColumn(columnName).getDataType())).collect(Collectors.toSet());
        } else {
            sortableColumns = columnDefinitions.stream().filter(column -> BarrageUtil.isDataTypeSortable(column.getDataType())).map(ColumnDefinition::getName).collect(Collectors.toSet());
        }
        return columnDefinitions.stream().map(column -> {
            String dateFormatName;
            String numberFormatName;
            String name = column.getName();
            Class<?> dataType = column.getDataType();
            Class componentType = column.getComponentType();
            Map metadata = (Map)fieldMetadataFactory.apply(name);
            BarrageUtil.putMetadata(metadata, "isPartitioning", "" + column.isPartitioning());
            BarrageUtil.putMetadata(metadata, "isSortable", String.valueOf(sortableColumns.contains(name)));
            String styleFormatName = ColumnFormatting.getStyleFormatColumn((String)name);
            if (formatColumns.contains(styleFormatName)) {
                BarrageUtil.putMetadata(metadata, "styleColumn", styleFormatName);
            }
            if (formatColumns.contains(numberFormatName = ColumnFormatting.getNumberFormatColumn((String)name))) {
                BarrageUtil.putMetadata(metadata, "numberFormatColumn", numberFormatName);
            }
            if (formatColumns.contains(dateFormatName = ColumnFormatting.getDateFormatColumn((String)name))) {
                BarrageUtil.putMetadata(metadata, "dateFormatColumn", dateFormatName);
            }
            if (BarrageUtil.isTypeNativelySupported(dataType)) {
                BarrageUtil.putMetadata(metadata, ATTR_TYPE_TAG, dataType.getCanonicalName());
                if (componentType != null) {
                    if (BarrageUtil.isTypeNativelySupported(componentType)) {
                        BarrageUtil.putMetadata(metadata, ATTR_COMPONENT_TYPE_TAG, componentType.getCanonicalName());
                    } else {
                        BarrageUtil.putMetadata(metadata, ATTR_COMPONENT_TYPE_TAG, String.class.getCanonicalName());
                    }
                }
            } else {
                BarrageUtil.putMetadata(metadata, ATTR_TYPE_TAG, String.class.getCanonicalName());
            }
            BarrageUtil.putMetadata(metadata, "isRowStyle", "" + ColumnFormatting.isRowStyleFormatColumn((String)name));
            BarrageUtil.putMetadata(metadata, "isStyle", "" + ColumnFormatting.isStyleFormatColumn((String)name));
            BarrageUtil.putMetadata(metadata, "isNumberFormat", "" + ColumnFormatting.isNumberFormatColumn((String)name));
            BarrageUtil.putMetadata(metadata, "isDateFormat", "" + ColumnFormatting.isDateFormatColumn((String)name));
            String columnDescription = (String)columnDescriptions.get(name);
            if (columnDescription != null) {
                BarrageUtil.putMetadata(metadata, "description", columnDescription);
            }
            if (inputTableUpdater != null) {
                BarrageUtil.putMetadata(metadata, "inputtable.isKey", "" + inputTableUpdater.getKeyNames().contains(name));
            }
            if (columnsAsList) {
                componentType = dataType;
                dataType = Array.newInstance(dataType, 0).getClass();
            }
            if (Vector.class.isAssignableFrom(dataType)) {
                return BarrageUtil.arrowFieldForVectorType(name, dataType, componentType, metadata);
            }
            return BarrageUtil.arrowFieldFor(name, dataType, componentType, metadata);
        });
    }

    public static void putMetadata(Map<String, String> metadata, String key, String value) {
        metadata.put(ATTR_DH_PREFIX + key, value);
    }

    private static boolean maybeConvertForTimeUnit(TimeUnit unit, ConvertedArrowSchema result, int i) {
        switch (unit) {
            case NANOSECOND: {
                return true;
            }
            case MICROSECOND: {
                BarrageUtil.setConversionFactor(result, i, 1000);
                return true;
            }
            case MILLISECOND: {
                BarrageUtil.setConversionFactor(result, i, 1000000);
                return true;
            }
            case SECOND: {
                BarrageUtil.setConversionFactor(result, i, 1000000000);
                return true;
            }
        }
        return false;
    }

    private static Class<?> getDefaultType(ArrowType arrowType, ConvertedArrowSchema result, int i) {
        String exMsg = "Schema did not include `deephaven:type` metadata for field ";
        switch (arrowType.getTypeID()) {
            case Int: {
                ArrowType.Int intType = (ArrowType.Int)arrowType;
                if (intType.getIsSigned()) {
                    switch (intType.getBitWidth()) {
                        case 8: {
                            return Byte.TYPE;
                        }
                        case 16: {
                            return Short.TYPE;
                        }
                        case 32: {
                            return Integer.TYPE;
                        }
                        case 64: {
                            return Long.TYPE;
                        }
                    }
                } else {
                    switch (intType.getBitWidth()) {
                        case 8: {
                            return Short.TYPE;
                        }
                        case 16: {
                            return Integer.TYPE;
                        }
                        case 32: {
                            return Long.TYPE;
                        }
                    }
                }
                throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)("Schema did not include `deephaven:type` metadata for field  of intType(signed=" + intType.getIsSigned() + ", bitWidth=" + intType.getBitWidth() + ")"));
            }
            case Bool: {
                return Boolean.class;
            }
            case Duration: {
                ArrowType.Duration durationType = (ArrowType.Duration)arrowType;
                TimeUnit durationUnit = durationType.getUnit();
                if (BarrageUtil.maybeConvertForTimeUnit(durationUnit, result, i)) {
                    return Long.TYPE;
                }
                throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)("Schema did not include `deephaven:type` metadata for field  of durationType(unit=" + durationUnit.toString() + ")"));
            }
            case Timestamp: {
                ArrowType.Timestamp timestampType = (ArrowType.Timestamp)arrowType;
                String tz = timestampType.getTimezone();
                TimeUnit timestampUnit = timestampType.getUnit();
                if ((tz == null || "UTC".equals(tz)) && BarrageUtil.maybeConvertForTimeUnit(timestampUnit, result, i)) {
                    return Instant.class;
                }
                throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)("Schema did not include `deephaven:type` metadata for field  of timestampType(Timezone=" + tz + ", Unit=" + timestampUnit.toString() + ")"));
            }
            case FloatingPoint: {
                ArrowType.FloatingPoint floatingPointType = (ArrowType.FloatingPoint)arrowType;
                switch (floatingPointType.getPrecision()) {
                    case SINGLE: {
                        return Float.TYPE;
                    }
                    case DOUBLE: {
                        return Double.TYPE;
                    }
                }
                throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)("Schema did not include `deephaven:type` metadata for field  of floatingPointType(Precision=" + floatingPointType.getPrecision().toString() + ")"));
            }
            case Utf8: {
                return String.class;
            }
        }
        throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)("Schema did not include `deephaven:type` metadata for field  of type " + arrowType.getTypeID().toString()));
    }

    private static void setConversionFactor(ConvertedArrowSchema result, int i, int factor) {
        if (result.conversionFactors == null) {
            result.conversionFactors = new int[result.nCols];
            Arrays.fill(result.conversionFactors, 1);
        }
        result.conversionFactors[i] = factor;
    }

    public static TableDefinition convertTableDefinition(ExportedTableCreationResponse response) {
        return BarrageUtil.convertArrowSchema((Schema)SchemaHelper.flatbufSchema((ExportedTableCreationResponse)response)).tableDef;
    }

    public static ConvertedArrowSchema convertArrowSchema(ExportedTableCreationResponse response) {
        return BarrageUtil.convertArrowSchema(SchemaHelper.flatbufSchema((ExportedTableCreationResponse)response));
    }

    public static ConvertedArrowSchema convertArrowSchema(Schema schema) {
        return BarrageUtil.convertArrowSchema(schema.fieldsLength(), i -> schema.fields(i).name(), i -> ArrowType.getTypeForField((org.apache.arrow.flatbuf.Field)schema.fields(i)), i -> visitor -> {
            org.apache.arrow.flatbuf.Field field = schema.fields(i);
            if (field.dictionary() != null) {
                throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)("Dictionary encoding is not supported: " + field.name()));
            }
            for (int j = 0; j < field.customMetadataLength(); ++j) {
                KeyValue keyValue = field.customMetadata(j);
                visitor.accept(keyValue.key(), keyValue.value());
            }
        }, visitor -> {
            for (int j = 0; j < schema.customMetadataLength(); ++j) {
                KeyValue keyValue = schema.customMetadata(j);
                visitor.accept(keyValue.key(), keyValue.value());
            }
        });
    }

    public static ConvertedArrowSchema convertArrowSchema(org.apache.arrow.vector.types.pojo.Schema schema) {
        return BarrageUtil.convertArrowSchema(schema.getFields().size(), i -> ((Field)schema.getFields().get(i)).getName(), i -> ((Field)schema.getFields().get(i)).getType(), i -> visitor -> ((Field)schema.getFields().get(i)).getMetadata().forEach(visitor), visitor -> schema.getCustomMetadata().forEach(visitor));
    }

    private static ConvertedArrowSchema convertArrowSchema(int numColumns, IntFunction<String> getName, IntFunction<ArrowType> getArrowType, IntFunction<Consumer<BiConsumer<String, String>>> columnMetadataVisitor, Consumer<BiConsumer<String, String>> tableMetadataVisitor) {
        ConvertedArrowSchema result = new ConvertedArrowSchema(numColumns);
        ColumnDefinition[] columns = new ColumnDefinition[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            Class<?> defaultType;
            String origName = getName.apply(i);
            String name = NameValidator.legalizeColumnName((String)origName);
            MutableObject type = new MutableObject();
            MutableObject componentType = new MutableObject();
            columnMetadataVisitor.apply(i).accept((key, value) -> {
                if (key.equals("deephaven:type")) {
                    try {
                        type.setValue((Object)ClassUtil.lookupClass((String)value));
                    }
                    catch (ClassNotFoundException e) {
                        throw new UncheckedDeephavenException("Could not load class from schema", (Throwable)e);
                    }
                }
                if (key.equals("deephaven:componentType")) {
                    try {
                        componentType.setValue((Object)ClassUtil.lookupClass((String)value));
                    }
                    catch (ClassNotFoundException e) {
                        throw new UncheckedDeephavenException("Could not load class from schema", (Throwable)e);
                    }
                }
            });
            if (type.getValue() == null) {
                defaultType = BarrageUtil.getDefaultType(getArrowType.apply(i), result, i);
                type.setValue(defaultType);
            } else if (type.getValue() == Boolean.TYPE || type.getValue() == Boolean.class) {
                defaultType = BarrageUtil.getDefaultType(getArrowType.apply(i), result, i);
                Assert.eq(Boolean.class, (String)"deephaven column type", defaultType, (String)"arrow inferred type");
                type.setValue(Boolean.class);
            }
            columns[i] = ColumnDefinition.fromGenericType((String)name, (Class)((Class)type.getValue()), (Class)((Class)componentType.getValue()));
        }
        result.tableDef = TableDefinition.of((ColumnDefinition[])columns);
        result.attributes = new HashMap<String, Object>();
        HashMap<String, String> attributeTypeMap = new HashMap<String, String>();
        tableMetadataVisitor.accept((key, value) -> {
            String isAttributePrefix = "deephaven:attribute.";
            String isAttributeTypePrefix = "deephaven:attribute_type.";
            if (key.startsWith("deephaven:attribute.")) {
                result.attributes.put(key.substring("deephaven:attribute.".length()), value);
            } else if (key.startsWith("deephaven:attribute_type.")) {
                attributeTypeMap.put(key.substring("deephaven:attribute_type.".length()), (String)value);
            }
        });
        attributeTypeMap.forEach((attrKey, attrType) -> {
            if (!result.attributes.containsKey(attrKey)) {
                log.warn().append((CharSequence)"Schema included ").append((CharSequence)ATTR_ATTR_TYPE_TAG).append((CharSequence)" tag but not a corresponding ").append((CharSequence)ATTR_ATTR_TAG).append((CharSequence)" tag for key ").append((CharSequence)attrKey).append((CharSequence)".").endl();
                return;
            }
            Object currValue = result.attributes.get(attrKey);
            if (!(currValue instanceof String)) {
                throw new IllegalStateException();
            }
            String stringValue = (String)currValue;
            switch (attrType) {
                case "java.lang.Byte": {
                    result.attributes.put((String)attrKey, Byte.valueOf(stringValue));
                    break;
                }
                case "java.lang.Short": {
                    result.attributes.put((String)attrKey, Short.valueOf(stringValue));
                    break;
                }
                case "java.lang.Integer": {
                    result.attributes.put((String)attrKey, Integer.valueOf(stringValue));
                    break;
                }
                case "java.lang.Long": {
                    result.attributes.put((String)attrKey, Long.valueOf(stringValue));
                    break;
                }
                case "java.lang.Float": {
                    result.attributes.put((String)attrKey, Float.valueOf(stringValue));
                    break;
                }
                case "java.lang.Double": {
                    result.attributes.put((String)attrKey, Double.valueOf(stringValue));
                    break;
                }
                case "java.lang.Character": {
                    result.attributes.put((String)attrKey, Character.valueOf(stringValue.isEmpty() ? (char)'\u0000' : stringValue.charAt(0)));
                    break;
                }
                case "java.lang.Boolean": {
                    result.attributes.put((String)attrKey, Boolean.valueOf(stringValue));
                    break;
                }
                case "java.lang.String": {
                    break;
                }
                default: {
                    log.warn().append((CharSequence)"Schema included unsupported ").append((CharSequence)ATTR_ATTR_TYPE_TAG).append((CharSequence)" tag of '").append((CharSequence)attrType).append((CharSequence)"' for key ").append((CharSequence)attrKey).append((CharSequence)".").endl();
                }
            }
        });
        return result;
    }

    private static boolean isTypeNativelySupported(Class<?> typ) {
        if (typ.isPrimitive() || TypeUtils.isBoxedType(typ) || supportedTypes.contains(typ) || Vector.class.isAssignableFrom(typ) || TypeUtils.isDateTime(typ)) {
            return true;
        }
        if (typ.isArray()) {
            return BarrageUtil.isTypeNativelySupported(typ.getComponentType());
        }
        return false;
    }

    private static Field arrowFieldFor(String name, Class<?> type, Class<?> componentType, Map<String, String> metadata) {
        List<Object> children = Collections.emptyList();
        FieldType fieldType = BarrageUtil.arrowFieldTypeFor(type, metadata);
        if (fieldType.getType().isComplex()) {
            if (type.isArray()) {
                children = Collections.singletonList(BarrageUtil.arrowFieldFor("", componentType, componentType.getComponentType(), Collections.emptyMap()));
            } else {
                throw new UnsupportedOperationException("Arrow Complex Type Not Supported: " + fieldType.getType());
            }
        }
        return new Field(name, fieldType, children);
    }

    private static FieldType arrowFieldTypeFor(Class<?> type, Map<String, String> metadata) {
        return new FieldType(true, BarrageUtil.arrowTypeFor(type), null, metadata);
    }

    private static ArrowType arrowTypeFor(Class<?> type) {
        if (TypeUtils.isBoxedType(type)) {
            type = TypeUtils.getUnboxedType(type);
        }
        ChunkType chunkType = ChunkType.fromElementType(type);
        switch (chunkType) {
            case Boolean: {
                return Types.MinorType.BIT.getType();
            }
            case Char: {
                return Types.MinorType.UINT2.getType();
            }
            case Byte: {
                return Types.MinorType.TINYINT.getType();
            }
            case Short: {
                return Types.MinorType.SMALLINT.getType();
            }
            case Int: {
                return Types.MinorType.INT.getType();
            }
            case Long: {
                return Types.MinorType.BIGINT.getType();
            }
            case Float: {
                return Types.MinorType.FLOAT4.getType();
            }
            case Double: {
                return Types.MinorType.FLOAT8.getType();
            }
            case Object: {
                if (type.isArray()) {
                    return Types.MinorType.LIST.getType();
                }
                if (type == LocalDate.class) {
                    return LOCAL_DATE_TYPE;
                }
                if (type == LocalTime.class) {
                    return LOCAL_TIME_TYPE;
                }
                if (type == BigDecimal.class || type == BigInteger.class) {
                    return Types.MinorType.VARBINARY.getType();
                }
                if (type == Instant.class || type == ZonedDateTime.class) {
                    return NANO_SINCE_EPOCH_TYPE;
                }
                return Types.MinorType.VARCHAR.getType();
            }
        }
        throw new IllegalStateException("No ArrowType for type: " + type + " w/chunkType: " + chunkType);
    }

    private static Field arrowFieldForVectorType(String name, Class<?> type, Class<?> knownComponentType, Map<String, String> metadata) {
        FieldType fieldType = new FieldType(true, Types.MinorType.LIST.getType(), null, metadata);
        Class<?> componentType = VectorExpansionKernel.getComponentType(type, knownComponentType);
        List<Field> children = Collections.singletonList(BarrageUtil.arrowFieldFor("", componentType, componentType.getComponentType(), Collections.emptyMap()));
        return new Field(name, fieldType, children);
    }

    public static void createAndSendStaticSnapshot(BarrageStreamGenerator.Factory<BarrageStreamGeneratorImpl.View> streamGeneratorFactory, BaseTable<?> table, BitSet columns, RowSet viewport, boolean reverseViewport, BarrageSnapshotOptions snapshotRequestOptions, StreamObserver<BarrageStreamGeneratorImpl.View> listener, BarragePerformanceLog.SnapshotMetricsHelper metrics) {
        long snapshotTargetCellCount = MIN_SNAPSHOT_CELL_COUNT;
        double snapshotNanosPerCell = 0.0;
        long columnCount = Math.max(1, columns != null ? columns.cardinality() : table.getDefinition().getColumns().size());
        try (WritableRowSet snapshotViewport = RowSetFactory.empty();
             WritableRowSet targetViewport = RowSetFactory.empty();){
            if (viewport == null) {
                targetViewport.insertRange(0L, table.size() - 1L);
            } else if (!reverseViewport) {
                targetViewport.insert(viewport);
            } else {
                try (WritableRowSet rowKeys = table.getRowSet().subSetForReversePositions((RowSequence)viewport);
                     WritableRowSet inverted = table.getRowSet().invert((RowSet)rowKeys);){
                    targetViewport.insert((RowSet)inverted);
                }
            }
            try (RowSequence.Iterator rsIt = targetViewport.getRowSequenceIterator();){
                while (rsIt.hasMore()) {
                    long cellCount = Math.max(MIN_SNAPSHOT_CELL_COUNT, Math.min(snapshotTargetCellCount, MAX_SNAPSHOT_CELL_COUNT));
                    long numRows = Math.min(Math.max(1L, cellCount / columnCount), 0x7FFFFFF7L);
                    RowSequence snapshotPartialViewport = rsIt.getNextRowSequenceWithLength(numRows);
                    snapshotPartialViewport.forAllRowKeyRanges((arg_0, arg_1) -> ((WritableRowSet)snapshotViewport).insertRange(arg_0, arg_1));
                    long start = System.nanoTime();
                    BarrageMessage msg = ConstructSnapshot.constructBackplaneSnapshotInPositionSpace((Object)log, table, (BitSet)columns, (RowSequence)snapshotPartialViewport, null);
                    msg.modColumnData = BarrageMessage.ZERO_MOD_COLUMNS;
                    long elapsed = System.nanoTime() - start;
                    metrics.snapshotNanos += elapsed;
                    try (BarrageStreamGenerator<BarrageStreamGeneratorImpl.View> bsg = streamGeneratorFactory.newGenerator(msg, metrics);){
                        if (rsIt.hasMore()) {
                            listener.onNext((Object)bsg.getSnapshotView(snapshotRequestOptions, (RowSet)snapshotViewport, false, msg.rowsIncluded, columns));
                        } else {
                            listener.onNext((Object)bsg.getSnapshotView(snapshotRequestOptions, viewport, reverseViewport, msg.rowsIncluded, columns));
                        }
                    }
                    if (msg.rowsIncluded.isEmpty()) continue;
                    PeriodicUpdateGraph updateGraph = (PeriodicUpdateGraph)table.getUpdateGraph().cast();
                    long targetNanos = (long)(TARGET_SNAPSHOT_PERCENTAGE * (double)updateGraph.getTargetCycleDurationMillis() * 1000000.0);
                    long nanosPerCell = elapsed / (msg.rowsIncluded.size() * columnCount);
                    snapshotNanosPerCell = snapshotNanosPerCell == 0.0 ? (double)nanosPerCell : snapshotNanosPerCell * 0.9 + (double)nanosPerCell * 0.1;
                    snapshotTargetCellCount = (long)((double)targetNanos / Math.max(1.0, snapshotNanosPerCell));
                }
            }
        }
    }

    public static void createAndSendSnapshot(BarrageStreamGenerator.Factory<BarrageStreamGeneratorImpl.View> streamGeneratorFactory, BaseTable<?> table, BitSet columns, RowSet viewport, boolean reverseViewport, BarrageSnapshotOptions snapshotRequestOptions, StreamObserver<BarrageStreamGeneratorImpl.View> listener, BarragePerformanceLog.SnapshotMetricsHelper metrics) {
        if (!table.isRefreshing()) {
            BarrageUtil.createAndSendStaticSnapshot(streamGeneratorFactory, table, columns, viewport, reverseViewport, snapshotRequestOptions, listener, metrics);
            return;
        }
        long snapshotStartTm = System.nanoTime();
        BarrageMessage msg = reverseViewport ? ConstructSnapshot.constructBackplaneSnapshotInPositionSpace((Object)log, table, (BitSet)columns, null, (RowSequence)viewport) : ConstructSnapshot.constructBackplaneSnapshotInPositionSpace((Object)log, table, (BitSet)columns, (RowSequence)viewport, null);
        metrics.snapshotNanos = System.nanoTime() - snapshotStartTm;
        msg.modColumnData = BarrageMessage.ZERO_MOD_COLUMNS;
        try (BarrageStreamGenerator<BarrageStreamGeneratorImpl.View> bsg = streamGeneratorFactory.newGenerator(msg, metrics);
             WritableRowSet keySpaceViewport = viewport != null ? msg.rowsAdded.subSetForPositions((RowSequence)viewport, reverseViewport) : null;){
            listener.onNext((Object)bsg.getSnapshotView(snapshotRequestOptions, viewport, reverseViewport, (RowSet)keySpaceViewport, columns));
        }
    }

    public static class ConvertedArrowSchema {
        public final int nCols;
        public TableDefinition tableDef;
        public int[] conversionFactors;
        public Map<String, Object> attributes;

        public ConvertedArrowSchema(int nCols) {
            this.nCols = nCols;
        }

        public ChunkType[] computeWireChunkTypes() {
            return (ChunkType[])this.tableDef.getColumnStream().map(ColumnDefinition::getDataType).map(ReinterpretUtils::maybeConvertToWritablePrimitiveChunkType).toArray(ChunkType[]::new);
        }

        public Class<?>[] computeWireTypes() {
            return (Class[])this.tableDef.getColumnStream().map(ColumnDefinition::getDataType).toArray(Class[]::new);
        }

        public Class<?>[] computeWireComponentTypes() {
            return (Class[])this.tableDef.getColumnStream().map(ColumnDefinition::getComponentType).toArray(Class[]::new);
        }
    }
}

