/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage.util;

import io.deephaven.extensions.barrage.util.BarrageProtoUtil;
import io.deephaven.extensions.barrage.util.DefensiveDrainable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class DefensiveCapture
extends InputStream {
    private DefensiveDrainable in;
    private InputStream delegate;

    public DefensiveCapture(DefensiveDrainable in) {
        this.in = Objects.requireNonNull(in);
    }

    synchronized InputStream delegate() throws IOException {
        if (this.delegate != null) {
            return this.delegate;
        }
        BarrageProtoUtil.ExposedByteArrayOutputStream out = new BarrageProtoUtil.ExposedByteArrayOutputStream();
        int size = this.in.drainTo(out);
        this.in.close();
        this.in = null;
        this.delegate = new ByteArrayInputStream(out.peekBuffer(), 0, size);
        return this.delegate;
    }

    @Override
    public int read() throws IOException {
        return this.delegate().read();
    }

    @Override
    public int read(@NotNull byte[] b) throws IOException {
        return this.delegate().read(b);
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        return this.delegate().read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.delegate().skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.delegate().available();
    }

    @Override
    public void close() throws IOException {
        this.delegate().close();
    }
}

