/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage.util;

import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.UncoalescedTable;
import io.deephaven.extensions.barrage.util.BarrageUtil;
import io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse;
import io.deephaven.proto.backplane.grpc.TableReference;
import io.deephaven.proto.backplane.grpc.Ticket;

public class ExportUtil {
    public static ExportedTableCreationResponse buildTableCreationResponse(Ticket ticket, Table table) {
        return ExportUtil.buildTableCreationResponse(TableReference.newBuilder().setTicket(ticket).build(), table);
    }

    public static ExportedTableCreationResponse buildTableCreationResponse(TableReference tableRef, Table table) {
        long size = table instanceof UncoalescedTable ? Long.MIN_VALUE : table.size();
        return ExportedTableCreationResponse.newBuilder().setSuccess(true).setResultId(tableRef).setIsStatic(!table.isRefreshing()).setSize(size).setSchemaHeader(BarrageUtil.schemaBytesFromTable(table)).build();
    }
}

