/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage.util;

import com.google.rpc.Code;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.util.function.ThrowingRunnable;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.StreamObserver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GrpcUtil {
    private static final Logger log = LoggerFactory.getLogger(GrpcUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void safelyExecuteLocked(StreamObserver<?> observer, ThrowingRunnable<Exception> runner) {
        try {
            StreamObserver<?> streamObserver = observer;
            synchronized (streamObserver) {
                runner.run();
            }
        }
        catch (Exception err) {
            log.debug().append((CharSequence)"Unanticipated gRPC Error: ").append((Throwable)err).endl();
        }
    }

    public static <T> void safelyOnNext(StreamObserver<T> observer, T message) {
        GrpcUtil.safelyExecuteLocked(observer, (ThrowingRunnable<Exception>)((ThrowingRunnable)() -> observer.onNext(message)));
    }

    public static <T> void safelyComplete(StreamObserver<T> observer, T message) {
        GrpcUtil.safelyExecuteLocked(observer, (ThrowingRunnable<Exception>)((ThrowingRunnable)() -> {
            observer.onNext(message);
            observer.onCompleted();
        }));
    }

    public static void safelyComplete(StreamObserver<?> observer) {
        GrpcUtil.safelyExecuteLocked(observer, (ThrowingRunnable<Exception>)((ThrowingRunnable)() -> observer.onCompleted()));
    }

    public static void safelyError(@NotNull StreamObserver<?> observer, Code statusCode, @NotNull String msg) {
        GrpcUtil.safelyError(observer, Exceptions.statusRuntimeException((Code)statusCode, (String)msg));
    }

    public static void safelyError(@NotNull StreamObserver<?> observer, @NotNull StatusRuntimeException exception) {
        GrpcUtil.safelyExecuteLocked(observer, (ThrowingRunnable<Exception>)((ThrowingRunnable)() -> observer.onError((Throwable)exception)));
    }

    public static void safelyCancel(@NotNull ClientCallStreamObserver<?> observer, @Nullable String message, @Nullable Throwable cause) {
        GrpcUtil.safelyExecuteLocked(observer, (ThrowingRunnable<Exception>)((ThrowingRunnable)() -> observer.cancel(message, cause)));
    }
}

