/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage.util;

import com.google.flatbuffers.FlatBufferBuilder;
import io.deephaven.api.ColumnName;
import io.deephaven.api.agg.AggregationPairs;
import io.deephaven.engine.table.GridAttributes;
import io.deephaven.engine.table.hierarchical.HierarchicalTable;
import io.deephaven.engine.table.hierarchical.RollupTable;
import io.deephaven.engine.table.hierarchical.TreeTable;
import io.deephaven.extensions.barrage.util.BarrageUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.jetbrains.annotations.NotNull;

public class HierarchicalTableSchemaUtil {
    private static final String HIERARCHICAL_TABLE_IS_STRUCTURAL_COLUMN = "hierarchicalTable.isStructuralColumn";
    private static final String HIERARCHICAL_TABLE_IS_EXPAND_BY_COLUMN = "hierarchicalTable.isExpandByColumn";
    private static final String HIERARCHICAL_TABLE_IS_ROW_DEPTH_COLUMN = "hierarchicalTable.isRowDepthColumn";
    private static final String HIERARCHICAL_TABLE_IS_ROW_EXPANDED_COLUMN = "hierarchicalTable.isRowExpandedColumn";
    private static final String ROLLUP_TABLE_IS_AGGREGATED_NODE_COLUMN = "rollupTable.isAggregatedNodeColumn";
    private static final String ROLLUP_TABLE_IS_CONSTITUENT_NODE_COLUMN = "rollupTable.isConstituentNodeColumn";
    private static final String ROLLUP_TABLE_IS_GROUP_BY_COLUMN = "rollupTable.isGroupByColumn";
    private static final String ROLLUP_TABLE_AGGREGATION_INPUT_COLUMN_NAME = "rollupTable.aggregationInputColumnName";
    private static final String TREE_TABLE_IS_NODE_COLUMN = "treeTable.isNodeColumn";
    private static final String TREE_TABLE_IS_IDENTIFIER_COLUMN = "treeTable.isIdentifierColumn";
    private static final String TREE_TABLE_IS_PARENT_IDENTIFIER_COLUMN = "treeTable.isParentIdentifierColumn";
    private static final String TRUE_STRING = Boolean.toString(true);

    public static int makeSchemaPayload(@NotNull FlatBufferBuilder builder, @NotNull HierarchicalTable<?> hierarchicalTable) {
        if (hierarchicalTable instanceof RollupTable) {
            RollupTable rollupTable = (RollupTable)hierarchicalTable;
            return HierarchicalTableSchemaUtil.makeRollupTableSchemaPayload(builder, rollupTable);
        }
        if (hierarchicalTable instanceof TreeTable) {
            TreeTable treeTable = (TreeTable)hierarchicalTable;
            return HierarchicalTableSchemaUtil.makeTreeTableSchemaPayload(builder, treeTable);
        }
        throw new IllegalArgumentException("Unknown HierarchicalTable type");
    }

    private static int makeRollupTableSchemaPayload(@NotNull FlatBufferBuilder builder, @NotNull RollupTable rollupTable) {
        Map<String, String> schemaMetadata = BarrageUtil.attributesToMetadata(rollupTable.getAttributes());
        Set<String> groupByColumns = rollupTable.getGroupByColumns().stream().map(ColumnName::name).collect(Collectors.toSet());
        Stream<Field> structuralFields = HierarchicalTableSchemaUtil.getStructuralFields(rollupTable);
        Stream<Field> aggregatedFields = HierarchicalTableSchemaUtil.getRollupAggregatedNodeFields(rollupTable, groupByColumns);
        Stream<Field> constituentFields = HierarchicalTableSchemaUtil.getRollupConstituentNodeFields(rollupTable, groupByColumns);
        List fields = Stream.of(structuralFields, aggregatedFields, constituentFields).flatMap(Function.identity()).collect(Collectors.toList());
        return new Schema(fields, schemaMetadata).getSchema(builder);
    }

    private static int makeTreeTableSchemaPayload(@NotNull FlatBufferBuilder builder, @NotNull TreeTable treeTable) {
        Map<String, String> schemaMetadata = BarrageUtil.attributesToMetadata(treeTable.getAttributes());
        Stream<Field> structuralFields = HierarchicalTableSchemaUtil.getStructuralFields(treeTable);
        Stream<Field> nodeFields = HierarchicalTableSchemaUtil.getTreeNodeFields(treeTable);
        List fields = Stream.concat(structuralFields, nodeFields).collect(Collectors.toList());
        return new Schema(fields, schemaMetadata).getSchema(builder);
    }

    private static Stream<Field> getStructuralFields(@NotNull HierarchicalTable<?> hierarchicalTable) {
        return BarrageUtil.columnDefinitionsToFields(Collections.emptyMap(), null, hierarchicalTable.getRoot().getDefinition(), hierarchicalTable.getStructuralColumnDefinitions(), columnName -> {
            HashMap<String, String> metadata = new HashMap<String, String>();
            BarrageUtil.putMetadata(metadata, HIERARCHICAL_TABLE_IS_STRUCTURAL_COLUMN, TRUE_STRING);
            if (columnName.equals(hierarchicalTable.getRowDepthColumn().name())) {
                BarrageUtil.putMetadata(metadata, HIERARCHICAL_TABLE_IS_ROW_DEPTH_COLUMN, TRUE_STRING);
                if (hierarchicalTable instanceof RollupTable) {
                    BarrageUtil.putMetadata(metadata, HIERARCHICAL_TABLE_IS_EXPAND_BY_COLUMN, TRUE_STRING);
                }
            } else if (columnName.equals(hierarchicalTable.getRowExpandedColumn().name())) {
                BarrageUtil.putMetadata(metadata, HIERARCHICAL_TABLE_IS_ROW_EXPANDED_COLUMN, TRUE_STRING);
            }
            return metadata;
        }, hierarchicalTable.getAttributes());
    }

    private static Stream<Field> getRollupAggregatedNodeFields(@NotNull RollupTable rollupTable, @NotNull Set<String> groupByColumns) {
        Map<String, String> aggregationColumnToInputColumnName = AggregationPairs.of((Collection)rollupTable.getAggregations()).collect(Collectors.toMap(cnp -> cnp.output().name(), cnp -> cnp.input().name()));
        Map aggregatedNodeDescriptions = GridAttributes.getColumnDescriptions((Map)rollupTable.getAttributes());
        return BarrageUtil.columnDefinitionsToFields(aggregatedNodeDescriptions, null, rollupTable.getNodeDefinition(RollupTable.NodeType.Aggregated), rollupTable.getNodeDefinition(RollupTable.NodeType.Aggregated).getColumns(), columnName -> {
            HashMap<String, String> metadata = new HashMap<String, String>();
            BarrageUtil.putMetadata(metadata, ROLLUP_TABLE_IS_AGGREGATED_NODE_COLUMN, TRUE_STRING);
            if (groupByColumns.contains(columnName)) {
                BarrageUtil.putMetadata(metadata, ROLLUP_TABLE_IS_GROUP_BY_COLUMN, TRUE_STRING);
                BarrageUtil.putMetadata(metadata, HIERARCHICAL_TABLE_IS_EXPAND_BY_COLUMN, TRUE_STRING);
            } else {
                BarrageUtil.putMetadata(metadata, ROLLUP_TABLE_AGGREGATION_INPUT_COLUMN_NAME, aggregationColumnToInputColumnName.getOrDefault(columnName, ""));
            }
            return metadata;
        }, rollupTable.getAttributes());
    }

    private static Stream<Field> getRollupConstituentNodeFields(@NotNull RollupTable rollupTable, @NotNull Set<String> groupByColumns) {
        if (!rollupTable.includesConstituents()) {
            return Stream.empty();
        }
        Map sourceAttributes = rollupTable.getSource().getAttributes();
        Map constituentNodeDescriptions = GridAttributes.getColumnDescriptions((Map)sourceAttributes);
        return BarrageUtil.columnDefinitionsToFields(constituentNodeDescriptions, null, rollupTable.getNodeDefinition(RollupTable.NodeType.Constituent), rollupTable.getNodeDefinition(RollupTable.NodeType.Constituent).getColumns(), columnName -> {
            HashMap<String, String> metadata = new HashMap<String, String>();
            BarrageUtil.putMetadata(metadata, ROLLUP_TABLE_IS_CONSTITUENT_NODE_COLUMN, TRUE_STRING);
            if (groupByColumns.contains(columnName)) {
                BarrageUtil.putMetadata(metadata, ROLLUP_TABLE_IS_GROUP_BY_COLUMN, TRUE_STRING);
            }
            return metadata;
        }, rollupTable.getAttributes());
    }

    private static Stream<Field> getTreeNodeFields(@NotNull TreeTable treeTable) {
        Map treeNodeDescriptions = GridAttributes.getColumnDescriptions((Map)treeTable.getAttributes());
        return BarrageUtil.columnDefinitionsToFields(treeNodeDescriptions, null, treeTable.getNodeDefinition(), treeTable.getNodeDefinition().getColumns(), columnName -> {
            HashMap<String, String> metadata = new HashMap<String, String>();
            BarrageUtil.putMetadata(metadata, TREE_TABLE_IS_NODE_COLUMN, TRUE_STRING);
            if (columnName.equals(treeTable.getIdentifierColumn().name())) {
                BarrageUtil.putMetadata(metadata, TREE_TABLE_IS_IDENTIFIER_COLUMN, TRUE_STRING);
                BarrageUtil.putMetadata(metadata, HIERARCHICAL_TABLE_IS_EXPAND_BY_COLUMN, TRUE_STRING);
            } else if (columnName.equals(treeTable.getParentIdentifierColumn().name())) {
                BarrageUtil.putMetadata(metadata, TREE_TABLE_IS_PARENT_IDENTIFIER_COLUMN, TRUE_STRING);
            }
            return metadata;
        }, treeTable.getAttributes());
    }
}

