/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.extensions.barrage.util;

import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.BaseTable;
import io.deephaven.extensions.barrage.BarragePerformanceLog;
import io.deephaven.extensions.barrage.BarrageStreamGeneratorImpl;
import io.deephaven.extensions.barrage.util.BarrageProtoUtil;
import io.deephaven.extensions.barrage.util.BarrageUtil;
import io.grpc.Drainable;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.NoSuchElementException;

public class TableToArrowConverter {
    private final BaseTable table;
    private ArrowBuilderObserver listener = null;

    public TableToArrowConverter(BaseTable table) {
        this.table = table;
    }

    private void populateRecordBatches() {
        if (this.listener != null) {
            return;
        }
        BarragePerformanceLog.SnapshotMetricsHelper metrics = new BarragePerformanceLog.SnapshotMetricsHelper();
        this.listener = new ArrowBuilderObserver();
        BarrageUtil.createAndSendSnapshot(new BarrageStreamGeneratorImpl.ArrowFactory(), this.table, null, null, false, BarrageUtil.DEFAULT_SNAPSHOT_DESER_OPTIONS, this.listener, metrics);
    }

    public byte[] getSchema() {
        return BarrageUtil.schemaBytesFromTable((Table)this.table).toByteArray();
    }

    public boolean hasNext() {
        this.populateRecordBatches();
        return !this.listener.batchMessages.isEmpty();
    }

    public byte[] next() {
        this.populateRecordBatches();
        if (this.listener.batchMessages.isEmpty()) {
            throw new NoSuchElementException("There are no more RecordBatches for the table");
        }
        return this.listener.batchMessages.pop();
    }

    private static class ArrowBuilderObserver
    implements StreamObserver<BarrageStreamGeneratorImpl.View> {
        final Deque<byte[]> batchMessages = new ArrayDeque<byte[]>();

        private ArrowBuilderObserver() {
        }

        public void onNext(BarrageStreamGeneratorImpl.View messageView) {
            try {
                messageView.forEachStream(inputStream -> {
                    try (BarrageProtoUtil.ExposedByteArrayOutputStream baos = new BarrageProtoUtil.ExposedByteArrayOutputStream();){
                        ((Drainable)inputStream).drainTo((OutputStream)baos);
                        this.batchMessages.add(baos.toByteArray());
                        inputStream.close();
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Failed to build barrage message: ", e);
                    }
                });
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to generate barrage message: ", e);
            }
        }

        public void onError(Throwable throwable) {
            throw new IllegalStateException(throwable);
        }

        public void onCompleted() {
        }
    }
}

