/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv;

import io.deephaven.api.util.NameValidator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public enum ColumnNameLegalizer implements Function<String[], String[]>,
Predicate<String>
{
    INSTANCE;

    private final Pattern pattern = Pattern.compile("[- ]");

    private String replace(String columnName) {
        return this.pattern.matcher(columnName).replaceAll("_");
    }

    @Override
    public String[] apply(String[] columnNames) {
        return NameValidator.legalizeColumnNames((String[])columnNames, this::replace, (boolean)true);
    }

    @Override
    public boolean test(String columnName) {
        return NameValidator.isValidColumnName((String)columnName);
    }
}

