/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv;

import gnu.trove.map.hash.TIntObjectHashMap;
import io.deephaven.csv.containers.ByteSlice;
import io.deephaven.csv.tokenization.RangeTests;
import io.deephaven.csv.tokenization.Tokenizer;
import io.deephaven.csv.util.MutableLong;
import io.deephaven.csv.util.MutableObject;
import io.deephaven.time.TimeZoneAliases;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.util.Map;

public final class DeephavenTimeZoneParser
implements Tokenizer.CustomTimeZoneParser {
    private static final int MAX_TZ_LENGTH = DeephavenTimeZoneParser.computeMaxTimeZoneLength();
    private static final TIntObjectHashMap<ZoneId> ZONE_ID_MAP = DeephavenTimeZoneParser.createZoneIdMap();
    private int lastTzKey = -1;
    private ZoneId lastZoneId = null;

    public boolean tryParse(ByteSlice bs, MutableObject<ZoneId> zoneId, MutableLong offsetSeconds) {
        if (bs.size() == 0 || bs.front() != 32) {
            return false;
        }
        int savedBegin = bs.begin();
        bs.setBegin(bs.begin() + 1);
        int tzKey = DeephavenTimeZoneParser.tryParseTzKey(bs);
        if (tzKey < 0) {
            bs.setBegin(savedBegin);
            return false;
        }
        if (tzKey != this.lastTzKey) {
            ZoneId res = (ZoneId)ZONE_ID_MAP.get(tzKey);
            if (res == null) {
                bs.setBegin(savedBegin);
                return false;
            }
            this.lastTzKey = tzKey;
            this.lastZoneId = res;
        }
        zoneId.setValue((Object)this.lastZoneId);
        offsetSeconds.setValue(0L);
        return true;
    }

    private static int computeMaxTimeZoneLength() {
        int rst = 0;
        for (String tz : TimeZoneAliases.getAllZones().keySet()) {
            rst = Math.max(tz.length(), rst);
        }
        return rst;
    }

    private static int tryParseTzKey(ByteSlice bs) {
        int current;
        int res = 0;
        for (current = bs.begin(); current != bs.end(); ++current) {
            if (current - bs.begin() > MAX_TZ_LENGTH) {
                return -1;
            }
            char ch = RangeTests.toUpper((char)((char)bs.data()[current]));
            res = res * 26 + (ch - 65);
        }
        if (current - bs.begin() == 0) {
            return -1;
        }
        bs.setBegin(current);
        return Math.abs(res);
    }

    private static TIntObjectHashMap<ZoneId> createZoneIdMap() {
        TIntObjectHashMap zoneIdMap = new TIntObjectHashMap();
        for (Map.Entry entry : TimeZoneAliases.getAllZones().entrySet()) {
            String zname = (String)entry.getKey();
            ZoneId zoneId = (ZoneId)entry.getValue();
            if (zname.length() > MAX_TZ_LENGTH) {
                throw new RuntimeException("Logic error: unexpectedly-long time zone name: " + zname);
            }
            byte[] data = zname.getBytes(StandardCharsets.UTF_8);
            ByteSlice bs = new ByteSlice(data, 0, data.length);
            int tzKey = DeephavenTimeZoneParser.tryParseTzKey(bs);
            if (tzKey < 0) {
                throw new RuntimeException("Logic error: can't parse time zone as key: " + zname);
            }
            ZoneId previous = (ZoneId)zoneIdMap.put(tzKey, (Object)zoneId);
            if (previous == null) continue;
            throw new RuntimeException("Time zone hashing collision: " + zname + " " + tzKey);
        }
        return zoneIdMap;
    }
}

