/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.kafka;

import io.deephaven.function.ToBooleanFunction;
import io.deephaven.function.ToByteFunction;
import io.deephaven.function.ToCharFunction;
import io.deephaven.function.ToDoubleFunction;
import io.deephaven.function.ToFloatFunction;
import io.deephaven.function.ToIntFunction;
import io.deephaven.function.ToLongFunction;
import io.deephaven.function.ToObjectFunction;
import io.deephaven.function.ToPrimitiveFunction;
import io.deephaven.function.ToShortFunction;
import io.deephaven.function.TypedFunction;
import io.deephaven.qst.type.BoxedBooleanType;
import io.deephaven.qst.type.BoxedByteType;
import io.deephaven.qst.type.BoxedCharType;
import io.deephaven.qst.type.BoxedDoubleType;
import io.deephaven.qst.type.BoxedFloatType;
import io.deephaven.qst.type.BoxedIntType;
import io.deephaven.qst.type.BoxedLongType;
import io.deephaven.qst.type.BoxedShortType;
import io.deephaven.qst.type.GenericType;
import io.deephaven.util.type.TypeUtils;

class BoxTransform {
    BoxTransform() {
    }

    public static <T> ToObjectFunction<T, ?> of(TypedFunction<T> f) {
        return BoxedVisitor.of(f);
    }

    public static <T> ToObjectFunction<T, ?> of(ToPrimitiveFunction<T> f) {
        return BoxedVisitor.of(f);
    }

    public static <T> ToObjectFunction<T, Boolean> of(ToBooleanFunction<T> f) {
        return ToObjectFunction.of(arg_0 -> f.test(arg_0), (GenericType)BoxedBooleanType.of());
    }

    public static <T> ToObjectFunction<T, Character> of(ToCharFunction<T> f) {
        return ToObjectFunction.of(t -> BoxTransform.box(f, t), (GenericType)BoxedCharType.of());
    }

    public static <T> ToObjectFunction<T, Byte> of(ToByteFunction<T> f) {
        return ToObjectFunction.of(t -> BoxTransform.box(f, t), (GenericType)BoxedByteType.of());
    }

    public static <T> ToObjectFunction<T, Short> of(ToShortFunction<T> f) {
        return ToObjectFunction.of(t -> BoxTransform.box(f, t), (GenericType)BoxedShortType.of());
    }

    public static <T> ToObjectFunction<T, Integer> of(ToIntFunction<T> f) {
        return ToObjectFunction.of(t -> BoxTransform.box(f, t), (GenericType)BoxedIntType.of());
    }

    public static <T> ToObjectFunction<T, Long> of(ToLongFunction<T> f) {
        return ToObjectFunction.of(t -> BoxTransform.box(f, t), (GenericType)BoxedLongType.of());
    }

    public static <T> ToObjectFunction<T, Float> of(ToFloatFunction<T> f) {
        return ToObjectFunction.of(t -> BoxTransform.box(f, t), (GenericType)BoxedFloatType.of());
    }

    public static <T> ToObjectFunction<T, Double> of(ToDoubleFunction<T> f) {
        return ToObjectFunction.of(t -> BoxTransform.box(f, t), (GenericType)BoxedDoubleType.of());
    }

    private static <T> Character box(ToCharFunction<T> f, T x) {
        return TypeUtils.box((char)f.applyAsChar(x));
    }

    private static <T> Byte box(ToByteFunction<T> f, T x) {
        return TypeUtils.box((byte)f.applyAsByte(x));
    }

    private static <T> Short box(ToShortFunction<T> f, T x) {
        return TypeUtils.box((short)f.applyAsShort(x));
    }

    private static <T> Integer box(ToIntFunction<T> f, T x) {
        return TypeUtils.box((int)f.applyAsInt(x));
    }

    private static <T> Long box(ToLongFunction<T> f, T x) {
        return TypeUtils.box((long)f.applyAsLong(x));
    }

    private static <T> Float box(ToFloatFunction<T> f, T x) {
        return TypeUtils.box((float)f.applyAsFloat(x));
    }

    private static <T> Double box(ToDoubleFunction<T> f, T x) {
        return TypeUtils.box((double)f.applyAsDouble(x));
    }

    private static enum BoxedVisitor implements TypedFunction.Visitor<Object, ToObjectFunction<Object, ?>>,
    ToPrimitiveFunction.Visitor<Object, ToObjectFunction<Object, ?>>
    {
        INSTANCE;


        public static <T> ToObjectFunction<T, ?> of(TypedFunction<T> f) {
            return (ToObjectFunction)f.walk((TypedFunction.Visitor)INSTANCE);
        }

        public static <T> ToObjectFunction<T, ?> of(ToPrimitiveFunction<T> f) {
            return (ToObjectFunction)f.walk((ToPrimitiveFunction.Visitor)INSTANCE);
        }

        public ToObjectFunction<Object, ?> visit(ToPrimitiveFunction<Object> f) {
            return BoxTransform.of(f);
        }

        public ToObjectFunction<Object, ?> visit(ToObjectFunction<Object, ?> f) {
            return f;
        }

        public ToObjectFunction<Object, Boolean> visit(ToBooleanFunction<Object> f) {
            return BoxTransform.of(f);
        }

        public ToObjectFunction<Object, Character> visit(ToCharFunction<Object> f) {
            return BoxTransform.of(f);
        }

        public ToObjectFunction<Object, Byte> visit(ToByteFunction<Object> f) {
            return BoxTransform.of(f);
        }

        public ToObjectFunction<Object, Short> visit(ToShortFunction<Object> f) {
            return BoxTransform.of(f);
        }

        public ToObjectFunction<Object, Integer> visit(ToIntFunction<Object> f) {
            return BoxTransform.of(f);
        }

        public ToObjectFunction<Object, Long> visit(ToLongFunction<Object> f) {
            return BoxTransform.of(f);
        }

        public ToObjectFunction<Object, Float> visit(ToFloatFunction<Object> f) {
            return BoxTransform.of(f);
        }

        public ToObjectFunction<Object, Double> visit(ToDoubleFunction<Object> f) {
            return BoxTransform.of(f);
        }
    }
}

