/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.kafka;

import java.util.List;
import org.apache.avro.Schema;

public class KafkaSchemaUtils {
    public static Schema getEffectiveSchema(String fieldName, Schema fieldSchema) {
        if (fieldSchema.getType() != Schema.Type.UNION) {
            return fieldSchema;
        }
        List unionTypes = fieldSchema.getTypes();
        int unionSize = unionTypes.size();
        if (unionSize == 0) {
            throw new IllegalArgumentException("empty union " + fieldName);
        }
        if (unionSize != 2) {
            return fieldSchema;
        }
        Schema unionField0 = (Schema)unionTypes.get(0);
        Schema unionField1 = (Schema)unionTypes.get(1);
        Schema.Type unionType0 = unionField0.getType();
        Schema.Type unionType1 = unionField1.getType();
        if (unionType1 == Schema.Type.NULL) {
            return unionField0;
        }
        if (unionType0 == Schema.Type.NULL) {
            return unionField1;
        }
        return fieldSchema;
    }
}

