/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.kafka;

import io.deephaven.function.ToBooleanFunction;
import io.deephaven.function.ToByteFunction;
import io.deephaven.function.ToCharFunction;
import io.deephaven.function.ToDoubleFunction;
import io.deephaven.function.ToFloatFunction;
import io.deephaven.function.ToIntFunction;
import io.deephaven.function.ToLongFunction;
import io.deephaven.function.ToObjectFunction;
import io.deephaven.function.ToPrimitiveFunction;
import io.deephaven.function.ToShortFunction;
import io.deephaven.function.TypedFunction;
import io.deephaven.qst.type.BooleanType;
import io.deephaven.qst.type.ByteType;
import io.deephaven.qst.type.CharType;
import io.deephaven.qst.type.DoubleType;
import io.deephaven.qst.type.FloatType;
import io.deephaven.qst.type.GenericType;
import io.deephaven.qst.type.IntType;
import io.deephaven.qst.type.LongType;
import io.deephaven.qst.type.PrimitiveType;
import io.deephaven.qst.type.ShortType;
import io.deephaven.qst.type.Type;
import java.util.Optional;

class NullFunctions {
    NullFunctions() {
    }

    public static <T> Optional<TypedFunction<T>> of(Type<?> returnType) {
        return Optional.ofNullable((TypedFunction)returnType.walk((Type.Visitor)NullFunctionVisitor.INSTANCE));
    }

    public static <T> Optional<ToPrimitiveFunction<T>> of(PrimitiveType<?> returnType) {
        return Optional.ofNullable((ToPrimitiveFunction)returnType.walk((PrimitiveType.Visitor)NullFunctionVisitor.INSTANCE));
    }

    public static <T, R> ToObjectFunction<T, R> of(GenericType<R> returnType) {
        return ToObjectFunction.of(x -> null, returnType);
    }

    public static <T> ToCharFunction<T> nullCharFunction() {
        return x -> '\uffff';
    }

    public static <T> ToByteFunction<T> nullByteFunction() {
        return x -> -128;
    }

    public static <T> ToShortFunction<T> nullShortFunction() {
        return x -> Short.MIN_VALUE;
    }

    public static <T> ToIntFunction<T> nullIntFunction() {
        return x -> Integer.MIN_VALUE;
    }

    public static <T> ToLongFunction<T> nullLongFunction() {
        return x -> Long.MIN_VALUE;
    }

    public static <T> ToFloatFunction<T> nullFloatFunction() {
        return x -> -3.4028235E38f;
    }

    public static <T> ToDoubleFunction<T> nullDoubleFunction() {
        return x -> -1.7976931348623157E308;
    }

    private static enum NullFunctionVisitor implements Type.Visitor<TypedFunction<?>>,
    PrimitiveType.Visitor<ToPrimitiveFunction<?>>
    {
        INSTANCE;


        public ToPrimitiveFunction<?> visit(PrimitiveType<?> primitiveType) {
            return NullFunctions.of(primitiveType).orElse(null);
        }

        public TypedFunction<?> visit(GenericType<?> genericType) {
            return NullFunctions.of(genericType);
        }

        public ToBooleanFunction<?> visit(BooleanType booleanType) {
            return null;
        }

        public ToByteFunction<?> visit(ByteType byteType) {
            return NullFunctions.nullByteFunction();
        }

        public ToPrimitiveFunction<?> visit(CharType charType) {
            return NullFunctions.nullCharFunction();
        }

        public ToPrimitiveFunction<?> visit(ShortType shortType) {
            return NullFunctions.nullShortFunction();
        }

        public ToPrimitiveFunction<?> visit(IntType intType) {
            return NullFunctions.nullIntFunction();
        }

        public ToPrimitiveFunction<?> visit(LongType longType) {
            return NullFunctions.nullLongFunction();
        }

        public ToPrimitiveFunction<?> visit(FloatType floatType) {
            return NullFunctions.nullFloatFunction();
        }

        public ToPrimitiveFunction<?> visit(DoubleType doubleType) {
            return NullFunctions.nullDoubleFunction();
        }
    }
}

