/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.kafka;

import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.liveness.ReferenceCountedLivenessNode;
import io.deephaven.engine.table.TableDefinition;
import io.deephaven.stream.StreamChunkUtils;
import io.deephaven.stream.StreamConsumer;
import io.deephaven.stream.StreamPublisher;
import org.jetbrains.annotations.NotNull;

public abstract class StreamPublisherBase
extends ReferenceCountedLivenessNode
implements StreamPublisher {
    private static final int CHUNK_SIZE = 2048;
    private final TableDefinition tableDefinition;
    protected StreamConsumer consumer;
    protected WritableChunk<Values>[] chunks;

    protected StreamPublisherBase(@NotNull TableDefinition tableDefinition) {
        super(false);
        this.tableDefinition = tableDefinition;
    }

    public void register(@NotNull StreamConsumer consumer) {
        if (this.consumer != null) {
            throw new IllegalStateException(String.format("Can not register multiple stream consumers: %s already registered, attempted to re-register %s", this.consumer, consumer));
        }
        this.consumer = consumer;
    }

    protected synchronized WritableChunk<Values>[] getChunksToFill() {
        if (this.chunks == null) {
            this.chunks = StreamChunkUtils.makeChunksForDefinition((TableDefinition)this.tableDefinition, (int)2048);
        }
        return this.chunks;
    }

    public synchronized void flush() {
        if (this.chunks != null) {
            this.consumer.accept(this.chunks);
            this.chunks = null;
        }
    }
}

