/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.kafka.ingest;

import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.kafka.ingest.GenericRecordFieldCopier;
import io.deephaven.kafka.ingest.GenericRecordUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.regex.Pattern;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;

public class GenericRecordBigDecimalFieldCopier
extends GenericRecordFieldCopier {
    private final int scale;

    public GenericRecordBigDecimalFieldCopier(String fieldPathStr, Pattern separator, Schema schema, int precisionUnused, int scale) {
        super(fieldPathStr, separator, schema);
        this.scale = scale;
    }

    @Override
    public void copyField(ObjectChunk<Object, Values> inputChunk, WritableChunk<Values> publisherChunk, int sourceOffset, int destOffset, int length) {
        WritableObjectChunk output = publisherChunk.asWritableObjectChunk();
        for (int ii = 0; ii < length; ++ii) {
            BigDecimal bd;
            BigInteger bi;
            GenericRecord record = (GenericRecord)inputChunk.get(ii + sourceOffset);
            Object bytesObj = GenericRecordUtil.getPath(record, this.fieldPath);
            if (bytesObj == null) {
                output.set(ii + destOffset, null);
                return;
            }
            if (bytesObj instanceof byte[]) {
                byte[] bytes = (byte[])bytesObj;
                bi = new BigInteger(bytes);
                bd = new BigDecimal(bi, this.scale);
                output.set(ii + destOffset, (Object)bd);
                continue;
            }
            if (bytesObj instanceof ByteBuffer) {
                ByteBuffer bb = (ByteBuffer)bytesObj;
                if (bb.hasArray()) {
                    bi = new BigInteger(bb.array(), bb.position() + bb.arrayOffset(), bb.remaining());
                } else {
                    byte[] bytes = new byte[bb.remaining()];
                    bb.get(bytes);
                    bi = new BigInteger(bytes);
                }
                bd = new BigDecimal(bi, this.scale);
                output.set(ii + destOffset, (Object)bd);
                continue;
            }
            throw new IllegalStateException("Object of type " + bytesObj.getClass().getName() + " not recognized for decimal type backing");
        }
    }
}

