/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.kafka.ingest;

import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableDoubleChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.kafka.ingest.GenericRecordFieldCopier;
import io.deephaven.kafka.ingest.GenericRecordUtil;
import io.deephaven.util.type.TypeUtils;
import java.util.regex.Pattern;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;

public class GenericRecordDoubleFieldCopier
extends GenericRecordFieldCopier {
    public GenericRecordDoubleFieldCopier(String fieldPathStr, Pattern separator, Schema schema) {
        super(fieldPathStr, separator, schema);
    }

    @Override
    public void copyField(ObjectChunk<Object, Values> inputChunk, WritableChunk<Values> publisherChunk, int sourceOffset, int destOffset, int length) {
        WritableDoubleChunk output = publisherChunk.asWritableDoubleChunk();
        for (int ii = 0; ii < length; ++ii) {
            GenericRecord record = (GenericRecord)inputChunk.get(ii + sourceOffset);
            Double value = (Double)GenericRecordUtil.getPath(record, this.fieldPath);
            output.set(ii + destOffset, TypeUtils.unbox((Double)value));
        }
    }
}

