/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.kafka.ingest;

import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.kafka.ingest.GenericRecordFieldCopier;
import io.deephaven.kafka.ingest.GenericRecordUtil;
import io.deephaven.time.DateTimeUtils;
import java.time.Instant;
import java.util.regex.Pattern;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericRecord;

public class GenericRecordInstantArrayFieldCopier
extends GenericRecordFieldCopier {
    private final long multiplier;

    public GenericRecordInstantArrayFieldCopier(String fieldPathStr, Pattern separator, Schema schema, long multiplier) {
        super(fieldPathStr, separator, schema);
        this.multiplier = multiplier;
    }

    private static Instant[] convertArray(GenericArray<?> ga, long multiplier) {
        int gaSize = ga.size();
        if (gaSize == 0) {
            return DateTimeUtils.ZERO_LENGTH_INSTANT_ARRAY;
        }
        Instant[] out = new Instant[ga.size()];
        int i = 0;
        for (Object o : ga) {
            out[i] = DateTimeUtils.epochNanosToInstant((long)(multiplier * (Long)o));
            ++i;
        }
        return out;
    }

    @Override
    public void copyField(ObjectChunk<Object, Values> inputChunk, WritableChunk<Values> publisherChunk, int sourceOffset, int destOffset, int length) {
        WritableObjectChunk output = publisherChunk.asWritableObjectChunk();
        for (int ii = 0; ii < length; ++ii) {
            GenericRecord record = (GenericRecord)inputChunk.get(ii + sourceOffset);
            GenericArray genericArray = (GenericArray)GenericRecordUtil.getPath(record, this.fieldPath);
            if (genericArray == null) {
                output.set(ii + destOffset, null);
                continue;
            }
            output.set(ii + destOffset, (Object)GenericRecordInstantArrayFieldCopier.convertArray(genericArray, this.multiplier));
        }
    }
}

