/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.kafka.ingest;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import io.deephaven.UncheckedDeephavenException;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableByteChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.kafka.ingest.FieldCopier;
import io.deephaven.kafka.ingest.JsonNodeUtil;
import io.deephaven.util.BooleanUtils;

public class JsonNodeBooleanFieldCopier
implements FieldCopier {
    private final JsonPointer fieldPointer;

    public JsonNodeBooleanFieldCopier(String fieldPointerStr) {
        this.fieldPointer = JsonPointer.compile((String)fieldPointerStr);
    }

    @Override
    public void copyField(ObjectChunk<Object, Values> inputChunk, WritableChunk<Values> publisherChunk, int sourceOffset, int destOffset, int length) {
        WritableByteChunk output = publisherChunk.asWritableByteChunk();
        for (int ii = 0; ii < length; ++ii) {
            Boolean valueAsBoolean;
            JsonNode node = (JsonNode)inputChunk.get(ii + sourceOffset);
            String valueAsString = JsonNodeUtil.getString(node, this.fieldPointer, true, true);
            if (valueAsString == null) {
                valueAsBoolean = null;
            } else {
                switch (valueAsString.trim()) {
                    case "TRUE": 
                    case "True": 
                    case "true": 
                    case "T": 
                    case "t": 
                    case "1": {
                        valueAsBoolean = Boolean.TRUE;
                        break;
                    }
                    case "FALSE": 
                    case "False": 
                    case "false": 
                    case "F": 
                    case "f": {
                        valueAsBoolean = Boolean.FALSE;
                        break;
                    }
                    case "": {
                        valueAsBoolean = null;
                        break;
                    }
                    default: {
                        throw new UncheckedDeephavenException("value " + valueAsString + " not recognized as Boolean for field " + this.fieldPointer);
                    }
                }
            }
            output.set(ii + destOffset, BooleanUtils.booleanAsByte(valueAsBoolean));
        }
    }
}

