/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.kafka.protobuf;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.api.ColumnName;
import io.deephaven.kafka.protobuf.DescriptorMessageClass;
import io.deephaven.kafka.protobuf.DescriptorProvider;
import io.deephaven.kafka.protobuf.DescriptorSchemaRegistry;
import io.deephaven.kafka.protobuf.ImmutableProtobufConsumeOptions;
import io.deephaven.kafka.protobuf.Protocol;
import io.deephaven.protobuf.FieldPath;
import io.deephaven.protobuf.ProtobufDescriptorParserOptions;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class ProtobufConsumeOptions {
    public static Builder builder() {
        return ImmutableProtobufConsumeOptions.builder();
    }

    public static ColumnName joinNamePathWithUnderscore(FieldPath path, int indexOccurrence) {
        String simple = String.join((CharSequence)"_", path.namePath());
        return ColumnName.of((String)(indexOccurrence == 0 ? simple : simple + "_" + (indexOccurrence + 1)));
    }

    public abstract DescriptorProvider descriptorProvider();

    @Value.Default
    public Protocol protocol() {
        DescriptorProvider dp = this.descriptorProvider();
        if (dp instanceof DescriptorSchemaRegistry) {
            return Protocol.serdes();
        }
        if (dp instanceof DescriptorMessageClass) {
            return Protocol.raw();
        }
        throw new IllegalStateException(String.format("Unexpected %s class: %s", DescriptorProvider.class.getSimpleName(), dp.getClass().getName()));
    }

    @Value.Default
    public ProtobufDescriptorParserOptions parserOptions() {
        return ProtobufDescriptorParserOptions.defaults();
    }

    @Value.Default
    public FieldPathToColumnName pathToColumnName() {
        return ProtobufConsumeOptions::joinNamePathWithUnderscore;
    }

    public static interface Builder {
        public Builder protocol(Protocol var1);

        public Builder descriptorProvider(DescriptorProvider var1);

        public Builder parserOptions(ProtobufDescriptorParserOptions var1);

        public Builder pathToColumnName(FieldPathToColumnName var1);

        public ProtobufConsumeOptions build();
    }

    @FunctionalInterface
    public static interface FieldPathToColumnName {
        public ColumnName columnName(FieldPath var1, int var2);
    }
}

