/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.kafka.publish;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.chunkboxer.ChunkBoxer;
import io.deephaven.kafka.publish.KeyOrValueSerializer;
import io.deephaven.kafka.publish.PublishToKafka;
import org.jetbrains.annotations.NotNull;

public class SimpleKeyOrValueSerializer<SERIALIZED_TYPE>
implements KeyOrValueSerializer<SERIALIZED_TYPE> {
    private final ColumnSource<SERIALIZED_TYPE> source;
    private final ChunkBoxer.BoxerKernel boxer;

    public SimpleKeyOrValueSerializer(Table table, String columnName) {
        this.source = table.getColumnSource(columnName);
        this.boxer = ChunkBoxer.getBoxer((ChunkType)this.source.getChunkType(), (int)PublishToKafka.CHUNK_SIZE);
    }

    @Override
    public ObjectChunk<SERIALIZED_TYPE, Values> handleChunk(@NotNull KeyOrValueSerializer.Context context, @NotNull RowSequence rowSequence, boolean previous) {
        SimpleContext simpleContext = (SimpleContext)context;
        Chunk chunk = previous ? this.source.getPrevChunk(simpleContext.sourceGetContext, rowSequence) : this.source.getChunk(simpleContext.sourceGetContext, rowSequence);
        return this.boxer.box(chunk);
    }

    @Override
    public KeyOrValueSerializer.Context makeContext(int size) {
        return new SimpleContext(size);
    }

    private class SimpleContext
    implements KeyOrValueSerializer.Context {
        private final ChunkSource.GetContext sourceGetContext;

        private SimpleContext(int size) {
            this.sourceGetContext = SimpleKeyOrValueSerializer.this.source.makeGetContext(size);
        }

        public void close() {
            this.sourceGetContext.close();
        }
    }
}

