/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.base;

import io.deephaven.parquet.base.BulkWriter;
import java.io.IOException;
import java.nio.IntBuffer;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.column.values.rle.RunLengthBitPackingHybridEncoder;
import org.jetbrains.annotations.NotNull;

abstract class AbstractBulkValuesWriter<BUFFER_TYPE>
extends ValuesWriter
implements BulkWriter<BUFFER_TYPE> {
    private static final int RL_FIRST_ELEM = 0;
    private static final int RL_CONSECUTIVE_ELEM = 1;
    private static final int DL_VECTOR_NULL_VECTOR = 0;
    private static final int DL_VECTOR_EMPTY_VECTOR = 1;
    private static final int DL_VECTOR_NULL_ELEMENT = 2;
    private static final int DL_VECTOR_ACTUAL_VALUE = 3;
    static final int DL_ITEM_NULL = 0;
    static final int DL_ITEM_PRESENT = 1;

    AbstractBulkValuesWriter() {
    }

    @Override
    public int writeBulkVector(@NotNull BUFFER_TYPE bulkValues, @NotNull IntBuffer vectorSizes, @NotNull RunLengthBitPackingHybridEncoder rlEncoder, @NotNull RunLengthBitPackingHybridEncoder dlEncoder, int nonNullValueCount, @NotNull Statistics<?> statistics) throws IOException {
        IntBuffer nullsOffsets = this.writeBulkVectorFilterNulls(bulkValues, (int)nonNullValueCount, statistics).nullOffsets;
        return this.applyDlAndRl(vectorSizes, rlEncoder, dlEncoder, nullsOffsets, statistics);
    }

    int applyDlAndRl(@NotNull IntBuffer vectorSizes, @NotNull RunLengthBitPackingHybridEncoder rlEncoder, @NotNull RunLengthBitPackingHybridEncoder dlEncoder, @NotNull IntBuffer nullsOffsets, @NotNull Statistics<?> statistics) throws IOException {
        int nextNullOffset;
        int valueCount = 0;
        int leafCount = 0;
        nullsOffsets.flip();
        int n = nextNullOffset = nullsOffsets.hasRemaining() ? nullsOffsets.get() : Integer.MAX_VALUE;
        while (vectorSizes.hasRemaining()) {
            int length = vectorSizes.get();
            if (length != Integer.MIN_VALUE) {
                if (length == 0) {
                    dlEncoder.writeInt(1);
                } else {
                    if (leafCount == nextNullOffset) {
                        nextNullOffset = nullsOffsets.hasRemaining() ? nullsOffsets.get() : Integer.MAX_VALUE;
                        dlEncoder.writeInt(2);
                    } else {
                        dlEncoder.writeInt(3);
                    }
                    ++leafCount;
                }
                ++valueCount;
                rlEncoder.writeInt(0);
                for (int i = 1; i < length; ++i) {
                    if (leafCount++ == nextNullOffset) {
                        nextNullOffset = nullsOffsets.hasRemaining() ? nullsOffsets.get() : Integer.MAX_VALUE;
                        dlEncoder.writeInt(2);
                    } else {
                        dlEncoder.writeInt(3);
                    }
                    rlEncoder.writeInt(1);
                    ++valueCount;
                }
                continue;
            }
            ++valueCount;
            dlEncoder.writeInt(0);
            rlEncoder.writeInt(0);
            statistics.incrementNumNulls();
        }
        return valueCount;
    }
}

