/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.base;

import io.deephaven.datastructures.util.CollectionUtil;
import io.deephaven.util.codec.ObjectCodec;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import org.apache.parquet.schema.PrimitiveType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BigDecimalParquetBytesCodec
implements ObjectCodec<BigDecimal> {
    private static final int MIN_DECIMAL_INT_PRECISION = 1;
    private static final int MAX_DECIMAL_INT_PRECISION = 9;
    private static final int MIN_DECIMAL_LONG_PRECISION = 1;
    private static final int MAX_DECIMAL_LONG_PRECISION = 18;
    private final int precision;
    private final int scale;
    private final int encodedSizeInBytes;
    private final RoundingMode roundingMode;
    private final byte[] nullBytes;

    public static void verifyPrecisionAndScale(int precision, int scale) {
        if (precision <= 0) {
            throw new IllegalArgumentException(String.format("precision (=%d) should be > 0", precision));
        }
        if (scale < 0) {
            throw new IllegalArgumentException(String.format("scale (=%d) should be >= 0", scale));
        }
        if (scale > precision) {
            throw new IllegalArgumentException(String.format("scale (=%d) is greater than precision (=%d)", scale, precision));
        }
    }

    public static void verifyPrecisionAndScale(int precision, int scale, PrimitiveType.PrimitiveTypeName primitiveType) {
        BigDecimalParquetBytesCodec.verifyPrecisionAndScale(precision, scale);
        if (primitiveType == PrimitiveType.PrimitiveTypeName.INT32) {
            if (precision < 1 || precision > 9) {
                throw new IllegalArgumentException(String.format("Column with decimal logical type and INT32 primitive type should have precision in range [%d, %d], found column with precision %d", 1, 9, precision));
            }
        } else if (primitiveType == PrimitiveType.PrimitiveTypeName.INT64 && (precision < 1 || precision > 18)) {
            throw new IllegalArgumentException(String.format("Column with decimal logical type and INT64 primitive type should have precision in range [%d, %d], found column with precision %d", 1, 18, precision));
        }
    }

    public BigDecimalParquetBytesCodec(int precision, int scale, int encodedSizeInBytes, RoundingMode roundingMode) {
        BigDecimalParquetBytesCodec.verifyPrecisionAndScale(precision, scale);
        this.precision = precision;
        this.scale = scale;
        this.encodedSizeInBytes = encodedSizeInBytes;
        this.roundingMode = roundingMode;
        if (encodedSizeInBytes > 0) {
            this.nullBytes = new byte[encodedSizeInBytes];
            for (int i = 0; i < encodedSizeInBytes; ++i) {
                this.nullBytes[i] = -1;
            }
        } else {
            this.nullBytes = CollectionUtil.ZERO_LENGTH_BYTE_ARRAY;
        }
    }

    public BigDecimalParquetBytesCodec(int precision, int scale, int encodedSizeInBytes) {
        this(precision, scale, encodedSizeInBytes, RoundingMode.HALF_UP);
    }

    public BigDecimalParquetBytesCodec(int precision, int scale) {
        this(precision, scale, -1);
    }

    public boolean isNullable() {
        return true;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    @NotNull
    public byte[] encode(@Nullable BigDecimal input) {
        if (input == null) {
            return this.nullBytes;
        }
        BigDecimal value = input.setScale(this.scale, this.roundingMode);
        if (value.precision() > this.precision) {
            throw new ArithmeticException(String.format("Unable to encode '%s' with %s", value, this.decimalTypeToString()));
        }
        BigInteger unscaledValue = value.unscaledValue();
        return unscaledValue.toByteArray();
    }

    @Nullable
    public BigDecimal decode(@NotNull byte[] input, int offset, int length) {
        if (length <= 0) {
            return null;
        }
        if (length == this.encodedSizeInBytes) {
            boolean allPreviousBitsSet = true;
            for (int i = 0; i < this.encodedSizeInBytes; ++i) {
                if (input[offset + i] == -1) continue;
                allPreviousBitsSet = false;
                break;
            }
            if (allPreviousBitsSet) {
                return null;
            }
        }
        ByteBuffer buffer = ByteBuffer.wrap(input, offset, length);
        byte[] unscaledValueBytes = new byte[length];
        buffer.get(unscaledValueBytes);
        BigInteger unscaledValue = new BigInteger(unscaledValueBytes);
        BigDecimal value = new BigDecimal(unscaledValue, this.scale);
        if (value.precision() > this.precision) {
            throw new ArithmeticException(String.format("Unable to decode '%s' with %s", value, this.decimalTypeToString()));
        }
        return value;
    }

    public int expectedObjectWidth() {
        return this.encodedSizeInBytes <= 0 ? Integer.MIN_VALUE : this.encodedSizeInBytes;
    }

    private String decimalTypeToString() {
        return String.format("DecimalType(scale=%d, precision=%d)", this.scale, this.precision);
    }
}

